package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.entities.PollenDAOHelper.PollenEntityEnum;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PersonListDAOAbstract<E extends PersonList> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)PersonList.class;
    }

    @Override
    public PollenEntityEnum getTopiaEntityEnum() {
        return PollenEntityEnum.PersonList;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<PollAccount> list = getContext()
                                                    .getDAO(PollAccount.class)
                                                    .findAllByProperties(PollAccount.PROPERTY_PERSON_LIST, entity);
                                            for (PollAccount item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getPersonList())) {
                                                    item.setPersonList(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(PersonList.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(PersonList.PROPERTY_NAME, v);
        return result;
    }

    public E findByOwner(UserAccount v) throws TopiaException {
        E result = findByProperty(PersonList.PROPERTY_OWNER, v);
        return result;
    }

    public List<E> findAllByOwner(UserAccount v) throws TopiaException {
        List<E> result = findAllByProperty(PersonList.PROPERTY_OWNER, v);
        return result;
    }

    public E findContainsPollAccount(PollAccount v) throws TopiaException {
        E result = findContains(PersonList.PROPERTY_POLL_ACCOUNT, v);
        return result;
    }

    public List<E> findAllContainsPollAccount(PollAccount v) throws TopiaException {
        List<E> result = findAllContains(PersonList.PROPERTY_POLL_ACCOUNT, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == PollAccount.class) {
            PollAccountDAO dao = (PollAccountDAO)
                getContext().getDAO(PollAccount.class);
            tmp = dao.findAllByPersonList(entity);
            result.addAll(tmp);
        }

        if (type == UserAccount.class) {
            UserAccountDAO dao = (UserAccountDAO)
                getContext().getDAO(UserAccount.class);
            tmp = dao.findAllContainsFavoriteList(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(PollAccount.class, entity);
        if (!list.isEmpty()) {
            result.put(PollAccount.class, list);
        }

        list = findUsages(UserAccount.class, entity);
        if (!list.isEmpty()) {
            result.put(UserAccount.class, list);
        }

        return result;
    }

} //PersonListDAOAbstract<E extends PersonList>
