package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.entities.PollenDAOHelper.PollenEntityEnum;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class VoteToChoiceDAOAbstract<E extends VoteToChoice> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)VoteToChoice.class;
    }

    @Override
    public PollenEntityEnum getTopiaEntityEnum() {
        return PollenEntityEnum.VoteToChoice;
    }

    public E findByVoteValue(Integer v) throws TopiaException {
        E result = findByProperty(VoteToChoice.PROPERTY_VOTE_VALUE, v);
        return result;
    }

    public List<E> findAllByVoteValue(Integer v) throws TopiaException {
        List<E> result = findAllByProperty(VoteToChoice.PROPERTY_VOTE_VALUE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //VoteToChoiceDAOAbstract<E extends VoteToChoice>
