/*
 * #%L
 * Pollen :: Persistence
 * $Id: UserAccountDAOImpl.java 3691 2012-09-14 16:33:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-persistence/src/main/java/org/chorem/pollen/business/persistence/UserAccountDAOImpl.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;

import java.util.List;

public class UserAccountDAOImpl<E extends UserAccount> extends UserAccountDAOAbstract<E> {

    public boolean isUserExist(UserAccount user) throws TopiaException {

        Preconditions.checkNotNull(user);

        // In case of email change, check if an other user has not already
        // the new email
        // FIXME-fdesbois-20100510 : replace by using id directly
        String hql = "SELECT COUNT(*) FROM UserAccountImpl WHERE " +
                     "login = :login AND email = :email";

        boolean result = existsByQuery(
                hql,
                "login", user.getLogin(),
                "email", StringUtils.lowerCase(user.getEmail()));
        return result;
    }

    public List<E> findUsers(TopiaPagerBean pager) throws TopiaException {

        Preconditions.checkNotNull(pager);

        String hql = createSimpleQuery("e");

        String countHql = "SELECT COUNT(*) " + hql;

        computeAndAddRecordsToPager(countHql, pager);

        List<E> result = findAllByQueryAndPager(hql, pager);
        return result;
    }
}
