/*
 * #%L
 * Pollen :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.entities.PollenDAOHelper.PollenEntityEnum;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class VotingListDAOAbstract<E extends VotingList> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)VotingList.class;
    }

    @Override
    public PollenEntityEnum getTopiaEntityEnum() {
        return PollenEntityEnum.VotingList;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Vote> list = getContext()
                                                    .getDAO(Vote.class)
                                                    .findAllByProperties(Vote.PROPERTY_VOTING_LIST, entity);
                                            for (Vote item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getVotingList())) {
                                                    item.setVotingList(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(VotingList.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(VotingList.PROPERTY_NAME, v);
        return result;
    }

    public E findByWeight(double v) throws TopiaException {
        E result = findByProperty(VotingList.PROPERTY_WEIGHT, v);
        return result;
    }

    public List<E> findAllByWeight(double v) throws TopiaException {
        List<E> result = findAllByProperty(VotingList.PROPERTY_WEIGHT, v);
        return result;
    }

    public E findByPoll(Poll v) throws TopiaException {
        E result = findByProperty(VotingList.PROPERTY_POLL, v);
        return result;
    }

    public List<E> findAllByPoll(Poll v) throws TopiaException {
        List<E> result = findAllByProperty(VotingList.PROPERTY_POLL, v);
        return result;
    }

    public E findByVote(Vote v) throws TopiaException {
        E result = findByProperty(VotingList.PROPERTY_VOTE, v);
        return result;
    }

    public List<E> findAllByVote(Vote v) throws TopiaException {
        List<E> result = findAllByProperty(VotingList.PROPERTY_VOTE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Vote.class) {
            VoteDAO dao = (VoteDAO)
                getContext().getDAO(Vote.class);
            tmp = dao.findAllByVotingList(entity);
            result.addAll(tmp);
        }

        if (type == Poll.class) {
            PollDAO dao = (PollDAO)
                getContext().getDAO(Poll.class);
            tmp = dao.findAllContainsVotingList(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Vote.class, entity);
        if (!list.isEmpty()) {
            result.put(Vote.class, list);
        }

        list = findUsages(Poll.class, entity);
        if (!list.isEmpty()) {
            result.put(Poll.class, list);
        }

        return result;
    }

} //VotingListDAOAbstract<E extends VotingList>
