/*
 * #%L
 * Pollen :: Persistence
 * 
 * $Id: PollDAOImpl.java 3329 2012-04-30 10:45:14Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-persistence/src/main/java/org/chorem/pollen/business/persistence/PollDAOImpl.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.entities.PollenDAOHelper;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

import java.util.List;
import java.util.Map;

public class PollDAOImpl<E extends Poll> extends PollDAOAbstract<E> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(PollDAOImpl.class);

    public List<E> getPolls(TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {

        Preconditions.checkNotNull(pager);

        long records = count();
        pager.setRecords((int) records);

        TopiaQuery query = createQuery("e");
        TopiaFilterPagerUtil.addPagerToQuery(query, pager);

        List<E> result = findAllByQuery(query);
        return result;
    }


    public List<E> getCreatedPolls(TopiaFilterPagerUtil.FilterPagerBean pager,
                                   UserAccount user) throws TopiaException {

        Preconditions.checkNotNull(pager);
        Preconditions.checkNotNull(user);

        TopiaQuery countQuery = createQuery("e");
        countQuery.addWhere("e." + Poll.PROPERTY_CREATOR + "." + PollAccount.PROPERTY_USER_ACCOUNT, TopiaQuery.Op.EQ, user);
        long records = countByQuery(countQuery);
        pager.setRecords((int) records);

        TopiaQuery query = TopiaFilterPagerUtil.addPagerToQuery(countQuery, pager);

        List<E> result = findAllByQuery(query);
        return result;
    }

    public Map<Poll, PollAccount> getInvitedPolls(
            TopiaFilterPagerUtil.FilterPagerBean pager,
            UserAccount userToUse) throws TopiaException {

        Preconditions.checkNotNull(pager);
        Preconditions.checkNotNull(userToUse);

        //FIXME Use a query to do this to avoid in memory pagination
        String email = userToUse.getEmail();

        TopiaQuery countQuery = createQuery("p");
        countQuery.addLeftJoin("p." + Poll.PROPERTY_VOTING_LIST, "v", false);
        countQuery.addLeftJoin("v." + VotingList.PROPERTY_POLL_ACCOUNT_PERSON_TO_LIST, "l", false);
        countQuery.addEquals("l." + PersonToList.PROPERTY_POLL_ACCOUNT
                             + "." + PollAccount.PROPERTY_EMAIL, email);
        long records = countByQuery(countQuery);
        pager.setRecords((int) records);
        
        TopiaQuery query = TopiaFilterPagerUtil.addPagerToQuery(countQuery, pager);

        return findAllWithPollAccounts(query,
                                       "p",
                                       "l." + PersonToList.PROPERTY_POLL_ACCOUNT);

//        List<E> polls = findAll();
//        List<E> allPolls = Lists.newLinkedList();
//        for (E poll : polls) {
//            for (VotingList votingList : poll.getVotingList()) {
//                for (PersonToList personToList : votingList
//                        .getPollAccountPersonToList()) {
//                    if (!personToList.isHasVoted()) {
//                        PollAccount pollAccount = personToList
//                                .getPollAccount();
//
//                        if (pollAccount != null
//                            && pollAccount.getEmail() != null
//                            && pollAccount.getEmail().equals(
//                                email)) {
//                            allPolls.add(poll);
//                        }
//                    }
//                }
//            }
//        }
//
//        int records = allPolls.size();
//        pager.setRecords(records);
//
//        List<E> result = TopiaFilterPagerUtil.getPageFromList(allPolls, pager);
//        return result;

//        try {
//            PollDAO dao = PollenDAOHelper.getPollDAO(getTransaction());
//            TopiaQuery countQuery = dao.createQuery("e");
//            countQuery.addWhere("e." + Poll.PROPERTY_CREATOR + "." + PollAccount.PROPERTY_USER_ACCOUNT, TopiaQuery.Op.EQ, user);
//            long records = dao.countByQuery(countQuery);
//            pager.setRecords((int) records);
//
//            PagerUtil.computeRecordIndexesAndPagesNumber(pager);
//            TopiaQuery query = dao.createQuery("e");
//            TopiaFilterPagerUtil.addPagerToQuery(pager, query);
//            query.addWhere("e." + Poll.PROPERTY_CREATOR + "." + PollAccount.PROPERTY_USER_ACCOUNT, TopiaQuery.Op.EQ, user);
//
//            List<Poll> result = dao.findAllByQuery(query);
//            return result;
//        } catch (TopiaException e) {
//            throw new PollenTechnicalException(e);
//        }
    }

    public Map<Poll, PollAccount> getParticipatedPolls(
            TopiaFilterPagerUtil.FilterPagerBean pager,
            UserAccount userToUse) throws TopiaException {

        Preconditions.checkNotNull(pager);
        Preconditions.checkNotNull(userToUse);

        VoteDAO voteDao = PollenDAOHelper.getVoteDAO(context);

        TopiaQuery countQuery = voteDao.createQuery("e").
                addDistinct().
                setSelect("e." + Vote.PROPERTY_POLL).
                addWhere("e." + Vote.PROPERTY_POLL_ACCOUNT + "." + PollAccount.PROPERTY_USER_ACCOUNT, TopiaQuery.Op.EQ, userToUse);

        long records = countByQuery(countQuery);
        pager.setRecords((int) records);

        TopiaQuery query = TopiaFilterPagerUtil.addPagerToQuery(countQuery, pager);

        return findAllWithPollAccounts(query,
                                       "e." + Vote.PROPERTY_POLL,
                                       "e." + Vote.PROPERTY_POLL_ACCOUNT);
    }
    
    protected Map<Poll, PollAccount> findAllWithPollAccounts(TopiaQuery query,
                                                                           String pollAlias,
                                                                           String pollAccountAlias)
            throws TopiaException {

        // Select both poll and pollAccount
        query.setSelect(pollAlias, pollAccountAlias);

        List<Object[]> queryResults = getContext().findByQuery(query);
        Map<Poll, PollAccount> result = Maps.newLinkedHashMap();
        for (Object[] row : queryResults) {
            Poll poll = (Poll) row[0];
            PollAccount pollAccount = (PollAccount) row[1];
            result.put(poll, pollAccount);
        }
        return result;
    }

    public List<E> getRunningPolls(boolean withEndDate) throws TopiaException {

        List<E> results;
        TopiaQuery query;

        if (withEndDate) {

            query = createQuery("poll").
                    addWhere("poll.endDate is not null and poll.endDate > current_timestamp()").
                    addWhere("poll.beginDate is null or poll.beginDate < current_timestamp()");

//                results = transaction
//                        .find("from "
//                              + Poll.class.getName()
//                              + " as poll where (poll.endDate is not null and poll.endDate > current_timestamp())"
//                              + " and (poll.beginDate is null or poll.beginDate < current_timestamp())");
        } else {
            query = createQuery("poll").
                    addWhere("poll.endDate is null or poll.endDate > current_timestamp()").
                    addWhere("poll.beginDate is null or poll.beginDate < current_timestamp()");

//                results = transaction
//                        .find("from "
//                              + Poll.class.getName()
//                              + " as poll where (poll.endDate is null or poll.endDate > current_timestamp())"
//                              + " and (poll.beginDate is null or poll.beginDate < current_timestamp())");
        }

        results = findAllByQuery(query);

        if (log.isDebugEnabled()) {
            log.debug("Entities found: "
                      + ((results == null) ? "null" : results.size()));
        }
        return results;
    }
} //PollDAOImpl<E extends Poll>
