/*
 * #%L
 * Pollen :: Persistence
 * 
 * $Id: PersonListDAOImpl.java 3180 2012-03-14 14:39:03Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-persistence/src/main/java/org/chorem/pollen/business/persistence/PersonListDAOImpl.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

import java.util.List;

public class PersonListDAOImpl<E extends PersonList> extends PersonListDAOAbstract<E> {

    public List<E> getFavoriteLists(UserAccount user,
                                    TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {

        Preconditions.checkNotNull(user);

        TopiaQuery countQuery = createQuery("e");
        countQuery.addWhere("e." + PersonList.PROPERTY_OWNER, TopiaQuery.Op.EQ, user);
        long records = countByQuery(countQuery);

        pager.setRecords((int) records);

        TopiaQuery query = TopiaFilterPagerUtil.addPagerToQuery(countQuery, pager);

        List<E> result = findAllByQuery(query);
        return result;
    }

    public List<E> getFavoriteLists(UserAccount user) throws TopiaException {

        Preconditions.checkNotNull(user);

        TopiaQuery query = createQuery("e");
        query.addWhere("e." + PersonList.PROPERTY_OWNER, TopiaQuery.Op.EQ, user);
        List<E> result = findAllByQuery(query);
        return result;

    }

    public boolean isPersonListExist(UserAccount user, String name) throws TopiaException {

        Preconditions.checkNotNull(user);
        Preconditions.checkNotNull(name);

        // can't accept favorite list without name
        Preconditions.checkArgument(StringUtils.isNotEmpty(name));


        // check list does not already exists

        TopiaQuery query = createQuery("e");

        query.addWhere("e." + PersonList.PROPERTY_OWNER, TopiaQuery.Op.EQ, user);
        query.addWhere("e." + PersonList.PROPERTY_NAME, TopiaQuery.Op.EQ, name);

        boolean exist = existByQuery(query);
        return exist;
    }

} //PersonListDAOImpl<E extends PersonList>
