package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class ChoiceAbstract extends TopiaEntityAbstract implements Choice {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : description
     */
    protected String description;

    /**
     * Nom de l'attribut en BD : validate
     */
    protected boolean validate;

    /**
     * Nom de l'attribut en BD : vote
     */
    protected List<VoteToChoice> voteVoteToChoice;

    /**
     * Nom de l'attribut en BD : poll
     */
    protected Poll poll;

    private static final long serialVersionUID = 7017002068803084601L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_DESCRIPTION, String.class, description);
        visitor.visit(this, PROPERTY_VALIDATE, boolean.class, validate);
        visitor.visit(this, PROPERTY_VOTE_VOTE_TO_CHOICE, List.class, VoteToChoice.class, voteVoteToChoice);
        visitor.visit(this, PROPERTY_POLL, Poll.class, poll);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setDescription(String description) {
        String oldValue = this.description;
        fireOnPreWrite(PROPERTY_DESCRIPTION, oldValue, description);
        this.description = description;
        fireOnPostWrite(PROPERTY_DESCRIPTION, oldValue, description);
    }

    @Override
    public String getDescription() {
        fireOnPreRead(PROPERTY_DESCRIPTION, description);
        String result = this.description;
        fireOnPostRead(PROPERTY_DESCRIPTION, description);
        return result;
    }

    @Override
    public void setValidate(boolean validate) {
        boolean oldValue = this.validate;
        fireOnPreWrite(PROPERTY_VALIDATE, oldValue, validate);
        this.validate = validate;
        fireOnPostWrite(PROPERTY_VALIDATE, oldValue, validate);
    }

    @Override
    public boolean isValidate() {
        fireOnPreRead(PROPERTY_VALIDATE, validate);
        boolean result = this.validate;
        fireOnPostRead(PROPERTY_VALIDATE, validate);
        return result;
    }

    @Override
    public void addVoteVoteToChoice(VoteToChoice voteVoteToChoice) {
        fireOnPreWrite(PROPERTY_VOTE_VOTE_TO_CHOICE, null, voteVoteToChoice);
        if (this.voteVoteToChoice == null) {
            this.voteVoteToChoice = new ArrayList<VoteToChoice>();
        }

        this.voteVoteToChoice.add(voteVoteToChoice);
        fireOnPostWrite(PROPERTY_VOTE_VOTE_TO_CHOICE, this.voteVoteToChoice.size(), null, voteVoteToChoice);
    }

    @Override
    public void addAllVoteVoteToChoice(List<VoteToChoice> voteVoteToChoice) {
        if (voteVoteToChoice == null) {
            return;
        }
        for (VoteToChoice item : voteVoteToChoice) {
            addVoteVoteToChoice(item);
        }
    }

    @Override
    public void setVoteVoteToChoice(List<VoteToChoice> voteVoteToChoice) {
        // Copy elements to keep data for fire with new reference
        List<VoteToChoice> oldValue = this.voteVoteToChoice != null ? new ArrayList<VoteToChoice>(this.voteVoteToChoice) : null;
        fireOnPreWrite(PROPERTY_VOTE_VOTE_TO_CHOICE, oldValue, voteVoteToChoice);
        this.voteVoteToChoice = voteVoteToChoice;
        fireOnPostWrite(PROPERTY_VOTE_VOTE_TO_CHOICE, oldValue, voteVoteToChoice);
    }

    @Override
    public void removeVoteVoteToChoice(VoteToChoice voteVoteToChoice) {
        fireOnPreWrite(PROPERTY_VOTE_VOTE_TO_CHOICE, voteVoteToChoice, null);
        if (this.voteVoteToChoice == null || !this.voteVoteToChoice.remove(voteVoteToChoice)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_VOTE_VOTE_TO_CHOICE, this.voteVoteToChoice.size() + 1, voteVoteToChoice, null);
    }

    @Override
    public void clearVoteVoteToChoice() {
        if (this.voteVoteToChoice == null) {
            return;
        }
        for (VoteToChoice item : this.voteVoteToChoice) {
        }
        List<VoteToChoice> oldValue = new ArrayList<VoteToChoice>(this.voteVoteToChoice);
        fireOnPreWrite(PROPERTY_VOTE_VOTE_TO_CHOICE, oldValue, this.voteVoteToChoice);
        this.voteVoteToChoice.clear();
        fireOnPostWrite(PROPERTY_VOTE_VOTE_TO_CHOICE, oldValue, this.voteVoteToChoice);
    }

    @Override
    public List<VoteToChoice> getVoteVoteToChoice() {
        return voteVoteToChoice;
    }

    @Override
    public VoteToChoice getVoteVoteToChoiceByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(voteVoteToChoice, topiaId);
    }

    @Override
    public VoteToChoice getVoteVoteToChoice(Vote vote) {
        if (vote == null || this.voteVoteToChoice == null) {
            return null;
        }
        for (VoteToChoice item : this.voteVoteToChoice) {
            if (vote.equals(item.getVote())) {
                return item;
            }
        }
        return null;
    }

    @Override
    public int sizeVoteVoteToChoice() {
        if (voteVoteToChoice == null) {
            return 0;
        }
        return voteVoteToChoice.size();
    }

    @Override
    public boolean isVoteVoteToChoiceEmpty() {
        int size = sizeVoteVoteToChoice();
        return size == 0;
    }

    @Override
    public void setPoll(Poll poll) {
        Poll oldValue = this.poll;
        fireOnPreWrite(PROPERTY_POLL, oldValue, poll);
        this.poll = poll;
        fireOnPostWrite(PROPERTY_POLL, oldValue, poll);
    }

    @Override
    public Poll getPoll() {
        fireOnPreRead(PROPERTY_POLL, poll);
        Poll result = this.poll;
        fireOnPostRead(PROPERTY_POLL, poll);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<VoteToChoice> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(VoteToChoice.class);
            List<VoteToChoice> findAllByProperties = dao.findAllByProperties("choice", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //ChoiceAbstract
