/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.util.Locale;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@Import(library={"${tapestry.scriptaculous}/controls.js", "${tapestry.scriptaculous}/slider.js"}, stylesheet={"Slider.css"})
public class Slider
implements ClientElement {
    private static final String handleCSS = "ck_slider-handle";
    private static final String trackCSS = "ck_slider-track";
    private static final String valueCSS = "ck_slider-value";
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(required=true)
    private Number value;
    @Parameter(value="0", required=false)
    private Number min;
    @Parameter(value="100", required=false)
    private Number max;
    @Parameter(value="1", required=false)
    private Number inc;
    @Parameter(value="false", required=false)
    private boolean disabled;
    @Inject
    private ComponentResources componentResources;
    @Inject
    private Request request;
    private String handleId;
    private String tackId;
    private String ouputId;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    private String assignedClientId;

    void setupRender() {
        this.assignedClientId = this.javascriptSupport.allocateClientId(this.clientId);
    }

    void beginRender(MarkupWriter writer) {
        this.handleId = "handle_" + this.getClientId();
        this.tackId = "track_" + this.getClientId();
        this.ouputId = "ouput_" + this.getClientId();
        writer.element("div", new Object[]{"id", this.tackId, "class", trackCSS});
        writer.element("div", new Object[]{"id", this.handleId, "class", handleCSS});
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
        writer.end();
        writer.element("div", new Object[]{"id", this.ouputId, "class", valueCSS});
        if (this.value == null) {
            this.value = 0;
        }
        writer.write(this.value.toString());
        writer.end();
        String jsCommand = "new Control.Slider('%s','%s',{sliderValue:" + this.getNumberPattern(this.value) + ",range:" + "$R(" + this.getNumberPattern(this.min) + "," + this.getNumberPattern(this.max) + "),increment:" + this.getNumberPattern(this.inc) + ",onSlide:function(v){$('%s').innerHTML = v}";
        jsCommand = String.format(Locale.US, jsCommand, this.handleId, this.tackId, this.value, this.min, this.max, this.inc, this.ouputId);
        if (this.disabled) {
            jsCommand = jsCommand + ",disabled:true";
        }
        jsCommand = jsCommand + ", onChange:function(value){$('%s').innerHTML = value; new Ajax.Request('%s/' + value,{method:'get', onFailure: function(){ alert('%s')}})}});";
        jsCommand = String.format(Locale.US, jsCommand, this.ouputId, this.getActionLink(), "Something went wrong...");
        this.javascriptSupport.addScript(jsCommand, new Object[0]);
    }

    @OnEvent(value="action")
    private void onAction(Number value) {
        this.value = value;
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.value = value;
    }

    public String getActionLink() {
        return this.componentResources.createEventLink("action", new Object[0]).toURI();
    }

    private String getNumberPattern(Number value) {
        String numberPattern = "%d";
        if (value instanceof Float || value instanceof Double) {
            numberPattern = "%f";
        }
        return numberPattern;
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

