/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;

@SupportsInformalParameters
@IncludeJavaScriptLibrary(value={"../Chenillekit.js", "RoundCornerContainer.js"})
@IncludeStylesheet(value={"RoundCornerContainer.css"})
public class RoundCornerContainer
implements ClientElement {
    public static final String RENDER_BOTH = "both";
    public static final String RENDER_TOP = "top";
    public static final String RENDER_BOTTOM = "bottom";
    @Parameter(value="both", required=false, defaultPrefix="literal")
    private String renderPart;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(value="#FFFFFF", required=false, defaultPrefix="literal")
    private String bgcolor;
    @Parameter(value="#9BD1FA", required=false, defaultPrefix="literal")
    private String fgcolor;
    @Parameter(value="", required=false, defaultPrefix="literal")
    private String size;
    @Inject
    private ComponentResources resources;
    @Environmental
    private RenderSupport pageRenderSupport;
    private String _assignedClientId;

    void setupRender() {
        this._assignedClientId = this.pageRenderSupport.allocateClientId(this.clientId);
    }

    void beginRender(MarkupWriter writer) {
        writer.element("div", new Object[]{"id", this.getClientId()});
        this.resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
        this.pageRenderSupport.addScript("var %s = new Ck.Rounded('%s', '%s', '%s', '%s', '%s');", new Object[]{this.getClientId(), this.getClientId(), this.bgcolor, this.fgcolor, this.size, this.renderPart});
        this.pageRenderSupport.addScript("%s.round();", new Object[]{this.getClientId()});
    }

    public String getClientId() {
        return this._assignedClientId;
    }
}

