/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Request;
import org.chenillekit.image.services.CaptchaProducer;
import org.chenillekit.tapestry.core.utils.JPEGInline;

public class Kaptcha
extends AbstractField {
    private static final String EVENT_NAME = "kaptchaEvent";
    @Parameter(required=true, defaultPrefix="prop")
    private boolean value;
    @Persist
    private String kaptchaValue;
    private String textFieldValue;
    @Inject
    private ComponentResources resources;
    @Inject
    private Request request;
    @Inject
    private CaptchaProducer kaptchaProducer;

    void beginRender(MarkupWriter writer) {
        writer.element("span", new Object[]{"id", this.getClientId(), "class", "ck-kaptcha"});
        writer.element("img", new Object[]{"id", String.format("%s_kaptcha", this.getClientId()), "src", this.getImageLink(), "class", "ck-kaptcha"});
        writer.end();
        writer.element("input", new Object[]{"id", String.format("%s_input", this.getClientId()), "type", "text", "name", this.getControlName(), "value", this.textFieldValue, "class", "ck-kaptcha"});
        writer.end();
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    private Link getImageLink() {
        return this.resources.createEventLink(EVENT_NAME, new Object[]{this.kaptchaProducer.createText()});
    }

    @OnEvent(value="kaptchaEvent")
    public StreamResponse onKaptchaImage(String kaptchaValue) {
        this.kaptchaValue = kaptchaValue;
        BufferedImage kapatchImage = this.kaptchaProducer.createImage(this.kaptchaValue);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)kapatchImage, "jpg", byteArrayOutputStream);
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return new JPEGInline(bais, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processSubmission(String elementName) {
        String rawValue = this.request.getParameter(elementName);
        this.value = this.kaptchaValue.equals(rawValue);
    }
}

