/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.util.TextStreamResponse;

@SupportsInformalParameters
@IncludeJavaScriptLibrary(value={"${tapestry.scriptaculous}/controls.js"})
public class InPlaceEditor
implements ClientElement {
    public static final String SAVE_EVENT = "save";
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(required=true, principal=true)
    private String value;
    @Parameter(value="20", required=false, defaultPrefix="literal")
    private String size;
    @Parameter(required=false)
    private List<?> context;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    @Environmental
    private RenderSupport renderSupport;
    @Inject
    private Request request;
    private String assignedClientId;
    private Object[] contextArray;

    void setupRender() {
        this.assignedClientId = this.renderSupport.allocateClientId(this.clientId);
        this.contextArray = this.context == null ? new Object[]{} : this.context.toArray();
    }

    void beginRender(MarkupWriter writer) {
        writer.element("span", new Object[]{"id", this.getClientId()});
        if (this.value != null && this.value.length() > 0) {
            writer.write(this.value);
        } else {
            writer.writeRaw(this.messages.get("empty"));
        }
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
        Link link = this.resources.createEventLink("action", this.contextArray);
        this.renderSupport.addScript("new Ajax.InPlaceEditor('%s', '%s', {cancelControl: 'button', cancelText: '%s', clickToEditText: '%s', savingText: '%s', okText: '%s', htmlResponse: true, size: %s, stripLoadedTextTags: true});", new Object[]{this.getClientId(), link.toAbsoluteURI(), this.messages.get("cancelbutton"), this.messages.get("title"), this.messages.get("saving"), this.messages.get("savebutton"), this.size});
    }

    StreamResponse onAction(String value) throws UnsupportedEncodingException {
        String valueText = this.request.getParameter("value");
        this.resources.triggerEvent(SAVE_EVENT, new Object[]{value, valueText}, null);
        if (valueText == null || valueText.length() == 0) {
            valueText = this.messages.get("empty");
        }
        return new TextStreamResponse("text/html", new String(valueText.getBytes("UTF8")));
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

