/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.util.List;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.Mixin;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.corelib.mixins.DiscardBody;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;

@SupportsInformalParameters
@IncludeJavaScriptLibrary(value={"../Chenillekit.js", "InPlaceCheckbox.js"})
public class InPlaceCheckbox
implements ClientElement {
    public static final String EVENT_NAME = "clicked";
    @Parameter(value="false", defaultPrefix="prop")
    private boolean disabled;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(required=true, defaultPrefix="prop", allowNull=false)
    private boolean value;
    @Parameter(required=false, defaultPrefix="literal")
    private String onCompleteCallback;
    @Parameter(required=false, defaultPrefix="prop")
    private List<?> context;
    @Mixin
    private DiscardBody discardBody;
    @Inject
    private ComponentResources resources;
    @Inject
    private RenderSupport renderSupport;
    private String assignedClientId;
    private Object[] contextArray;

    void setupRender() {
        this.assignedClientId = this.renderSupport.allocateClientId(this.clientId);
        this.contextArray = this.context == null ? new Object[]{} : this.context.toArray();
    }

    void beginRender(MarkupWriter writer) {
        writer.element("input", new Object[]{"type", "checkbox", "id", this.getClientId(), "checked", this.value ? "checked" : null});
        this.resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
        Link link = this.resources.createEventLink("action", this.contextArray);
        String ajaxString = "new Ck.InPlaceCheckbox('%s', '%s'";
        if (this.onCompleteCallback != null) {
            ajaxString = ajaxString + ",'" + this.onCompleteCallback + "'";
        }
        ajaxString = ajaxString + ");";
        this.renderSupport.addScript(ajaxString, new Object[]{this.getClientId(), link.toAbsoluteURI()});
    }

    JSONObject onAction(EventContext context) {
        Object[] eventContextArray = new Object[context.getCount()];
        for (int x = 0; x < context.getCount(); ++x) {
            eventContextArray[x] = x < context.getCount() - 1 ? context.get(String.class, x) : context.get(Boolean.class, x);
        }
        this.resources.triggerEvent(EVENT_NAME, eventContextArray, null);
        return new JSONObject().put("value", eventContextArray[context.getCount() - 1]);
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

