/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.util.List;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.chenillekit.tapestry.core.utils.XYDataItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportsInformalParameters
@IncludeJavaScriptLibrary(value={"../excanvas.js", "chart/flotr.debug-0.2.0-test.js"})
public class Chart
implements ClientElement {
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String _clientId;
    @Parameter(name="dataItems", required=false, defaultPrefix="prop")
    private List<List<XYDataItem>> _dataItemsList;
    @Inject
    private RenderSupport _renderSupport;
    @Inject
    private ComponentResources _resources;
    private String _assignedClientId;

    void setupRender() {
        this._assignedClientId = this._renderSupport.allocateClientId(this._clientId);
    }

    void beginRender(MarkupWriter writer) {
        writer.element("div", new Object[]{"id", this.getClientId()});
        this._resources.renderInformalParameters(writer);
        writer.end();
    }

    void afterRender(MarkupWriter writer) {
        JSONObject config = new JSONObject();
        String dataArrayString = null;
        this.configure(config);
        if (this._dataItemsList != null && this._dataItemsList.size() > 0) {
            dataArrayString = "[";
            for (int i = 0; i < this._dataItemsList.size(); ++i) {
                List<XYDataItem> dataItems = this._dataItemsList.get(i);
                String dataVarName = String.format("d%d", i);
                this._renderSupport.addScript("var %s = %s;", new Object[]{dataVarName, this.buildDataValuesString(dataItems)});
                dataArrayString = dataArrayString + dataVarName;
                if (i >= this._dataItemsList.size() - 1) continue;
                dataArrayString = dataArrayString + ",";
            }
            dataArrayString = dataArrayString + "]";
        }
        String javaScriptCall = "var chart_%s = new Flotr.draw($('%s'), ";
        javaScriptCall = dataArrayString != null ? javaScriptCall + "%s " : (config.has("data") ? javaScriptCall + config.get("data") + " " : javaScriptCall + "[[]] ");
        if (config.has("options")) {
            javaScriptCall = javaScriptCall + ", " + config.get("options");
        }
        javaScriptCall = javaScriptCall + ");";
        this._renderSupport.addScript(javaScriptCall, new Object[]{this.getClientId(), this.getClientId(), dataArrayString});
    }

    private String buildDataValuesString(List<XYDataItem> dataItems) {
        String dataValuesString = "[";
        for (int i = 0; i < dataItems.size(); ++i) {
            XYDataItem dataItem = dataItems.get(i);
            dataValuesString = dataValuesString + String.format("%s", dataItem.toString());
            if (i >= dataItems.size() - 1) continue;
            dataValuesString = dataValuesString + ",";
        }
        return dataValuesString + "]";
    }

    protected void configure(JSONObject config) {
    }

    public String getClientId() {
        return this._assignedClientId;
    }
}

