/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.base;

import java.util.List;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.MixinAfter;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.internal.util.Holder;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Request;
import org.chenillekit.tapestry.core.base.EventMixin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@IncludeJavaScriptLibrary(value={"../Chenillekit.js", "../components/CkOnEvents.js"})
@MixinAfter
public abstract class AbstractEventMixin
implements EventMixin {
    private static String EVENT_NAME = "internalEvent";
    private static String PARAM_NAME = "value";
    @Inject
    private Request request;
    @Inject
    private ComponentResources resources;
    @InjectContainer
    private ClientElement clientElement;
    @Parameter(required=false, defaultPrefix="literal")
    private String onCompleteCallback;
    @Parameter(required=false, defaultPrefix="literal")
    private boolean stop;
    @Parameter
    private List<?> context;
    @Environmental
    private RenderSupport pageRenderSupport;
    private Object[] contextArray;

    @Override
    public List<?> getContext() {
        return this.context;
    }

    void setupRender() {
        this.contextArray = this.context == null ? new Object[]{} : this.context.toArray();
    }

    void afterRender() {
        Link link = this.resources.createEventLink(EVENT_NAME, this.contextArray);
        String id = this.clientElement.getClientId();
        String jsString = "new Ck.OnEvent('%s', '%s', %b, '%s', '%s');";
        String callBackString = this.resources.isBound("onCompleteCallback") ? this.onCompleteCallback : "";
        boolean doStop = this.resources.isBound("stop") && this.stop;
        this.pageRenderSupport.addScript(jsString, new Object[]{this.getEventName(), id, doStop, link.toAbsoluteURI(), callBackString});
    }

    Object onInternalEvent() {
        String input = this.request.getParameter(PARAM_NAME);
        final Holder valueHolder = Holder.create();
        ComponentEventCallback<Object> callback = new ComponentEventCallback<Object>(){

            public boolean handleResult(Object result) {
                valueHolder.put(result);
                return true;
            }
        };
        this.resources.triggerEvent(this.getEventName(), new Object[]{input}, (ComponentEventCallback)callback);
        return valueHolder.get();
    }
}

