/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.core.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.LocalizedNameGenerator;

public class URIResource
implements Resource {
    private URI uri;

    public URIResource(String uri) {
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URIResource(URI uri) throws MalformedURLException {
        this.uri = uri;
    }

    public URIResource(File file) throws MalformedURLException {
        this(file.toURI());
    }

    public URIResource(URL url) throws URISyntaxException, MalformedURLException {
        this(url.toURI());
    }

    protected Resource newResource(String uri) {
        return new URIResource(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        InputStream is = null;
        try {
            is = this.uri.toURL().openStream();
            int i = is.read();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public InputStream openStream() throws IOException {
        return this.uri.toURL().openStream();
    }

    public URL toURL() {
        try {
            if (this.exists()) {
                return this.uri.toURL();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Resource forLocale(Locale locale) {
        for (String path : new LocalizedNameGenerator(this.uri.toString(), locale)) {
            Resource potential = this.createResource(path);
            if (!potential.exists()) continue;
            return potential;
        }
        return null;
    }

    private Resource createResource(String path) {
        if (this.uri.toString().equals(path)) {
            return this;
        }
        return this.newResource(path);
    }

    public Resource forFile(String relativePath) {
        return this.createResource(relativePath);
    }

    public Resource withExtension(String extension) {
        throw new RuntimeException("not implemented yet!");
    }

    public String getFolder() {
        int lastSlash;
        String folderName = "";
        String completePath = this.toURL().getPath();
        if (completePath != null && (lastSlash = completePath.lastIndexOf(47)) > 0) {
            folderName = completePath.substring(0, lastSlash);
        }
        return folderName;
    }

    public String getFile() {
        String fileName = "";
        String completePath = this.toURL().getPath();
        if (completePath != null) {
            fileName = completePath.lastIndexOf(47) > 0 ? completePath.substring(completePath.lastIndexOf(47) + 1) : completePath;
        }
        return fileName;
    }

    public String getPath() {
        return this.toURL().toExternalForm();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        URIResource other = (URIResource)obj;
        return other.getPath().equals(this.getPath());
    }

    public int hashCode() {
        return 0xE3 ^ this.getPath().hashCode();
    }

    public String toString() {
        return String.format("uri:%s", this.uri.toString());
    }
}

