/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.core.services.impl;

import javax.naming.Context;
import javax.sql.DataSource;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DatabaseConfiguration;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.apache.commons.configuration.JNDIConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.plist.PropertyListConfiguration;
import org.apache.tapestry5.ioc.Resource;
import org.chenillekit.core.services.ConfigurationService;

public class ConfigurationServiceImpl
implements ConfigurationService {
    public Configuration getConfiguration(Resource configurationResource) {
        return this.getConfiguration(configurationResource, true);
    }

    public Configuration getConfiguration(Resource configurationResource, boolean mergeWithSysProps) {
        XMLConfiguration configuration;
        assert (configurationResource != null);
        if (!configurationResource.exists()) {
            throw new RuntimeException(String.format("configuration resource '%s' not found", configurationResource.toString()));
        }
        try {
            if (configurationResource.getFile().endsWith(".xml")) {
                configuration = new XMLConfiguration(configurationResource.toURL());
            } else if (configurationResource.getFile().endsWith(".properties")) {
                configuration = new PropertiesConfiguration(configurationResource.toURL());
            } else if (configurationResource.getFile().endsWith(".plist")) {
                configuration = new PropertyListConfiguration(configurationResource.toURL());
            } else if (configurationResource.getFile().endsWith(".plist")) {
                configuration = new PropertyListConfiguration(configurationResource.toURL());
            } else if (configurationResource.getFile().endsWith(".ini")) {
                configuration = new HierarchicalINIConfiguration(configurationResource.toURL());
            } else {
                throw new RuntimeException(String.format("cant resolve configuration type of resource '%s'", configurationResource.toString()));
            }
            if (mergeWithSysProps) {
                CombinedConfiguration mergedConfiguration = new CombinedConfiguration();
                mergedConfiguration.addConfiguration((AbstractConfiguration)configuration);
                mergedConfiguration.addConfiguration((AbstractConfiguration)this.getConfiguration());
                configuration = mergedConfiguration;
            }
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        return configuration;
    }

    public Configuration getConfiguration(Context context) {
        assert (context != null);
        return new JNDIConfiguration(context);
    }

    public Configuration getConfiguration() {
        return new SystemConfiguration();
    }

    public Configuration getConfiguration(DataSource datasource, String table, String nameColumn, String keyColumn, String valueColumn, String name) {
        return new DatabaseConfiguration(datasource, table, nameColumn, keyColumn, valueColumn, name);
    }
}

