/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;

public class GradientSobel_UnrolledOuter_MT {
    public static void process_I8(GrayU8 orig, GrayS16 derivX, GrayS16 derivY) {
        byte[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int adjWidth = width - 2;
        BoofConcurrency.loopFor((int)1, (int)height, y -> {
            int w;
            int v;
            int index;
            int endX_alt = width * y + (width - adjWidth % 3) - 1;
            int endX = endX_alt + adjWidth % 3;
            int a11 = data[index - width - 1] & 0xFF;
            int a12 = data[index - width] & 0xFF;
            int a21 = data[index - 1] & 0xFF;
            int a22 = data[index] & 0xFF;
            int a31 = data[index + width - 1] & 0xFF;
            int a32 = data[index + width] & 0xFF;
            for (index = width * y + 1; index < endX_alt; ++index) {
                int a13 = data[index - width + 1] & 0xFF;
                int a23 = data[index + 1] & 0xFF;
                int a33 = data[index + width + 1] & 0xFF;
                v = a33 - a11;
                w = a31 - a13;
                imgY[index] = (short)((a32 - a12) * 2 + v + w);
                imgX[index] = (short)((a23 - a21) * 2 + v - w);
                a11 = data[++index - width + 1] & 0xFF;
                a21 = data[index + 1] & 0xFF;
                a31 = data[index + width + 1] & 0xFF;
                v = a31 - a12;
                w = a32 - a11;
                imgY[index] = (short)((a33 - a13) * 2 + v + w);
                imgX[index] = (short)((a21 - a22) * 2 + v - w);
                a12 = data[++index - width + 1] & 0xFF;
                a22 = data[index + 1] & 0xFF;
                a32 = data[index + width + 1] & 0xFF;
                v = a32 - a13;
                w = a33 - a12;
                imgY[index] = (short)((a31 - a11) * 2 + v + w);
                imgX[index] = (short)((a22 - a23) * 2 + v - w);
            }
            while (index < endX) {
                v = (data[index + width + 1] & 0xFF) - (data[index - width - 1] & 0xFF);
                w = (data[index + width - 1] & 0xFF) - (data[index - width + 1] & 0xFF);
                imgY[index] = (short)(((data[index + width] & 0xFF) - (data[index - width] & 0xFF)) * 2 + v + w);
                imgX[index] = (short)(((data[index + 1] & 0xFF) - (data[index - 1] & 0xFF)) * 2 + v - w);
                ++index;
            }
        });
    }

    public static void process_F32(GrayF32 orig, GrayF32 derivX, GrayF32 derivY) {
        float[] data = orig.data;
        float[] imgX = derivX.data;
        float[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int adjWidth = width - 2;
        BoofConcurrency.loopFor((int)1, (int)height, y -> {
            float w;
            float v;
            int index;
            int endX_alt = width * y + (width - adjWidth % 3) - 1;
            int endX = endX_alt + adjWidth % 3;
            float a11 = data[index - width - 1];
            float a12 = data[index - width];
            float a21 = data[index - 1];
            float a22 = data[index];
            float a31 = data[index + width - 1];
            float a32 = data[index + width];
            for (index = width * y + 1; index < endX_alt; ++index) {
                float a13 = data[index - width + 1];
                float a23 = data[index + 1];
                float a33 = data[index + width + 1];
                v = (a33 - a11) * 0.25f;
                w = (a31 - a13) * 0.25f;
                imgY[index] = (a32 - a12) * 0.5f + v + w;
                imgX[index] = (a23 - a21) * 0.5f + v - w;
                a11 = data[++index - width + 1];
                a21 = data[index + 1];
                a31 = data[index + width + 1];
                v = (a31 - a12) * 0.25f;
                w = (a32 - a11) * 0.25f;
                imgY[index] = (a33 - a13) * 0.5f + v + w;
                imgX[index] = (a21 - a22) * 0.5f + v - w;
                a12 = data[++index - width + 1];
                a22 = data[index + 1];
                a32 = data[index + width + 1];
                v = (a32 - a13) * 0.25f;
                w = (a33 - a12) * 0.25f;
                imgY[index] = (a31 - a11) * 0.5f + v + w;
                imgX[index] = (a22 - a23) * 0.5f + v - w;
            }
            while (index < endX) {
                v = (data[index + width + 1] - data[index - width - 1]) * 0.25f;
                w = (data[index + width - 1] - data[index - width + 1]) * 0.25f;
                imgY[index] = (data[index + width] - data[index - width]) * 0.5f + v + w;
                imgX[index] = (data[index + 1] - data[index - 1]) * 0.5f + v - w;
                ++index;
            }
        });
    }

    public static void process_F32_sub(GrayF32 orig, GrayF32 derivX, GrayF32 derivY) {
        float[] data = orig.data;
        float[] imgX = derivX.data;
        float[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int strideSrc = orig.stride;
        int adjWidth = width - 2;
        BoofConcurrency.loopFor((int)1, (int)height, y -> {
            float w;
            float v;
            int index;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            int endX_alt = index + (width - adjWidth % 3) - 2;
            int endX = endX_alt + adjWidth % 3;
            float a11 = data[index - strideSrc - 1];
            float a12 = data[index - strideSrc];
            float a21 = data[index - 1];
            float a22 = data[index];
            float a31 = data[index + strideSrc - 1];
            float a32 = data[index + strideSrc];
            for (index = orig.startIndex + strideSrc * y + 1; index < endX_alt; ++index) {
                float a13 = data[index - strideSrc + 1];
                float a23 = data[index + 1];
                float a33 = data[index + strideSrc + 1];
                v = (a33 - a11) * 0.25f;
                w = (a31 - a13) * 0.25f;
                imgY[indexY++] = (a32 - a12) * 0.5f + v + w;
                imgX[indexX++] = (a23 - a21) * 0.5f + v - w;
                a11 = data[++index - strideSrc + 1];
                a21 = data[index + 1];
                a31 = data[index + strideSrc + 1];
                v = (a31 - a12) * 0.25f;
                w = (a32 - a11) * 0.25f;
                imgY[indexY++] = (a33 - a13) * 0.5f + v + w;
                imgX[indexX++] = (a21 - a22) * 0.5f + v - w;
                a12 = data[++index - strideSrc + 1];
                a22 = data[index + 1];
                a32 = data[index + strideSrc + 1];
                v = (a32 - a13) * 0.25f;
                w = (a33 - a12) * 0.25f;
                imgY[indexY++] = (a31 - a11) * 0.5f + v + w;
                imgX[indexX++] = (a22 - a23) * 0.5f + v - w;
            }
            while (index < endX) {
                v = (data[index + strideSrc + 1] - data[index - strideSrc - 1]) * 0.25f;
                w = (data[index + strideSrc - 1] - data[index - strideSrc + 1]) * 0.25f;
                imgY[indexY++] = (data[index + strideSrc] - data[index - strideSrc]) * 0.5f + v + w;
                imgX[indexX++] = (data[index + 1] - data[index - 1]) * 0.5f + v - w;
                ++index;
            }
        });
    }
}

