/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color;

import boofcv.alg.color.impl.ImplColorYuv;
import boofcv.alg.color.impl.ImplColorYuv_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;

public class ColorYuv {
    public static void rgbToYuv(double r, double g, double b, double[] yuv) {
        double y = yuv[0] = 0.299 * r + 0.587 * g + 0.114 * b;
        yuv[1] = 0.492 * (b - y);
        yuv[2] = 0.877 * (r - y);
    }

    public static void rgbToYuv(float r, float g, float b, float[] yuv) {
        float y = yuv[0] = 0.299f * r + 0.587f * g + 0.114f * b;
        yuv[1] = 0.492f * (b - y);
        yuv[2] = 0.877f * (r - y);
    }

    public static int yuvToRgb(double y, double u, double v) {
        int r = (int)(y + 1.13983 * v + 0.5);
        int g = (int)(y - 0.39465 * u - 0.5806 * v + 0.5);
        int b = (int)(y + 2.032 * u + 0.5);
        return r << 16 | g << 8 | b;
    }

    public static void yuvToRgb(double y, double u, double v, double[] rgb) {
        rgb[0] = y + 1.13983 * v;
        rgb[1] = y - 0.39465 * u - 0.5806 * v;
        rgb[2] = y + 2.032 * u;
    }

    public static void yuvToRgb(float y, float u, float v, float[] rgb) {
        rgb[0] = y + 1.13983f * v;
        rgb[1] = y - 0.39465f * u - 0.5806f * v;
        rgb[2] = y + 2.032f * u;
    }

    public static void rgbToYCbCr(int r, int g, int b, byte[] yuv) {
        yuv[0] = (byte)((187 * r + 629 * g + 63 * b >> 10) + 16);
        yuv[1] = (byte)((-103 * r - 346 * g + 450 * b >> 10) + 128);
        yuv[2] = (byte)((450 * r - 409 * g - 41 * b >> 10) + 128);
    }

    public static int ycbcrToRgb(int y, int cb, int cr) {
        if ((y = 1191 * (y - 16)) < 0) {
            y = 0;
        }
        int r = y + 1836 * (cr -= 128) >> 10;
        int g = y - 547 * cr - 218 * (cb -= 128) >> 10;
        int b = y + 2165 * cb >> 10;
        if (r < 0) {
            r = 0;
        } else if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 255) {
            b = 255;
        }
        return r << 16 | g << 8 | b;
    }

    public static void ycbcrToRgb(int y, int cb, int cr, byte[] rgb) {
        if ((y = 1191 * (y - 16)) < 0) {
            y = 0;
        }
        int r = y + 1836 * (cr -= 128) >> 10;
        int g = y - 547 * cr - 218 * (cb -= 128) >> 10;
        int b = y + 2165 * cb >> 10;
        if (r < 0) {
            r = 0;
        } else if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 255) {
            b = 255;
        }
        rgb[0] = (byte)r;
        rgb[1] = (byte)g;
        rgb[2] = (byte)b;
    }

    public static <T extends ImageGray<T>> void yuvToRgb(Planar<T> yuv, Planar<T> rgb) {
        rgb.reshape(rgb.width, rgb.height, 3);
        if (rgb.getBandType() == GrayF32.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorYuv_MT.yuvToRgb_F32(yuv, rgb);
            } else {
                ImplColorYuv.yuvToRgb_F32(yuv, rgb);
            }
        } else if (rgb.getBandType() == GrayU8.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorYuv_MT.ycbcrToRgb_U8(yuv, rgb);
            } else {
                ImplColorYuv.ycbcrToRgb_U8(yuv, rgb);
            }
        } else {
            throw new IllegalArgumentException("Unsupported band type " + rgb.getBandType().getSimpleName());
        }
    }

    public static <T extends ImageGray<T>> void rgbToYuv(Planar<T> rgb, Planar<T> yuv) {
        yuv.reshape(rgb.width, rgb.height, 3);
        if (rgb.getBandType() == GrayF32.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorYuv_MT.rgbToYuv_F32(rgb, yuv);
            } else {
                ImplColorYuv.rgbToYuv_F32(rgb, yuv);
            }
        } else {
            throw new IllegalArgumentException("Unsupported band type " + rgb.getBandType().getSimpleName());
        }
    }
}

