/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TMEDTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    public static final String DIGITAL = "(DIG) - Digital";
    public static final String ANALOG = "(ANA) - Analog";
    public static final String CD = "(CD) - CD";
    public static final String LASERDISC = "(LD) - Laserdisc";
    public static final String TURNTABLE_RECORD = "(TT) - Turntable records";
    public static final String MINIDISC = "(MD) - MiniDisc";
    public static final String DAT = "(DAT) - DAT";
    public static final String DIGITAL_CASSETTE = "(DCC) - DCC";
    public static final String DVD = "(DVD) - DVD";
    public static final String TV = "(TV) - Television";
    public static final String VIDEO = "(VID) - Video";
    public static final String RADIO = "(RAD) - Radio";
    public static final String TELEPHONE = "(TEL) - Telephone";
    public static final String PHILIPS_CASSETTE = "(MC) - Normal Cassette";
    public static final String REEL = "(REE) - Reel";
    private String m_sMediaType = null;

    public TMEDTextInformationID3V2Frame(String sMediaType) {
        super(sMediaType);
        this.m_sMediaType = sMediaType;
    }

    public TMEDTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        this.m_sMediaType = this.m_sInformation;
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTMEDTextInformationID3V2Frame(this);
    }

    public void setMediaType(String sMediaType) {
        this.m_sMediaType = sMediaType;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = sMediaType;
    }

    public String getMediaType() {
        return this.m_sMediaType;
    }

    protected byte[] getFrameId() {
        return "TMED".getBytes();
    }

    public String toString() {
        return "Media type: [" + this.m_sInformation + "]";
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TMEDTextInformationID3V2Frame)) {
            return false;
        }
        TMEDTextInformationID3V2Frame oOtherTMED = (TMEDTextInformationID3V2Frame)oOther;
        return this.m_sMediaType.equals(oOtherTMED.m_sMediaType) && this.m_oTextEncoding.equals(oOtherTMED.m_oTextEncoding) && this.m_sInformation.equals(oOtherTMED.m_sInformation);
    }
}

