/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class PCNTID3V2Frame
extends ID3V2Frame {
    private int m_iPlayCount;

    public PCNTID3V2Frame(int iPlayCount) throws ID3Exception {
        if (iPlayCount < 0) {
            throw new ID3Exception("Play count cannot be negative in PCNT frame.");
        }
        this.m_iPlayCount = iPlayCount;
    }

    public PCNTID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_iPlayCount = oFrameDataID3DIS.readBE32();
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitPCNTID3V2Frame(this);
    }

    public void setPlayCount(int iPlayCount) throws ID3Exception {
        if (iPlayCount < 0) {
            throw new ID3Exception("Play count cannot be negative in PCNT frame.");
        }
        this.m_iPlayCount = iPlayCount;
    }

    public int getPlayCount() {
        return this.m_iPlayCount;
    }

    protected byte[] getFrameId() {
        return "PCNT".getBytes();
    }

    public String toString() {
        return "Play counter: Play count=[" + this.m_iPlayCount + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeBE32(this.m_iPlayCount);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof PCNTID3V2Frame)) {
            return false;
        }
        PCNTID3V2Frame oOtherPCNT = (PCNTID3V2Frame)oOther;
        return this.m_iPlayCount == oOtherPCNT.m_iPlayCount;
    }
}

