/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class GEOBID3V2Frame
extends ID3V2Frame {
    private TextEncoding m_oTextEncoding;
    private String m_sMimeType = null;
    private String m_sFilename = null;
    private String m_sContentDescription = null;
    private byte[] m_abyEncapsulatedObjectData = null;

    public GEOBID3V2Frame(String sMimeType, String sFilename, String sContentDescription, byte[] abyEncapsulatedObjectData) throws ID3Exception {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sMimeType = sMimeType;
        this.m_sFilename = sFilename;
        if (sContentDescription == null || sContentDescription.length() == 0) {
            throw new ID3Exception("Content description is required in GEOB frame.");
        }
        this.m_sContentDescription = sContentDescription;
        if (abyEncapsulatedObjectData == null || abyEncapsulatedObjectData.length == 0) {
            throw new ID3Exception("Encapsulated object data is required in GEOB frame.");
        }
        this.m_abyEncapsulatedObjectData = abyEncapsulatedObjectData;
    }

    public GEOBID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            int iMimeTypeByte;
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_oTextEncoding = TextEncoding.getTextEncoding(oFrameDataID3DIS.readUnsignedByte());
            ByteArrayOutputStream oMimeTypeBAOS = new ByteArrayOutputStream();
            do {
                if ((iMimeTypeByte = oFrameDataID3DIS.readUnsignedByte()) == 0) continue;
                oMimeTypeBAOS.write(iMimeTypeByte);
            } while (iMimeTypeByte != 0);
            if (oMimeTypeBAOS.size() > 0) {
                byte[] abyMimeType = oMimeTypeBAOS.toByteArray();
                this.m_sMimeType = new String(abyMimeType);
            }
            this.m_sFilename = oFrameDataID3DIS.readStringToNull(this.m_oTextEncoding);
            this.m_sContentDescription = oFrameDataID3DIS.readStringToNull(this.m_oTextEncoding);
            this.m_abyEncapsulatedObjectData = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(this.m_abyEncapsulatedObjectData);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitGEOBID3V2Frame(this);
    }

    public void setEncapsulatedObject(String sMimeType, String sFilename, String sContentDescription, byte[] abyEncapsulatedObjectData) throws ID3Exception {
        TextEncoding oOrigTextEncoding = this.m_oTextEncoding;
        String sOrigMimeType = this.m_sMimeType;
        String sOrigFilename = this.m_sFilename;
        String sOrigContentDescription = this.m_sContentDescription;
        byte[] abyOrigEncapsulatedObjectData = this.m_abyEncapsulatedObjectData;
        if (sContentDescription == null || sContentDescription.length() == 0) {
            throw new ID3Exception("Content description is required in GEOB frame.");
        }
        if (abyEncapsulatedObjectData == null || abyEncapsulatedObjectData.length == 0) {
            throw new ID3Exception("Encapsulated object data is required in GEOB frame.");
        }
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sMimeType = sMimeType;
        this.m_sFilename = sFilename;
        this.m_sContentDescription = sContentDescription;
        this.m_abyEncapsulatedObjectData = abyEncapsulatedObjectData;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_oTextEncoding = oOrigTextEncoding;
            this.m_sMimeType = sOrigMimeType;
            this.m_sFilename = sOrigFilename;
            this.m_sContentDescription = sOrigContentDescription;
            this.m_abyEncapsulatedObjectData = abyOrigEncapsulatedObjectData;
            throw e;
        }
    }

    public String getMimeType() {
        return this.m_sMimeType;
    }

    public String getFilename() {
        return this.m_sFilename;
    }

    public String getContentDescription() {
        return this.m_sContentDescription;
    }

    public byte[] getEncapsulatedObjectData() {
        return this.m_abyEncapsulatedObjectData;
    }

    public void setTextEncoding(TextEncoding oTextEncoding) {
        if (oTextEncoding == null) {
            throw new NullPointerException("Text encoding cannot be null.");
        }
        this.m_oTextEncoding = oTextEncoding;
    }

    public TextEncoding getTextEncoding() {
        return this.m_oTextEncoding;
    }

    protected byte[] getFrameId() {
        return "GEOB".getBytes();
    }

    public String toString() {
        return "General Encapsulated Object: Mime-Type=[" + this.m_sMimeType + "], Filename=[" + this.m_sFilename + "], Content description=[" + this.m_sContentDescription + "], Object data length=" + this.m_abyEncapsulatedObjectData.length;
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeUnsignedByte(this.m_oTextEncoding.getEncodingValue());
        if (this.m_sMimeType != null) {
            oIDOS.write(this.m_sMimeType.getBytes());
        }
        oIDOS.writeUnsignedByte(0);
        if (this.m_sFilename != null) {
            oIDOS.write(this.m_sFilename.getBytes(this.m_oTextEncoding.getEncodingString()));
        }
        if (this.m_oTextEncoding.equals(TextEncoding.ISO_8859_1)) {
            oIDOS.writeUnsignedByte(0);
        } else {
            oIDOS.writeUnsignedByte(0);
            oIDOS.writeUnsignedByte(0);
        }
        oIDOS.write(this.m_sContentDescription.getBytes(this.m_oTextEncoding.getEncodingString()));
        if (this.m_oTextEncoding.equals(TextEncoding.ISO_8859_1)) {
            oIDOS.writeUnsignedByte(0);
        } else {
            oIDOS.writeUnsignedByte(0);
            oIDOS.writeUnsignedByte(0);
        }
        oIDOS.write(this.m_abyEncapsulatedObjectData);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof GEOBID3V2Frame)) {
            return false;
        }
        GEOBID3V2Frame oOtherGEOB = (GEOBID3V2Frame)oOther;
        return (this.m_sMimeType == null && oOtherGEOB.m_sMimeType == null || this.m_sMimeType.equals(oOtherGEOB.m_sMimeType)) && (this.m_sFilename == null && oOtherGEOB.m_sFilename == null || this.m_sFilename.equals(oOtherGEOB.m_sFilename)) && this.m_sContentDescription.equals(oOtherGEOB.m_sContentDescription) && this.m_oTextEncoding.equals(oOtherGEOB.m_oTextEncoding) && Arrays.equals(this.m_abyEncapsulatedObjectData, oOtherGEOB.m_abyEncapsulatedObjectData);
    }
}

