/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.util.Set;
import java.util.TreeSet;
import org.blinkenlights.jid3.ID3Exception;

public class ContentType {
    private Set m_oGenreSet = new TreeSet();
    private String m_sRefinement = null;
    private boolean m_bIsRemix = false;
    private boolean m_bIsCover = false;

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof ContentType)) {
            return false;
        }
        ContentType oOtherContentType = (ContentType)oOther;
        if (!((Object)this.m_oGenreSet).equals(oOtherContentType.m_oGenreSet)) {
            return false;
        }
        if (this.m_sRefinement == null && oOtherContentType.m_sRefinement != null || this.m_sRefinement != null && oOtherContentType.m_sRefinement == null || !this.m_sRefinement.equals(oOtherContentType.m_sRefinement)) {
            return false;
        }
        if (this.m_bIsRemix != oOtherContentType.m_bIsRemix) {
            return false;
        }
        return this.m_bIsCover == oOtherContentType.m_bIsCover;
    }

    public void setRefinement(String sRefinement) {
        this.m_sRefinement = sRefinement;
    }

    public String getRefinement() {
        return this.m_sRefinement;
    }

    public void setIsRemix(boolean bIsRemix) {
        this.m_bIsRemix = bIsRemix;
    }

    public boolean isRemix() {
        return this.m_bIsRemix;
    }

    public void setIsCover(boolean bIsCover) {
        this.m_bIsCover = bIsCover;
    }

    public boolean isCover() {
        return this.m_bIsCover;
    }

    public boolean setGenre(Genre oGenre) {
        return this.m_oGenreSet.add(oGenre);
    }

    public boolean unsetGenre(Genre oGenre) {
        return this.m_oGenreSet.remove(oGenre);
    }

    public boolean isSet(Genre oGenre) {
        return this.m_oGenreSet.contains(oGenre);
    }

    public Genre[] getGenres() {
        return this.m_oGenreSet.toArray(new Genre[0]);
    }

    public String toString() {
        StringBuffer sbContentType = new StringBuffer();
        Genre[] aoGenre = this.getGenres();
        for (int i = 0; i < aoGenre.length; ++i) {
            sbContentType.append("(" + aoGenre[i].getByteValue() + ")");
        }
        if (this.isCover()) {
            sbContentType.append("(CR)");
        }
        if (this.isRemix()) {
            sbContentType.append("(RX)");
        }
        if (this.getRefinement() != null) {
            String sRefinement = this.getRefinement();
            if (sRefinement.startsWith("(")) {
                sbContentType.append("(");
            }
            sbContentType.append(sRefinement);
        }
        return sbContentType.toString();
    }

    public static class Genre
    implements Comparable {
        private byte m_byGenre;
        private String m_sGenre;
        public static final Genre Blues = new Genre(0, "Blues");
        public static final Genre ClassicRock = new Genre(1, "Classic Rock");
        public static final Genre Country = new Genre(2, "Country");
        public static final Genre Dance = new Genre(3, "Dance");
        public static final Genre Disco = new Genre(4, "Disco");
        public static final Genre Funk = new Genre(5, "Funk");
        public static final Genre Grunge = new Genre(6, "Grunge");
        public static final Genre HipHop = new Genre(7, "HipHop");
        public static final Genre Jazz = new Genre(8, "Jazz");
        public static final Genre Metal = new Genre(9, "Metal");
        public static final Genre NewAge = new Genre(10, "New Age");
        public static final Genre Oldies = new Genre(11, "Oldies");
        public static final Genre Other = new Genre(12, "Other");
        public static final Genre Pop = new Genre(13, "Pop");
        public static final Genre RhythmBlues = new Genre(14, "R&B");
        public static final Genre Rap = new Genre(15, "Rap");
        public static final Genre Reggae = new Genre(16, "Reggae");
        public static final Genre Rock = new Genre(17, "Rock");
        public static final Genre Techno = new Genre(18, "Techno");
        public static final Genre Industrial = new Genre(19, "Industrial");
        public static final Genre Alternative = new Genre(20, "Alternative");
        public static final Genre Ska = new Genre(21, "Ska");
        public static final Genre DeathMetal = new Genre(22, "Death Metal");
        public static final Genre Pranks = new Genre(23, "Pranks");
        public static final Genre Soundtrack = new Genre(24, "Soundtrack");
        public static final Genre EuroTechno = new Genre(25, "Euro-Techno");
        public static final Genre Ambient = new Genre(26, "Ambient");
        public static final Genre TripHop = new Genre(27, "Trip-Hop");
        public static final Genre Vocal = new Genre(28, "Vocal");
        public static final Genre JazzFunk = new Genre(29, "Jazz-Funk");
        public static final Genre Fusion = new Genre(30, "Fusion");
        public static final Genre Trance = new Genre(31, "Trance");
        public static final Genre Classical = new Genre(32, "Classical");
        public static final Genre Instrumental = new Genre(33, "Instrumental");
        public static final Genre Acid = new Genre(34, "Acid");
        public static final Genre House = new Genre(35, "House");
        public static final Genre Game = new Genre(36, "Game");
        public static final Genre SoundClip = new Genre(37, "Sound Clip");
        public static final Genre Gospel = new Genre(38, "Gospel");
        public static final Genre Noise = new Genre(39, "Noise");
        public static final Genre AlternativeRock = new Genre(40, "Alternative Rock");
        public static final Genre Bass = new Genre(41, "Bass");
        public static final Genre Soul = new Genre(42, "Soul");
        public static final Genre Punk = new Genre(43, "Punk");
        public static final Genre Space = new Genre(44, "Space");
        public static final Genre Meditative = new Genre(45, "Meditative");
        public static final Genre InstrumentalPop = new Genre(46, "Instrumental Pop");
        public static final Genre InstrumentalRock = new Genre(47, "Instrumental Rock");
        public static final Genre Ethnic = new Genre(48, "Ethnic");
        public static final Genre Gothic = new Genre(49, "Gothic");
        public static final Genre DarkWave = new Genre(50, "Dark Wave");
        public static final Genre TechnoIndustrial = new Genre(51, "Techno-Industrial");
        public static final Genre Electronic = new Genre(52, "Electronic");
        public static final Genre PopFolk = new Genre(53, "Pop-Folk");
        public static final Genre EuroDance = new Genre(54, "Euro-Dance");
        public static final Genre Dream = new Genre(55, "Dream");
        public static final Genre SouthernRock = new Genre(56, "Southern Rock");
        public static final Genre Comedy = new Genre(57, "Comedy");
        public static final Genre Cult = new Genre(58, "Cult");
        public static final Genre Gangsta = new Genre(59, "Gangsta");
        public static final Genre Top40 = new Genre(60, "Top 40");
        public static final Genre ChristianRap = new Genre(61, "Christian Rap");
        public static final Genre PopFunk = new Genre(62, "Pop-Funk");
        public static final Genre Jungle = new Genre(63, "Jungle");
        public static final Genre NativeAmerican = new Genre(64, "Native American");
        public static final Genre Cabaret = new Genre(65, "Cabaret");
        public static final Genre NewWave = new Genre(66, "New Wave");
        public static final Genre Psychedelic = new Genre(67, "Psychedelic");
        public static final Genre Rave = new Genre(68, "Rave");
        public static final Genre ShowTunes = new Genre(69, "Show Tunes");
        public static final Genre Trailer = new Genre(70, "Trailer");
        public static final Genre LowFi = new Genre(71, "Low-Fi");
        public static final Genre Tribal = new Genre(72, "Tribal");
        public static final Genre AcidPunk = new Genre(73, "Acid Punk");
        public static final Genre AcidJazz = new Genre(74, "Acid Jazz");
        public static final Genre Polka = new Genre(75, "Polka");
        public static final Genre Retro = new Genre(76, "Retro");
        public static final Genre Musical = new Genre(77, "Musical");
        public static final Genre RockNRoll = new Genre(78, "Rock'N'Roll");
        public static final Genre HardRock = new Genre(79, "Hard Rock");
        public static final Genre EXT_Folk = new Genre(80, "Folk");
        public static final Genre EXT_FolkRock = new Genre(81, "Folk Rock");
        public static final Genre EXT_NationalFolk = new Genre(82, "National Folk");
        public static final Genre EXT_Swing = new Genre(83, "Swing");
        public static final Genre EXT_FastFusion = new Genre(84, "Fast Fusion");
        public static final Genre EXT_Bebop = new Genre(85, "Bebop");
        public static final Genre EXT_Latin = new Genre(86, "Latin");
        public static final Genre EXT_Revival = new Genre(87, "Revival");
        public static final Genre EXT_Celtic = new Genre(88, "Celtic");
        public static final Genre EXT_Bluegrass = new Genre(89, "Bluegrass");
        public static final Genre EXT_AvanteGarde = new Genre(90, "Avante Garde");
        public static final Genre EXT_GothicRock = new Genre(91, "Gothic Rock");
        public static final Genre EXT_ProgressiveRock = new Genre(92, "Progressive Rock");
        public static final Genre EXT_PsychedelicRock = new Genre(93, "Psychedelic Rock");
        public static final Genre EXT_SymphonicRock = new Genre(94, "Symphonic Rock");
        public static final Genre EXT_SlowRock = new Genre(95, "Slow Rock");
        public static final Genre EXT_BigBand = new Genre(96, "Big Band");
        public static final Genre EXT_Chorus = new Genre(97, "Chorus");
        public static final Genre EXT_EasyListening = new Genre(98, "Easy Listening");
        public static final Genre EXT_Acoustic = new Genre(99, "Acoustic");
        public static final Genre EXT_Humour = new Genre(100, "Humour");
        public static final Genre EXT_Speech = new Genre(101, "Speech");
        public static final Genre EXT_Chanson = new Genre(102, "Chanson");
        public static final Genre EXT_Opera = new Genre(103, "Opera");
        public static final Genre EXT_ChamberMusic = new Genre(104, "Chamber Music");
        public static final Genre EXT_Sonata = new Genre(105, "Sonata");
        public static final Genre EXT_Symphony = new Genre(106, "Symphony");
        public static final Genre EXT_BootyBass = new Genre(107, "Booty Bass");
        public static final Genre EXT_Primus = new Genre(108, "Primus");
        public static final Genre EXT_PornGroove = new Genre(109, "Porn Groove");
        public static final Genre EXT_Satire = new Genre(110, "Satire");
        public static final Genre EXT_SlowJam = new Genre(111, "Slow Jam");
        public static final Genre EXT_Club = new Genre(112, "Club");
        public static final Genre EXT_Tango = new Genre(113, "Tango");
        public static final Genre EXT_Samba = new Genre(114, "Samba");
        public static final Genre EXT_Folklore = new Genre(115, "Folklore");
        public static final Genre EXT_Ballad = new Genre(116, "Ballad");
        public static final Genre EXT_PowerBallad = new Genre(117, "Power Ballad");
        public static final Genre EXT_RhythmicSoul = new Genre(118, "Rhythmic Soul");
        public static final Genre EXT_Freestyle = new Genre(119, "Freestyle");
        public static final Genre EXT_Duet = new Genre(120, "Duet");
        public static final Genre EXT_PunkRock = new Genre(121, "Punk Rock");
        public static final Genre EXT_DrumSolo = new Genre(122, "Drum Solo");
        public static final Genre EXT_ACappella = new Genre(123, "A Cappella");
        public static final Genre EXT_EuroHouse = new Genre(124, "Euro-House");
        public static final Genre EXT_DanceHall = new Genre(125, "Dance Hall");
        private static Genre[] s_aoGenre = new Genre[]{Blues, ClassicRock, Country, Dance, Disco, Funk, Grunge, HipHop, Jazz, Metal, NewAge, Oldies, Other, Pop, RhythmBlues, Rap, Reggae, Rock, Techno, Industrial, Alternative, Ska, DeathMetal, Pranks, Soundtrack, EuroTechno, Ambient, TripHop, Vocal, JazzFunk, Fusion, Trance, Classical, Instrumental, Acid, House, Game, SoundClip, Gospel, Noise, AlternativeRock, Bass, Soul, Punk, Space, Meditative, InstrumentalPop, InstrumentalRock, Ethnic, Gothic, DarkWave, TechnoIndustrial, Electronic, PopFolk, EuroDance, Dream, SouthernRock, Comedy, Cult, Gangsta, Top40, ChristianRap, PopFunk, Jungle, NativeAmerican, Cabaret, NewWave, Psychedelic, Rave, ShowTunes, Trailer, LowFi, Tribal, AcidPunk, AcidJazz, Polka, Retro, Musical, RockNRoll, HardRock, EXT_Folk, EXT_FolkRock, EXT_NationalFolk, EXT_Swing, EXT_FastFusion, EXT_Bebop, EXT_Latin, EXT_Revival, EXT_Celtic, EXT_Bluegrass, EXT_AvanteGarde, EXT_GothicRock, EXT_ProgressiveRock, EXT_PsychedelicRock, EXT_SymphonicRock, EXT_SlowRock, EXT_BigBand, EXT_Chorus, EXT_EasyListening, EXT_Acoustic, EXT_Humour, EXT_Speech, EXT_Chanson, EXT_Opera, EXT_ChamberMusic, EXT_Sonata, EXT_Symphony, EXT_BootyBass, EXT_Primus, EXT_PornGroove, EXT_Satire, EXT_SlowJam, EXT_Club, EXT_Tango, EXT_Samba, EXT_Folklore, EXT_Ballad, EXT_PowerBallad, EXT_RhythmicSoul, EXT_Freestyle, EXT_Duet, EXT_PunkRock, EXT_DrumSolo, EXT_ACappella, EXT_EuroHouse, EXT_DanceHall};

        private Genre(byte byGenre, String sGenre) {
            this.m_byGenre = byGenre;
            this.m_sGenre = sGenre;
        }

        public int getByteValue() {
            return this.m_byGenre;
        }

        public String toString() {
            return this.m_sGenre;
        }

        public int compareTo(Object oOther) {
            if (!(oOther instanceof Genre)) {
                throw new ClassCastException();
            }
            Genre oOtherGenre = (Genre)oOther;
            return this.m_byGenre - oOtherGenre.m_byGenre;
        }

        public boolean equals(Genre oGenre) {
            if (oGenre == null || !(oGenre instanceof Genre)) {
                return false;
            }
            return oGenre.m_byGenre == this.m_byGenre;
        }

        static Genre lookupGenre(int iType) throws ID3Exception {
            try {
                return s_aoGenre[iType];
            }
            catch (Exception e) {
                throw new ID3Exception("Unknown genre code " + iType + ".");
            }
        }
    }
}

