/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class APICID3V2Frame
extends ID3V2Frame {
    private TextEncoding m_oTextEncoding;
    private String m_sMimeType = null;
    private PictureType m_oPictureType;
    private String m_sDescription = null;
    private byte[] m_abyPictureData = null;

    public APICID3V2Frame(String sMimeType, PictureType oPictureType, String sDescription, byte[] abyPictureData) throws ID3Exception {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sMimeType = sMimeType;
        if (this.m_sMimeType == null) {
            this.m_sMimeType = "image/";
        }
        this.m_oPictureType = oPictureType;
        if (sDescription.length() > 64) {
            throw new ID3Exception("Description in APIC frame cannot exceed 64 characters.");
        }
        this.m_sDescription = sDescription;
        if (abyPictureData == null || abyPictureData.length == 0) {
            throw new ID3Exception("APIC frame requires picture data.");
        }
        this.m_abyPictureData = abyPictureData;
    }

    public APICID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            int iMimeTypeByte;
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_oTextEncoding = TextEncoding.getTextEncoding(oFrameDataID3DIS.readUnsignedByte());
            ByteArrayOutputStream oMimeTypeBAOS = new ByteArrayOutputStream();
            do {
                if ((iMimeTypeByte = oFrameDataID3DIS.readUnsignedByte()) == 0) continue;
                oMimeTypeBAOS.write(iMimeTypeByte);
            } while (iMimeTypeByte != 0);
            if (oMimeTypeBAOS.size() > 0) {
                byte[] abyMimeType = oMimeTypeBAOS.toByteArray();
                this.m_sMimeType = new String(abyMimeType);
            }
            this.m_oPictureType = new PictureType((byte)oFrameDataID3DIS.readUnsignedByte());
            this.m_sDescription = oFrameDataID3DIS.readStringToNull(this.m_oTextEncoding);
            this.m_abyPictureData = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(this.m_abyPictureData);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitAPICID3V2Frame(this);
    }

    public void setMimeType(String sMimeType) {
        this.m_sMimeType = sMimeType;
        if (this.m_sMimeType == null) {
            this.m_sMimeType = "image/";
        }
    }

    public String getMimeType() {
        return this.m_sMimeType;
    }

    public void setPictureType(PictureType oPictureType) {
        this.m_oPictureType = oPictureType;
    }

    public PictureType getPictureType() {
        return this.m_oPictureType;
    }

    public void setDescription(String sDescription) throws ID3Exception {
        String sOrigDescription = this.m_sDescription;
        TextEncoding oOrigTextEncoding = this.m_oTextEncoding;
        if (sDescription.length() > 64) {
            throw new ID3Exception("Description in APIC frame cannot exceed 64 characters.");
        }
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sDescription = sDescription;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sDescription = sOrigDescription;
            this.m_oTextEncoding = oOrigTextEncoding;
            throw e;
        }
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public void setPictureData(byte[] abyPictureData) throws ID3Exception {
        if (abyPictureData == null || abyPictureData.length == 0) {
            throw new ID3Exception("APIC frame requires picture data.");
        }
        this.m_abyPictureData = abyPictureData;
    }

    public byte[] getPictureData() {
        return this.m_abyPictureData;
    }

    public void setTextEncoding(TextEncoding oTextEncoding) {
        if (oTextEncoding == null) {
            throw new NullPointerException("Text encoding cannot be null.");
        }
        this.m_oTextEncoding = oTextEncoding;
    }

    public TextEncoding getTextEncoding() {
        return this.m_oTextEncoding;
    }

    protected byte[] getFrameId() {
        return "APIC".getBytes();
    }

    public String toString() {
        return "Attached picure: Mime type=[" + this.m_sMimeType + "], Picture type = " + this.m_oPictureType.getValue() + ", Description=[" + this.m_sDescription + "], Picture data length = " + this.m_abyPictureData.length;
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeUnsignedByte(this.m_oTextEncoding.getEncodingValue());
        oIDOS.write(this.m_sMimeType.getBytes());
        oIDOS.writeUnsignedByte(0);
        oIDOS.writeUnsignedByte(this.m_oPictureType.getValue());
        if (this.m_sDescription != null) {
            oIDOS.write(this.m_sDescription.getBytes(this.m_oTextEncoding.getEncodingString()));
        }
        if (this.m_oTextEncoding.equals(TextEncoding.ISO_8859_1)) {
            oIDOS.writeUnsignedByte(0);
        } else {
            oIDOS.writeUnsignedByte(0);
            oIDOS.writeUnsignedByte(0);
        }
        oIDOS.write(this.m_abyPictureData);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof APICID3V2Frame)) {
            return false;
        }
        APICID3V2Frame oOtherAPIC = (APICID3V2Frame)oOther;
        return this.m_oTextEncoding.equals(oOtherAPIC.m_oTextEncoding) && this.m_sMimeType.equals(oOtherAPIC.m_sMimeType) && this.m_oPictureType.equals(oOtherAPIC.m_oPictureType) && this.m_sDescription.equals(oOtherAPIC.m_sDescription) && Arrays.equals(this.m_abyPictureData, oOtherAPIC.m_abyPictureData);
    }

    public static class PictureType {
        private byte m_byValue;
        public static final PictureType Other = new PictureType(0);
        public static final PictureType FileIcon = new PictureType(1);
        public static final PictureType OtherFileIcon = new PictureType(2);
        public static final PictureType FrontCover = new PictureType(3);
        public static final PictureType BackCover = new PictureType(4);
        public static final PictureType LeafletPage = new PictureType(5);
        public static final PictureType Media = new PictureType(6);
        public static final PictureType LeadArtist = new PictureType(7);
        public static final PictureType Artist = new PictureType(8);
        public static final PictureType Conductor = new PictureType(9);
        public static final PictureType Band = new PictureType(10);
        public static final PictureType Composer = new PictureType(11);
        public static final PictureType Lyricist = new PictureType(12);
        public static final PictureType Location = new PictureType(13);
        public static final PictureType DuringRecording = new PictureType(14);
        public static final PictureType DuringPerformance = new PictureType(15);
        public static final PictureType FrameCapture = new PictureType(16);
        public static final PictureType BrightColouredFish = new PictureType(17);
        public static final PictureType Illustration = new PictureType(18);
        public static final PictureType ArtistLogo = new PictureType(19);
        public static final PictureType PublisherLogo = new PictureType(20);

        private PictureType(byte byValue) {
            this.m_byValue = byValue;
        }

        private byte getValue() {
            return this.m_byValue;
        }

        public boolean equals(PictureType oPictureType) {
            if (oPictureType == null || !(oPictureType instanceof PictureType)) {
                return false;
            }
            return oPictureType.m_byValue == this.m_byValue;
        }
    }
}

