/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.exe;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.ID3Tag;
import org.blinkenlights.jid3.MP3File;
import org.blinkenlights.jid3.util.ID3Util;
import org.blinkenlights.jid3.v1.ID3V1Tag;
import org.blinkenlights.jid3.v1.ID3V1_0Tag;
import org.blinkenlights.jid3.v1.ID3V1_1Tag;
import org.blinkenlights.jid3.v2.ID3V2_3_0Tag;

public class JID3Tagger {
    private Map m_oCmdLineMap = null;

    private JID3Tagger(Map oCmdLineMap) {
        this.m_oCmdLineMap = oCmdLineMap;
    }

    private void display() throws Exception {
        String[] asFilename = (String[])this.m_oCmdLineMap.get("filenames");
        for (int i = 0; i < asFilename.length; ++i) {
            System.out.println("\n[" + asFilename[i] + "]");
            File oSourceFile = new File(asFilename[i]);
            MP3File oMP3File = new MP3File(oSourceFile);
            ID3Tag[] aoTag = oMP3File.getTags();
            for (int j = 0; j < aoTag.length; ++j) {
                if (aoTag[j] instanceof ID3V1_0Tag) {
                    System.out.println("\nV1.0:");
                } else if (aoTag[j] instanceof ID3V1_1Tag) {
                    System.out.println("\nV1.1:");
                } else if (aoTag[j] instanceof ID3V2_3_0Tag) {
                    System.out.println("\nV2.3.0:");
                }
                System.out.println(aoTag[j].toString());
            }
        }
    }

    private void tag() throws Exception {
        String[] asFilename = (String[])this.m_oCmdLineMap.get("filenames");
        for (int i = 0; i < asFilename.length; ++i) {
            File oSourceFile = new File(asFilename[i]);
            MP3File oMP3File = new MP3File(oSourceFile);
            if (this.m_oCmdLineMap.containsKey("1")) {
                ID3V1_1Tag oID3V1_1Tag = new ID3V1_1Tag();
                if (this.m_oCmdLineMap.containsKey("album")) {
                    oID3V1_1Tag.setAlbum((String)this.m_oCmdLineMap.get("album"));
                }
                if (this.m_oCmdLineMap.containsKey("artist")) {
                    oID3V1_1Tag.setArtist((String)this.m_oCmdLineMap.get("artist"));
                }
                if (this.m_oCmdLineMap.containsKey("comment")) {
                    oID3V1_1Tag.setComment((String)this.m_oCmdLineMap.get("comment"));
                }
                if (this.m_oCmdLineMap.containsKey("genre")) {
                    String sGenre = (String)this.m_oCmdLineMap.get("genre");
                    oID3V1_1Tag.setGenre(ID3V1Tag.Genre.lookupGenre(sGenre));
                }
                if (this.m_oCmdLineMap.containsKey("title")) {
                    oID3V1_1Tag.setTitle((String)this.m_oCmdLineMap.get("title"));
                }
                if (this.m_oCmdLineMap.containsKey("year")) {
                    oID3V1_1Tag.setYear(((Integer)this.m_oCmdLineMap.get("year")).toString());
                }
                if (this.m_oCmdLineMap.containsKey("track")) {
                    oID3V1_1Tag.setAlbumTrack((Integer)this.m_oCmdLineMap.get("track"));
                }
                oMP3File.setID3Tag(oID3V1_1Tag);
            }
            if (this.m_oCmdLineMap.containsKey("2")) {
                ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
                oID3V2_3_0Tag.setPaddingLength(16);
                if (this.m_oCmdLineMap.containsKey("album")) {
                    oID3V2_3_0Tag.setAlbum((String)this.m_oCmdLineMap.get("album"));
                }
                if (this.m_oCmdLineMap.containsKey("artist")) {
                    oID3V2_3_0Tag.setArtist((String)this.m_oCmdLineMap.get("artist"));
                }
                if (this.m_oCmdLineMap.containsKey("comment")) {
                    oID3V2_3_0Tag.setComment((String)this.m_oCmdLineMap.get("comment"));
                }
                if (this.m_oCmdLineMap.containsKey("genre")) {
                    oID3V2_3_0Tag.setGenre((String)this.m_oCmdLineMap.get("genre"));
                }
                oMP3File.setID3Tag(oID3V2_3_0Tag);
                if (this.m_oCmdLineMap.containsKey("title")) {
                    oID3V2_3_0Tag.setTitle((String)this.m_oCmdLineMap.get("title"));
                }
                if (this.m_oCmdLineMap.containsKey("year")) {
                    oID3V2_3_0Tag.setYear((Integer)this.m_oCmdLineMap.get("year"));
                }
                if (this.m_oCmdLineMap.containsKey("track")) {
                    if (this.m_oCmdLineMap.containsKey("total")) {
                        oID3V2_3_0Tag.setTrackNumber((Integer)this.m_oCmdLineMap.get("track"), (Integer)this.m_oCmdLineMap.get("total"));
                    } else {
                        oID3V2_3_0Tag.setTrackNumber((Integer)this.m_oCmdLineMap.get("track"));
                    }
                }
            }
            oMP3File.sync();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("JID3 library version " + ID3Util.getVersion() + "\n\n" + ID3Util.getLicense());
            String sHelp = "Usage: java -jar jid3.jar <options> filename [filename...]\n\n Options:\n\n  --display                 Display tags contained in specified file(s)\n  --1                       Write V1.1 tag to file (default)\n  --2                       Write V2.3.0 tag to file\n  --album=<album>           Set album value\n  --artist=<artist>         Set artist value\n  --comment=<comment>       Set comment value\n  --genre=<genre>           Set genre value (specify as string)\n  --title=<title>           Set title value\n  --track=<track>[/<total>] Set track value (total tracks optional for v2.3.0)\n  --year=<year>             Set year value";
            System.out.println("\n\n" + sHelp);
        } else {
            try {
                Map oCmdLineMap = JID3Tagger.parseCommandLineArgs(args);
                JID3Tagger oJID3Tagger = new JID3Tagger(oCmdLineMap);
                if (oCmdLineMap.get("display") != null && oCmdLineMap.get("display").equals(Boolean.TRUE)) {
                    oJID3Tagger.display();
                } else {
                    oJID3Tagger.tag();
                }
            }
            catch (Exception e) {
                System.err.println("Tag failed: " + ID3Exception.getStackTrace(e));
            }
        }
    }

    private static Map parseCommandLineArgs(String[] args) throws ID3Exception {
        HashMap<String, Object> oMap = new HashMap<String, Object>();
        ArrayList<String> oFilenameList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--album=")) {
                oMap.put("album", args[i].replaceFirst("--album=", ""));
                continue;
            }
            if (args[i].startsWith("--artist=")) {
                oMap.put("artist", args[i].replaceFirst("--artist=", ""));
                continue;
            }
            if (args[i].startsWith("--comment=")) {
                oMap.put("comment", args[i].replaceFirst("--comment=", ""));
                continue;
            }
            if (args[i].startsWith("--genre=")) {
                oMap.put("genre", args[i].replaceFirst("--genre=", ""));
                continue;
            }
            if (args[i].startsWith("--title=")) {
                oMap.put("title", args[i].replaceFirst("--title=", ""));
                continue;
            }
            if (args[i].startsWith("--year=")) {
                try {
                    oMap.put("year", Integer.valueOf(args[i].replaceFirst("--year=", "")));
                    continue;
                }
                catch (Exception e) {
                    throw new ID3Exception("Invalid year value specified.");
                }
            }
            if (args[i].startsWith("--track=")) {
                try {
                    String sTrack = args[i].replaceFirst("--track=", "");
                    if (sTrack.indexOf(47) > 0) {
                        String[] asParts = sTrack.split("/", 2);
                        oMap.put("track", Integer.valueOf(asParts[0]));
                        oMap.put("total", Integer.valueOf(asParts[1]));
                        continue;
                    }
                    oMap.put("track", Integer.valueOf(sTrack));
                    continue;
                }
                catch (Exception e) {
                    throw new ID3Exception("Invalid track value specified.");
                }
            }
            if (args[i].equals("--display")) {
                oMap.put("display", Boolean.TRUE);
                continue;
            }
            if (args[i].equals("--1")) {
                oMap.put("1", Boolean.TRUE);
                continue;
            }
            if (args[i].equals("--2")) {
                oMap.put("2", Boolean.TRUE);
                continue;
            }
            oFilenameList.add(args[i]);
        }
        if (oFilenameList.size() == 0) {
            throw new ID3Exception("At least one filename must be specified.");
        }
        oMap.put("filenames", oFilenameList.toArray(new String[0]));
        if (!oMap.containsKey("1") && !oMap.containsKey("2")) {
            oMap.put("1", Boolean.TRUE);
        }
        return oMap;
    }
}

