/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3;

import java.io.File;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.ID3Tag;
import org.blinkenlights.jid3.io.FileSource;
import org.blinkenlights.jid3.io.IFileSource;
import org.blinkenlights.jid3.v1.ID3V1Tag;
import org.blinkenlights.jid3.v2.ID3V2Tag;

public abstract class MediaFile {
    protected IFileSource m_oFileSource = null;
    protected ID3V1Tag m_oID3V1Tag = null;
    protected ID3V2Tag m_oID3V2Tag = null;

    public MediaFile(File oSourceFile) {
        this.m_oFileSource = new FileSource(oSourceFile);
    }

    public MediaFile(IFileSource oFileSource) {
        this.m_oFileSource = oFileSource;
    }

    public abstract void sync() throws ID3Exception;

    public abstract ID3Tag[] getTags() throws ID3Exception;

    public abstract ID3V1Tag getID3V1Tag() throws ID3Exception;

    public abstract ID3V2Tag getID3V2Tag() throws ID3Exception;

    public abstract void removeTags() throws ID3Exception;

    public abstract void removeID3V1Tag() throws ID3Exception;

    public abstract void removeID3V2Tag() throws ID3Exception;

    public ID3Tag setID3Tag(ID3Tag oID3Tag) {
        if (oID3Tag instanceof ID3V1Tag) {
            ID3V1Tag oOldID3V1Tag = this.m_oID3V1Tag;
            this.m_oID3V1Tag = (ID3V1Tag)oID3Tag;
            return oOldID3V1Tag;
        }
        if (oID3Tag instanceof ID3V2Tag) {
            ID3V2Tag oOldID3V2Tag = this.m_oID3V2Tag;
            this.m_oID3V2Tag = (ID3V2Tag)oID3Tag;
            return oOldID3V2Tag;
        }
        return null;
    }
}

