/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.util.convert.converter.AbstractConverter;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractDateConverter<D extends Date>
extends AbstractConverter<D> {
    protected abstract D createDateLike(long var1);

    @Override
    public D convertToObject(String value, Locale locale) {
        if (Strings.isEmpty(value)) {
            return null;
        }
        DateFormat format = this.getDateFormat(locale);
        Date date = (Date)this.parse(format, value, locale);
        return this.createDateLike(date.getTime());
    }

    @Override
    public String convertToString(D value, Locale locale) {
        if (value == null) {
            return null;
        }
        DateFormat dateFormat = this.getDateFormat(locale);
        if (dateFormat != null) {
            return dateFormat.format((Date)value);
        }
        return ((Date)value).toString();
    }

    public DateFormat getDateFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return (DateFormat)DateFormat.getDateInstance(3, locale).clone();
    }
}

