/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.sort;

import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class OrderByLink<S>
extends Link<Void> {
    private static final long serialVersionUID = 1L;
    public static final String SORT_ASCENDING_CSS_CLASS_KEY = CssUtils.key(OrderByLink.class, (String)"ascending");
    public static final String SORT_DESCENDING_CSS_CLASS_KEY = CssUtils.key(OrderByLink.class, (String)"descending");
    public static final String SORT_NONE_CSS_CLASS_KEY = CssUtils.key(OrderByLink.class, (String)"none");
    private final S property;
    private final ISortStateLocator<S> stateLocator;

    public OrderByLink(String id, S property, ISortStateLocator<S> stateLocator) {
        super(id);
        Args.notNull(property, (String)"property");
        this.property = property;
        this.stateLocator = stateLocator;
    }

    public final void onClick() {
        this.sort();
        this.onSortChanged();
    }

    protected void onSortChanged() {
    }

    public final OrderByLink<S> sort() {
        if (this.isVersioned()) {
            this.addStateChange();
        }
        ISortState<S> state = this.stateLocator.getSortState();
        SortOrder order = state.getPropertySortOrder(this.property);
        state.setPropertySortOrder(this.property, this.nextSortOrder(order));
        return this;
    }

    protected SortOrder nextSortOrder(SortOrder order) {
        if (order == SortOrder.NONE) {
            return SortOrder.ASCENDING;
        }
        return order == SortOrder.ASCENDING ? SortOrder.DESCENDING : SortOrder.ASCENDING;
    }

    public void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        ISortState<S> sortState = this.stateLocator.getSortState();
        SortOrder dir = sortState.getPropertySortOrder(this.property);
        String cssClass = dir == SortOrder.ASCENDING ? this.getString(SORT_ASCENDING_CSS_CLASS_KEY) : (dir == SortOrder.DESCENDING ? this.getString(SORT_DESCENDING_CSS_CLASS_KEY) : this.getString(SORT_NONE_CSS_CLASS_KEY));
        if (!Strings.isEmpty((CharSequence)cssClass)) {
            tag.append("class", (CharSequence)cssClass, " ");
        }
    }
}

