/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.requestlogger;

import java.io.IOException;
import java.io.Serializable;
import org.apache.wicket.protocol.http.AbstractRequestLogger;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.RequestLogger;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.NopAnnotationIntrospector;
import org.codehaus.jackson.map.ser.BeanPropertyFilter;
import org.codehaus.jackson.map.ser.FilterProvider;
import org.codehaus.jackson.map.ser.impl.SimpleBeanPropertyFilter;
import org.codehaus.jackson.map.ser.impl.SimpleFilterProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRequestLogger
extends AbstractRequestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(RequestLogger.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonRequestLogger() {
        this.mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        SimpleFilterProvider filters = new SimpleFilterProvider();
        filters.addFilter("default", (BeanPropertyFilter)SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"eventTarget", "responseTarget"}));
        this.mapper.setFilters((FilterProvider)filters);
        this.mapper.setAnnotationIntrospector((AnnotationIntrospector)new FilteredInspector());
    }

    protected ObjectMapper getMapper() {
        return this.mapper;
    }

    protected void log(IRequestLogger.RequestData rd, IRequestLogger.SessionData sd) {
        if (LOG.isInfoEnabled()) {
            LOG.info(this.getLogString(rd, sd));
        }
    }

    protected String getLogString(IRequestLogger.RequestData rd, IRequestLogger.SessionData sd) {
        try {
            return this.getMapper().writeValueAsString((Object)new RequestSessionTuple(rd, sd));
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final class RequestSessionTuple
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final IRequestLogger.RequestData request;
        private final IRequestLogger.SessionData session;

        public RequestSessionTuple(IRequestLogger.RequestData request, IRequestLogger.SessionData session) {
            this.request = request;
            this.session = session;
        }

        public IRequestLogger.RequestData getRequest() {
            return this.request;
        }

        public IRequestLogger.SessionData getSession() {
            return this.session;
        }
    }

    private final class FilteredInspector
    extends NopAnnotationIntrospector {
        private FilteredInspector() {
        }

        public Object findFilterId(AnnotatedClass ac) {
            return "default";
        }
    }
}

