/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.autocomplete;

import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;

public abstract class AbstractAutoCompleteBehavior
extends AbstractDefaultAjaxBehavior {
    private static final ResourceReference AUTOCOMPLETE_JS = new JavascriptResourceReference(AutoCompleteBehavior.class, "wicket-autocomplete.js");
    private static final long serialVersionUID = 1L;
    protected boolean preselect = false;

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderJavascriptReference(AUTOCOMPLETE_JS);
    }

    protected void onBind() {
        this.getComponent().add((IBehavior)new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
            }
        });
    }

    protected void onComponentRendered() {
        Response response = this.getComponent().getResponse();
        String id = this.getComponent().getMarkupId();
        response.write((CharSequence)"<script type=\"text/javascript\"><!--/*--><![CDATA[/*><!--*/\n");
        response.write((CharSequence)("new Wicket.AutoComplete('" + id + "','" + this.getCallbackUrl() + "'," + this.preselect + ");"));
        response.write((CharSequence)"\n/*-->]]>*/</script>\n");
    }

    protected abstract void onRequest(String var1, RequestCycle var2);

    protected void respond(AjaxRequestTarget target) {
        RequestCycle requestCycle = RequestCycle.get();
        String val = requestCycle.getRequest().getParameter("q");
        this.onRequest(val, requestCycle);
    }
}

