/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.AjaxEditableLabel;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class AjaxEditableMultiLineLabel
extends AjaxEditableLabel {
    private static final long serialVersionUID = 1L;
    private int rows = 10;
    private int cols = 40;

    public AjaxEditableMultiLineLabel(String id) {
        super(id);
    }

    public AjaxEditableMultiLineLabel(String id, IModel model) {
        super(id, model);
    }

    protected Component newLabel(MarkupContainer parent, String componentId, IModel model) {
        MultiLineLabel label = new MultiLineLabel(componentId, model){
            private static final long serialVersionUID = 1L;

            protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                if (this.getModelObject() == null) {
                    this.replaceComponentTagBody(markupStream, openTag, AjaxEditableMultiLineLabel.this.defaultNullLabel());
                } else {
                    super.onComponentTagBody(markupStream, openTag);
                }
            }
        };
        label.setOutputMarkupId(true);
        label.add((IBehavior)new AjaxEditableLabel.LabelAjaxBehavior(this, this.getLabelAjaxEvent()));
        return label;
    }

    protected String getLabelAjaxEvent() {
        return "onclick";
    }

    protected FormComponent newEditor(MarkupContainer parent, String componentId, IModel model) {
        TextArea editor = new TextArea(componentId, model);
        editor.add((IBehavior)new AttributeModifier("rows", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return new Integer(AjaxEditableMultiLineLabel.this.rows);
            }
        }));
        editor.add((IBehavior)new AttributeModifier("cols", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return new Integer(AjaxEditableMultiLineLabel.this.cols);
            }
        }));
        editor.setOutputMarkupId(true);
        editor.setVisible(false);
        editor.add((IBehavior)new AjaxEditableLabel.EditorAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String saveCall = "{wicketAjaxGet('" + this.getCallbackUrl() + "&save=true&'+this.name+'='+wicketEncode(this.value)); return true;}";
                String cancelCall = "{wicketAjaxGet('" + this.getCallbackUrl() + "&save=false'); return false;}";
                String keypress = "var kc=wicketKeyCode(event); if (kc==27) " + cancelCall + "; ";
                tag.put("onblur", (CharSequence)saveCall);
                tag.put("onkeypress", (CharSequence)keypress);
            }
        });
        return editor;
    }

    public final int getCols() {
        return this.cols;
    }

    public final void setCols(int cols) {
        this.cols = cols;
    }

    public final int getRows() {
        return this.rows;
    }

    public final void setRows(int rows) {
        this.rows = rows;
    }

    protected String defaultNullLabel() {
        return "...";
    }
}

