/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometFilter;
import org.apache.catalina.comet.CometFilterChain;
import org.apache.catalina.filters.FilterBase;

public abstract class RequestFilter
extends FilterBase
implements CometFilter {
    protected String allow = null;
    protected Pattern[] allows = new Pattern[0];
    protected Pattern[] denies = new Pattern[0];
    protected String deny = null;
    private static final String PLAIN_TEXT_MIME_TYPE = "text/plain";

    public String getAllow() {
        return this.allow;
    }

    public void setAllow(String allow) {
        this.allow = allow;
        this.allows = this.precalculate(allow);
    }

    public String getDeny() {
        return this.deny;
    }

    public void setDeny(String deny) {
        this.deny = deny;
        this.denies = this.precalculate(deny);
    }

    public abstract void doFilter(ServletRequest var1, ServletResponse var2, FilterChain var3) throws IOException, ServletException;

    protected Pattern[] precalculate(String list) {
        int comma;
        if (list == null) {
            return new Pattern[0];
        }
        if ((list = list.trim()).length() < 1) {
            return new Pattern[0];
        }
        list = list + ",";
        ArrayList<Pattern> reList = new ArrayList<Pattern>();
        while (list.length() > 0 && (comma = list.indexOf(44)) >= 0) {
            String pattern = list.substring(0, comma).trim();
            try {
                reList.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                IllegalArgumentException iae = new IllegalArgumentException(sm.getString("requestFilterFilter.syntax", new Object[]{pattern}));
                iae.initCause(e);
                throw iae;
            }
            list = list.substring(comma + 1);
        }
        Pattern[] reArray = new Pattern[reList.size()];
        return reList.toArray(reArray);
    }

    protected void process(String property, ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isAllowed(property)) {
            chain.doFilter(request, response);
        } else if (response instanceof HttpServletResponse) {
            ((HttpServletResponse)response).sendError(403);
        } else {
            this.sendErrorWhenNotHttp(response);
        }
    }

    protected void processCometEvent(String property, CometEvent event, CometFilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = event.getHttpServletResponse();
        if (this.isAllowed(property)) {
            chain.doFilterEvent(event);
        } else {
            response.sendError(403);
            event.close();
        }
    }

    private boolean isAllowed(String property) {
        int i;
        for (i = 0; i < this.denies.length; ++i) {
            if (!this.denies[i].matcher(property).matches()) continue;
            return false;
        }
        for (i = 0; i < this.allows.length; ++i) {
            if (!this.allows[i].matcher(property).matches()) continue;
            return true;
        }
        return this.denies.length > 0 && this.allows.length == 0;
    }

    private void sendErrorWhenNotHttp(ServletResponse response) throws IOException {
        response.setContentType(PLAIN_TEXT_MIME_TYPE);
        response.getWriter().write(sm.getString("http.403"));
        response.getWriter().flush();
    }
}

