/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Wrapper;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.res.StringManager;

final class StandardContextValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardContextValve/1.0";
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
    private StandardContext context = null;

    public StandardContextValve() {
        super(true);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        this.context = (StandardContext)container;
    }

    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        int i;
        Wrapper wrapper;
        MessageBytes requestPathMB = request.getRequestPathMB();
        if (requestPathMB.startsWithIgnoreCase("/META-INF/", 0) || requestPathMB.equalsIgnoreCase("/META-INF") || requestPathMB.startsWithIgnoreCase("/WEB-INF/", 0) || requestPathMB.equalsIgnoreCase("/WEB-INF")) {
            this.notFound(response);
            return;
        }
        boolean reloaded = false;
        while (this.context.getPaused()) {
            reloaded = true;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        if (reloaded && this.context.getLoader() != null && this.context.getLoader().getClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.context.getLoader().getClassLoader());
        }
        if ((wrapper = request.getWrapper()) == null) {
            this.notFound(response);
            return;
        }
        if (wrapper.isUnavailable() && (wrapper = (Wrapper)this.container.findChild(wrapper.getName())) == null) {
            this.notFound(response);
            return;
        }
        Object[] instances = this.context.getApplicationEventListeners();
        ServletRequestEvent event = null;
        if (instances != null && instances.length > 0) {
            event = new ServletRequestEvent(((StandardContext)this.container).getServletContext(), (ServletRequest)request.getRequest());
            for (i = 0; i < instances.length; ++i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)instances[i];
                try {
                    if (request.isAsyncDispatching()) continue;
                    listener.requestInitialized(event);
                    continue;
                }
                catch (Throwable t) {
                    this.container.getLogger().error((Object)sm.getString("standardContext.requestListener.requestInit", new Object[]{instances[i].getClass().getName()}), t);
                    HttpServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.exception", (Object)t);
                    return;
                }
            }
        }
        if (request.isAsyncSupported()) {
            request.setAsyncSupported(wrapper.getPipeline().isAsyncSupported());
        }
        wrapper.getPipeline().getFirst().invoke(request, response);
        if (instances != null && instances.length > 0) {
            for (i = 0; i < instances.length; ++i) {
                int j = instances.length - 1 - i;
                if (instances[j] == null || !(instances[j] instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)instances[j];
                try {
                    if (request.isAsyncDispatching()) continue;
                    listener.requestDestroyed(event);
                    continue;
                }
                catch (Throwable t) {
                    this.container.getLogger().error((Object)sm.getString("standardContext.requestListener.requestDestroy", new Object[]{instances[j].getClass().getName()}), t);
                    HttpServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.exception", (Object)t);
                }
            }
        }
    }

    @Override
    public final void event(Request request, Response response, CometEvent event) throws IOException, ServletException {
        Wrapper wrapper = request.getWrapper();
        wrapper.getPipeline().getFirst().event(request, response, event);
    }

    private void notFound(HttpServletResponse response) {
        try {
            response.sendError(404);
        }
        catch (IllegalStateException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

