/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.iwork.IWorkPackageParser;

public class ZipContainerDetector
implements Detector {
    private static final Pattern MACRO_TEMPLATE_PATTERN = Pattern.compile("macroenabledtemplate$", 2);
    private static final long serialVersionUID = 2891763938430295453L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        input.mark(4);
        try {
            if (input.read() != 80 || input.read() != 75 || input.read() != 3 || input.read() != 4) {
                MediaType mediaType = MediaType.OCTET_STREAM;
                return mediaType;
            }
        }
        finally {
            input.reset();
        }
        TikaInputStream tis = TikaInputStream.cast(input);
        if (tis == null) return MediaType.APPLICATION_ZIP;
        try {
            ZipFile zip = new ZipFile(tis.getFile());
            try {
                MediaType type = ZipContainerDetector.detectOpenDocument(zip);
                if (type == null) {
                    type = ZipContainerDetector.detectOfficeOpenXML(zip, tis);
                }
                if (type == null) {
                    type = ZipContainerDetector.detectIWork(zip);
                }
                if (type != null) {
                    MediaType mediaType = type;
                    return mediaType;
                }
                if (zip.getEntry("META-INF/MANIFEST.MF") == null) return MediaType.APPLICATION_ZIP;
                MediaType mediaType = MediaType.application("java-archive");
                return mediaType;
            }
            finally {
                zip.close();
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return MediaType.APPLICATION_ZIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MediaType detectOpenDocument(ZipFile zip) {
        MediaType mediaType;
        ZipArchiveEntry mimetype = zip.getEntry("mimetype");
        if (mimetype == null) return null;
        InputStream stream = zip.getInputStream(mimetype);
        try {
            mediaType = MediaType.parse(IOUtils.toString(stream, "UTF-8"));
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        stream.close();
        return mediaType;
    }

    private static MediaType detectOfficeOpenXML(ZipFile zip, TikaInputStream stream) {
        try {
            if (zip.getEntry("_rels/.rels") != null || zip.getEntry("[Content_Types].xml") != null) {
                OPCPackage pkg = OPCPackage.open(stream.getFile().getPath(), PackageAccess.READ);
                stream.setOpenContainer(pkg);
                return ZipContainerDetector.detectOfficeOpenXML(pkg);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
        catch (InvalidFormatException e) {
            return null;
        }
    }

    public static MediaType detectOfficeOpenXML(OPCPackage pkg) {
        PackageRelationshipCollection core = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        if (core.size() != 1) {
            return null;
        }
        PackagePart corePart = pkg.getPart(core.getRelationship(0));
        String coreType = corePart.getContentType();
        String docType = coreType.substring(0, coreType.lastIndexOf(46));
        if (docType.toLowerCase().endsWith("macroenabled")) {
            docType = docType.toLowerCase() + ".12";
        }
        if (docType.toLowerCase().endsWith("macroenabledtemplate")) {
            docType = MACRO_TEMPLATE_PATTERN.matcher(docType).replaceAll("macroenabled.12");
        }
        return MediaType.parse(docType);
    }

    private static MediaType detectIWork(ZipFile zip) {
        if (zip.getEntry("buildVersionHistory.plist") != null) {
            for (String entryName : IWorkPackageParser.IWORK_CONTENT_ENTRIES) {
                IWorkPackageParser.IWORKDocumentType type = IWorkPackageParser.IWORKDocumentType.detectType(zip.getEntry(entryName), zip);
                if (type == null) continue;
                return type.getType();
            }
            return MediaType.application("vnd.apple.iwork");
        }
        return null;
    }
}

