/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import org.apache.poi.openxml4j.util.Nullable;
import org.apache.poi.xssf.extractor.XSSFEventBasedExcelExtractor;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.metadata.Property;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperties;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataExtractor {
    private final POIXMLTextExtractor extractor;

    public MetadataExtractor(POIXMLTextExtractor extractor) {
        this.extractor = extractor;
    }

    public void extract(Metadata metadata) throws TikaException {
        if (this.extractor.getDocument() != null || this.extractor instanceof XSSFEventBasedExcelExtractor && this.extractor.getPackage() != null) {
            this.extractMetadata(this.extractor.getCoreProperties(), metadata);
            this.extractMetadata(this.extractor.getExtendedProperties(), metadata);
            this.extractMetadata(this.extractor.getCustomProperties(), metadata);
        }
    }

    private void extractMetadata(POIXMLProperties.CoreProperties properties, Metadata metadata) {
        PackagePropertiesPart propsHolder = properties.getUnderlyingProperties();
        this.addProperty(metadata, "Category", propsHolder.getCategoryProperty());
        this.addProperty(metadata, "Content-Status", propsHolder.getContentStatusProperty());
        this.addProperty(metadata, Metadata.DATE, propsHolder.getCreatedProperty());
        this.addProperty(metadata, Metadata.CREATION_DATE, propsHolder.getCreatedProperty());
        this.addProperty(metadata, "creator", propsHolder.getCreatorProperty());
        this.addProperty(metadata, "Author", propsHolder.getCreatorProperty());
        this.addProperty(metadata, "description", propsHolder.getDescriptionProperty());
        this.addProperty(metadata, "identifier", propsHolder.getIdentifierProperty());
        this.addProperty(metadata, "Keywords", propsHolder.getKeywordsProperty());
        this.addProperty(metadata, "language", propsHolder.getLanguageProperty());
        this.addProperty(metadata, "Last-Author", propsHolder.getLastModifiedByProperty());
        this.addProperty(metadata, Metadata.LAST_PRINTED, propsHolder.getLastPrintedProperty());
        this.addProperty(metadata, Metadata.LAST_MODIFIED, propsHolder.getModifiedProperty());
        this.addProperty(metadata, "Revision-Number", propsHolder.getRevisionProperty());
        this.addProperty(metadata, "subject", propsHolder.getSubjectProperty());
        this.addProperty(metadata, "title", propsHolder.getTitleProperty());
        this.addProperty(metadata, "Version", propsHolder.getVersionProperty());
    }

    private void extractMetadata(POIXMLProperties.ExtendedProperties properties, Metadata metadata) {
        org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.CTProperties propsHolder = properties.getUnderlyingProperties();
        this.addProperty(metadata, "Application-Name", propsHolder.getApplication());
        this.addProperty(metadata, "Application-Version", propsHolder.getAppVersion());
        this.addProperty(metadata, Metadata.CHARACTER_COUNT, propsHolder.getCharacters());
        this.addProperty(metadata, Metadata.CHARACTER_COUNT_WITH_SPACES, propsHolder.getCharactersWithSpaces());
        this.addProperty(metadata, "publisher", propsHolder.getCompany());
        this.addProperty(metadata, Metadata.LINE_COUNT, propsHolder.getLines());
        this.addProperty(metadata, "Manager", propsHolder.getManager());
        this.addProperty(metadata, "Notes", propsHolder.getNotes());
        this.addProperty(metadata, Metadata.PAGE_COUNT, propsHolder.getPages());
        if (propsHolder.getPages() > 0) {
            metadata.set(PagedText.N_PAGES, propsHolder.getPages());
        } else if (propsHolder.getSlides() > 0) {
            metadata.set(PagedText.N_PAGES, propsHolder.getSlides());
        }
        this.addProperty(metadata, Metadata.PARAGRAPH_COUNT, propsHolder.getParagraphs());
        this.addProperty(metadata, "Presentation-Format", propsHolder.getPresentationFormat());
        this.addProperty(metadata, Metadata.SLIDE_COUNT, propsHolder.getSlides());
        this.addProperty(metadata, "Template", propsHolder.getTemplate());
        this.addProperty(metadata, "Total-Time", propsHolder.getTotalTime());
        this.addProperty(metadata, Metadata.WORD_COUNT, propsHolder.getWords());
    }

    private void extractMetadata(POIXMLProperties.CustomProperties properties, Metadata metadata) {
        CTProperties props = properties.getUnderlyingProperties();
        for (CTProperty property : props.getPropertyList()) {
            String val = null;
            Date date = null;
            if (property.isSetLpwstr()) {
                val = property.getLpwstr();
            } else if (property.isSetLpstr()) {
                val = property.getLpstr();
            } else if (property.isSetDate()) {
                date = property.getDate().getTime();
            } else if (property.isSetFiletime()) {
                date = property.getFiletime().getTime();
            } else if (property.isSetBool()) {
                val = Boolean.toString(property.getBool());
            } else if (property.isSetI1()) {
                val = Integer.toString(property.getI1());
            } else if (property.isSetI2()) {
                val = Integer.toString(property.getI2());
            } else if (property.isSetI4()) {
                val = Integer.toString(property.getI4());
            } else if (property.isSetI8()) {
                val = Long.toString(property.getI8());
            } else if (property.isSetInt()) {
                val = Integer.toString(property.getInt());
            } else if (property.isSetUi1()) {
                val = Integer.toString(property.getUi1());
            } else if (property.isSetUi2()) {
                val = Integer.toString(property.getUi2());
            } else if (property.isSetUi4()) {
                val = Long.toString(property.getUi4());
            } else if (property.isSetUi8()) {
                val = property.getUi8().toString();
            } else if (property.isSetUint()) {
                val = Long.toString(property.getUint());
            } else if (property.isSetR4()) {
                val = Float.toString(property.getR4());
            } else if (property.isSetR8()) {
                val = Double.toString(property.getR8());
            } else if (property.isSetDecimal()) {
                BigDecimal d = property.getDecimal();
                val = d == null ? null : d.toPlainString();
            } else if (property.isSetArray() || property.isSetVector() || property.isSetBlob() || property.isSetOblob() || property.isSetStream() || property.isSetOstream() || property.isSetVstream() || property.isSetStorage() || property.isSetOstorage()) {
                // empty if block
            }
            String propName = "custom:" + property.getName();
            if (date != null) {
                Property tikaProp = Property.externalDate(propName);
                metadata.set(tikaProp, date);
                continue;
            }
            if (val == null) continue;
            metadata.set(propName, val);
        }
    }

    private void addProperty(Metadata metadata, Property property, Nullable<Date> value) {
        if (value.getValue() != null) {
            metadata.set(property, value.getValue());
        }
    }

    private void addProperty(Metadata metadata, String name, Nullable<?> value) {
        if (value.getValue() != null) {
            this.addProperty(metadata, name, value.getValue().toString());
        }
    }

    private void addProperty(Metadata metadata, String name, String value) {
        if (value != null) {
            metadata.set(name, value);
        }
    }

    private void addProperty(Metadata metadata, Property property, int value) {
        if (value > 0) {
            metadata.set(property, value);
        }
    }

    private void addProperty(Metadata metadata, String name, int value) {
        if (value > 0) {
            metadata.set(name, Integer.toString(value));
        }
    }
}

