/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.FullContainerBox;
import java.io.IOException;

public class DataReferenceBox
extends FullContainerBox {
    public static final String TYPE = "dref";

    public DataReferenceBox() {
        super(TYPE);
    }

    protected long getContentSize() {
        return super.getContentSize() + 4L;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        Box box;
        this.setVersion(in.readUInt8());
        this.setFlags(in.readUInt24());
        in.readUInt32();
        for (long remainingContentSize = size - 8L; remainingContentSize > 0L; remainingContentSize -= box.getSize()) {
            box = boxParser.parseBox(in, this, lastMovieFragmentBox);
            this.boxes.add(box);
        }
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.getBoxes().size());
        super.getContent(os);
    }
}

