/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.PropertyBoxParserImpl;
import com.coremedia.iso.boxes.AbstractContainerBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import java.io.IOException;
import java.nio.charset.Charset;

public class IsoFile
extends AbstractContainerBox {
    protected BoxParser boxParser = this.createBoxParser();
    protected IsoBufferWrapper originalIso;

    public IsoFile(IsoBufferWrapper originalIso) {
        super(new byte[0]);
        this.originalIso = originalIso;
    }

    public IsoFile(IsoBufferWrapper originalIso, BoxParser boxParser) {
        this(originalIso);
        this.boxParser = boxParser;
    }

    protected BoxParser createBoxParser() {
        return new PropertyBoxParserImpl(new String[0]);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        throw new RuntimeException("This method is not meant to be used. Use parse() instead");
    }

    public void parse() throws IOException {
        boolean done = false;
        Box lastMovieFragmentBox = null;
        while (!done) {
            long sp = this.originalIso.position();
            if (this.originalIso.remaining() >= 8L) {
                Box box = this.boxParser.parseBox(this.originalIso, this, lastMovieFragmentBox);
                if (box != null) {
                    if (box instanceof MovieFragmentBox) {
                        lastMovieFragmentBox = box;
                    }
                    this.boxes.add(box);
                    assert (box.calculateOffset() == sp) : "calculated offset differs from offset in file";
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        this.parsed = done;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("IsoFile[");
        if (this.boxes == null) {
            buffer.append("unparsed");
        } else {
            for (int i = 0; i < this.boxes.size(); ++i) {
                if (i > 0) {
                    buffer.append(";");
                }
                buffer.append(((Box)this.boxes.get(i)).toString());
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static byte[] fourCCtoBytes(String fourCC) {
        byte[] result = new byte[4];
        if (fourCC != null) {
            for (int i = 0; i < Math.min(4, fourCC.length()); ++i) {
                result[i] = (byte)fourCC.charAt(i);
            }
        }
        return result;
    }

    public static String bytesToFourCC(byte[] type) {
        byte[] result = new byte[]{0, 0, 0, 0};
        if (type != null) {
            for (int i = 0; i < Math.min(type.length, 4); ++i) {
                result[i] = type[i];
            }
        }
        return new String(result, Charset.forName("ISO-8859-1"));
    }

    public long getNumOfBytesToFirstChild() {
        return 0L;
    }

    public long getSize() {
        long size = 0L;
        for (Box box : this.boxes) {
            size += box.getSize();
        }
        return size;
    }

    public long calculateOffset() {
        return 0L;
    }

    public long getOffset() {
        return 0L;
    }

    public IsoFile getIsoFile() {
        return this;
    }

    protected long getHeaderSize() {
        return 0L;
    }

    public byte[] getHeader() {
        return new byte[0];
    }

    public BoxParser getBoxParser() {
        return this.boxParser;
    }

    public IsoBufferWrapper getOriginalIso() {
        return this.originalIso;
    }

    public MovieBox getMovieBox() {
        for (Box box : this.boxes) {
            if (!(box instanceof MovieBox)) continue;
            return (MovieBox)box;
        }
        return null;
    }
}

