/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.util.finder.ClassFinder;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterface;
import com.opensymphony.xwork2.util.finder.Test;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.StrutsException;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class DefaultClassFinder
implements ClassFinder {
    private static final Logger LOG = LogManager.getLogger(DefaultClassFinder.class);
    private final Map<String, List<ClassFinder.Info>> annotated = new HashMap<String, List<ClassFinder.Info>>();
    private final Map<String, ClassFinder.ClassInfo> classInfos = new LinkedHashMap<String, ClassFinder.ClassInfo>();
    private final List<String> classesNotLoaded = new ArrayList<String>();
    private final ClassLoaderInterface classLoaderInterface;
    private final boolean extractBaseInterfaces;
    private final FileManager fileManager;

    public DefaultClassFinder(ClassLoaderInterface classLoaderInterface, Collection<URL> urls, boolean extractBaseInterfaces, Set<String> protocols, Test<String> classNameFilter) {
        this.classLoaderInterface = classLoaderInterface;
        this.extractBaseInterfaces = extractBaseInterfaces;
        this.fileManager = ((FileManagerFactory)ActionContext.getContext().getInstance(FileManagerFactory.class)).getFileManager();
        ArrayList<String> classNames = new ArrayList<String>();
        for (URL location : urls) {
            try {
                if (protocols.contains(location.getProtocol())) {
                    classNames.addAll(this.jar(location));
                    continue;
                }
                if (!"file".equals(location.getProtocol())) continue;
                try {
                    URL jarUrl = new URL("jar", "", location.toExternalForm() + "!/");
                    JarURLConnection juc = (JarURLConnection)jarUrl.openConnection();
                    juc.getJarFile();
                    classNames.addAll(this.jar(jarUrl));
                }
                catch (IOException e) {
                    classNames.addAll(this.file(location));
                }
            }
            catch (Exception e) {
                LOG.error("Unable to read URL [{}]", (Object)location.toExternalForm(), (Object)e);
            }
        }
        for (String className : classNames) {
            try {
                if (!classNameFilter.test((Object)className)) continue;
                this.readClassDef(className);
            }
            catch (Throwable e) {
                LOG.error("Unable to read class [{}]", (Object)className, (Object)e);
            }
        }
    }

    public ClassLoaderInterface getClassLoaderInterface() {
        return this.classLoaderInterface;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        List<ClassFinder.Info> infos = this.annotated.get(annotation.getName());
        return infos != null && !infos.isEmpty();
    }

    public List<String> getClassesNotLoaded() {
        return Collections.unmodifiableList(this.classesNotLoaded);
    }

    public List<Package> findAnnotatedPackages(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<Package> packages = new ArrayList<Package>();
        List<ClassFinder.Info> infos = this.getAnnotationInfos(annotation.getName());
        for (ClassFinder.Info info : infos) {
            if (!(info instanceof ClassFinder.PackageInfo)) continue;
            ClassFinder.PackageInfo packageInfo = (ClassFinder.PackageInfo)info;
            try {
                Package pkg = packageInfo.get();
                if (!pkg.isAnnotationPresent(annotation)) continue;
                packages.add(pkg);
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(packageInfo.getName());
            }
        }
        return packages;
    }

    public List<Class<?>> findAnnotatedClasses(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList classes = new ArrayList();
        List<ClassFinder.Info> infos = this.getAnnotationInfos(annotation.getName());
        for (ClassFinder.Info info : infos) {
            if (!(info instanceof ClassFinder.ClassInfo)) continue;
            ClassFinder.ClassInfo classInfo = (ClassFinder.ClassInfo)info;
            try {
                Class clazz = classInfo.get();
                if (!clazz.isAnnotationPresent(annotation)) continue;
                classes.add(clazz);
            }
            catch (Throwable e) {
                LOG.error("Error loading class [{}]", (Object)classInfo.getName(), (Object)e);
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassFinder.ClassInfo> seen = new ArrayList<ClassFinder.ClassInfo>();
        ArrayList<Method> methods = new ArrayList<Method>();
        List<ClassFinder.Info> infos = this.getAnnotationInfos(annotation.getName());
        for (ClassFinder.Info info : infos) {
            ClassFinder.MethodInfo methodInfo;
            ClassFinder.ClassInfo classInfo;
            if (!(info instanceof ClassFinder.MethodInfo) || "<init>".equals(info.getName()) || seen.contains(classInfo = (methodInfo = (ClassFinder.MethodInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class clazz = classInfo.get();
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    methods.add(method);
                }
            }
            catch (Throwable e) {
                LOG.error("Error loading class [{}]", (Object)classInfo.getName(), (Object)e);
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return methods;
    }

    public List<Constructor<?>> findAnnotatedConstructors(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassFinder.ClassInfo> seen = new ArrayList<ClassFinder.ClassInfo>();
        ArrayList constructors = new ArrayList();
        List<ClassFinder.Info> infos = this.getAnnotationInfos(annotation.getName());
        for (ClassFinder.Info info : infos) {
            ClassFinder.MethodInfo methodInfo;
            ClassFinder.ClassInfo classInfo;
            if (!(info instanceof ClassFinder.MethodInfo) || !"<init>".equals(info.getName()) || seen.contains(classInfo = (methodInfo = (ClassFinder.MethodInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class clazz = classInfo.get();
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    if (!constructor.isAnnotationPresent(annotation)) continue;
                    constructors.add(constructor);
                }
            }
            catch (Throwable e) {
                LOG.error("Error loading class [{}]", (Object)classInfo.getName(), (Object)e);
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return constructors;
    }

    public List<Field> findAnnotatedFields(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassFinder.ClassInfo> seen = new ArrayList<ClassFinder.ClassInfo>();
        ArrayList<Field> fields = new ArrayList<Field>();
        List<ClassFinder.Info> infos = this.getAnnotationInfos(annotation.getName());
        for (ClassFinder.Info info : infos) {
            ClassFinder.FieldInfo fieldInfo;
            ClassFinder.ClassInfo classInfo;
            if (!(info instanceof ClassFinder.FieldInfo) || seen.contains(classInfo = (fieldInfo = (ClassFinder.FieldInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class clazz = classInfo.get();
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(annotation)) continue;
                    fields.add(field);
                }
            }
            catch (Throwable e) {
                LOG.error("Error loading class [{}]", (Object)classInfo.getName(), (Object)e);
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return fields;
    }

    public List<Class<?>> findClassesInPackage(String packageName, boolean recursive) {
        this.classesNotLoaded.clear();
        ArrayList classes = new ArrayList();
        for (ClassFinder.ClassInfo classInfo : this.classInfos.values()) {
            try {
                if (recursive && classInfo.getPackageName().startsWith(packageName)) {
                    classes.add(classInfo.get());
                    continue;
                }
                if (!classInfo.getPackageName().equals(packageName)) continue;
                classes.add(classInfo.get());
            }
            catch (Throwable e) {
                LOG.error("Error loading class [{}]", (Object)classInfo.getName(), (Object)e);
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    public List<Class<?>> findClasses(Test<ClassFinder.ClassInfo> test) {
        this.classesNotLoaded.clear();
        ArrayList classes = new ArrayList();
        for (ClassFinder.ClassInfo classInfo : this.classInfos.values()) {
            try {
                if (!test.test((Object)classInfo)) continue;
                classes.add(classInfo.get());
            }
            catch (Throwable e) {
                LOG.error("Error loading class [{}]", (Object)classInfo.getName(), (Object)e);
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    public List<Class<?>> findClasses() {
        this.classesNotLoaded.clear();
        ArrayList classes = new ArrayList();
        for (ClassFinder.ClassInfo classInfo : this.classInfos.values()) {
            try {
                classes.add(classInfo.get());
            }
            catch (Throwable e) {
                LOG.error("Error loading class [{}]", (Object)classInfo.getName(), (Object)e);
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    private List<String> file(URL location) throws UnsupportedEncodingException {
        ArrayList<String> classNames = new ArrayList<String>();
        File dir = new File(URLDecoder.decode(location.getPath(), "UTF-8"));
        if ("META-INF".equals(dir.getName())) {
            dir = dir.getParentFile();
        }
        if (dir.isDirectory()) {
            this.scanDir(dir, classNames, "");
        }
        return classNames;
    }

    private void scanDir(File dir, List<String> classNames, String packageName) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.scanDir(file, classNames, packageName + file.getName() + ".");
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                String name = file.getName();
                name = name.replaceFirst(".class$", "");
                classNames.add(StringUtils.removeStart((String)packageName, (String)"WEB-INF.classes.") + name);
            }
        }
    }

    private List<String> jar(URL location) throws IOException {
        URL url = this.fileManager.normalizeToFileProtocol(location);
        if (url != null) {
            try (InputStream in = url.openStream();){
                JarInputStream jarStream = new JarInputStream(in);
                List<String> list = this.jar(jarStream);
                return list;
            }
        }
        LOG.debug("Unable to read [{}]", (Object)location.toExternalForm());
        return Collections.emptyList();
    }

    private List<String> jar(JarInputStream jarStream) throws IOException {
        JarEntry entry;
        ArrayList<String> classNames = new ArrayList<String>();
        while ((entry = jarStream.getNextJarEntry()) != null) {
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            String className = entry.getName();
            className = className.replaceFirst(".class$", "");
            className = StringUtils.removeStart((String)className, (String)"WEB-INF/classes/");
            className = className.replace('/', '.');
            classNames.add(className);
        }
        return classNames;
    }

    private List<ClassFinder.Info> getAnnotationInfos(String name) {
        return this.annotated.computeIfAbsent(name, k -> new ArrayList());
    }

    private void readClassDef(String className) {
        block16: {
            if (!className.endsWith(".class")) {
                className = className.replace('.', '/') + ".class";
            }
            try {
                URL resource = this.classLoaderInterface.getResource(className);
                if (resource != null) {
                    try (InputStream in = resource.openStream();){
                        ClassReader classReader = new ClassReader(in);
                        classReader.accept((ClassVisitor)new InfoBuildingVisitor(this), 2);
                        break block16;
                    }
                }
                throw new StrutsException("Could not load " + className);
            }
            catch (IOException e) {
                throw new StrutsException("Could not load " + className, (Throwable)e);
            }
        }
    }

    public class InfoBuildingMethodVisitor
    extends MethodVisitor {
        private ClassFinder.Info info;

        public InfoBuildingMethodVisitor() {
            super(458752);
        }

        public InfoBuildingMethodVisitor(ClassFinder.Info info) {
            this();
            this.info = info;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            ClassFinder.AnnotationInfo annotationInfo = new ClassFinder.AnnotationInfo(desc);
            this.info.getAnnotations().add(annotationInfo);
            DefaultClassFinder.this.getAnnotationInfos(annotationInfo.getName()).add(this.info);
            return null;
        }

        public AnnotationVisitor visitParameterAnnotation(int param, String desc, boolean visible) {
            ClassFinder.MethodInfo methodInfo = (ClassFinder.MethodInfo)this.info;
            List annotationInfos = methodInfo.getParameterAnnotations(param);
            ClassFinder.AnnotationInfo annotationInfo = new ClassFinder.AnnotationInfo(desc);
            annotationInfos.add(annotationInfo);
            return null;
        }
    }

    public class InfoBuildingVisitor
    extends ClassVisitor {
        private final ClassFinder classFinder;
        private ClassFinder.Info info;

        public InfoBuildingVisitor(ClassFinder classFinder) {
            super(589824);
            this.classFinder = classFinder;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (name.endsWith("package-info")) {
                this.info = new ClassFinder.PackageInfo(this.javaName(name), this.classFinder);
            } else {
                ClassFinder.ClassInfo classInfo = new ClassFinder.ClassInfo(this.javaName(name), this.javaName(superName), this.classFinder);
                for (String interfce : interfaces) {
                    classInfo.getInterfaces().add(this.javaName(interfce));
                }
                this.info = classInfo;
                DefaultClassFinder.this.classInfos.put(classInfo.getName(), classInfo);
                if (DefaultClassFinder.this.extractBaseInterfaces) {
                    this.extractSuperInterfaces(classInfo);
                }
            }
        }

        private void extractSuperInterfaces(ClassFinder.ClassInfo classInfo) {
            String superType = classInfo.getSuperType();
            if (superType != null) {
                ClassFinder.ClassInfo base = (ClassFinder.ClassInfo)DefaultClassFinder.this.classInfos.get(superType);
                if (base == null) {
                    String resource = superType.replace('.', '/') + ".class";
                    DefaultClassFinder.this.readClassDef(resource);
                    base = (ClassFinder.ClassInfo)DefaultClassFinder.this.classInfos.get(superType);
                }
                if (base != null) {
                    List interfaces = classInfo.getSuperInterfaces();
                    interfaces.addAll(base.getSuperInterfaces());
                    interfaces.addAll(base.getInterfaces());
                }
            }
        }

        private String javaName(String name) {
            return name == null ? null : name.replace('/', '.');
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            ClassFinder.AnnotationInfo annotationInfo = new ClassFinder.AnnotationInfo(desc);
            this.info.getAnnotations().add(annotationInfo);
            DefaultClassFinder.this.getAnnotationInfos(annotationInfo.getName()).add(this.info);
            return null;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ClassFinder.ClassInfo classInfo = (ClassFinder.ClassInfo)this.info;
            ClassFinder.FieldInfo fieldInfo = new ClassFinder.FieldInfo(classInfo, name, desc);
            classInfo.getFields().add(fieldInfo);
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            ClassFinder.ClassInfo classInfo = (ClassFinder.ClassInfo)this.info;
            ClassFinder.MethodInfo methodInfo = new ClassFinder.MethodInfo(classInfo, name, desc);
            classInfo.getMethods().add(methodInfo);
            return new InfoBuildingMethodVisitor((ClassFinder.Info)methodInfo);
        }
    }
}

