/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;

public class QueryRequest
extends SolrRequest {
    private SolrParams query;

    public QueryRequest() {
        super(SolrRequest.METHOD.GET, null);
    }

    public QueryRequest(SolrParams q) {
        super(SolrRequest.METHOD.GET, null);
        this.query = q;
    }

    public QueryRequest(SolrParams q, SolrRequest.METHOD method) {
        super(method, null);
        this.query = q;
    }

    @Override
    public String getPath() {
        String qt;
        String string = qt = this.query == null ? null : this.query.get("qt");
        if (qt == null) {
            qt = super.getPath();
        }
        if (qt != null && qt.startsWith("/")) {
            return qt;
        }
        return "/select";
    }

    @Override
    public Collection<ContentStream> getContentStreams() {
        return null;
    }

    @Override
    public SolrParams getParams() {
        return this.query;
    }

    @Override
    public QueryResponse process(SolrClient client) throws SolrServerException {
        try {
            long startTime = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
            QueryResponse res = new QueryResponse(client.request(this), client);
            long endTime = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
            res.setElapsedTime(endTime - startTime);
            return res;
        }
        catch (SolrServerException e) {
            throw e;
        }
        catch (SolrException s) {
            throw s;
        }
        catch (Exception e) {
            throw new SolrServerException("Error executing query", e);
        }
    }
}

