/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.XML;

public class UpdateRequestExt
extends AbstractUpdateRequest {
    private List<SolrDoc> documents = null;
    private Map<String, Long> deleteById = null;
    private List<String> deleteQuery = null;

    public UpdateRequestExt() {
        super(SolrRequest.METHOD.POST, "/update");
    }

    public UpdateRequestExt(String url) {
        super(SolrRequest.METHOD.POST, url);
    }

    public void clear() {
        if (this.documents != null) {
            this.documents.clear();
        }
        if (this.deleteById != null) {
            this.deleteById.clear();
        }
        if (this.deleteQuery != null) {
            this.deleteQuery.clear();
        }
    }

    public UpdateRequestExt add(SolrInputDocument doc) {
        if (this.documents == null) {
            this.documents = new ArrayList<SolrDoc>(2);
        }
        SolrDoc solrDoc = new SolrDoc();
        solrDoc.document = doc;
        solrDoc.commitWithin = -1;
        solrDoc.overwrite = true;
        this.documents.add(solrDoc);
        return this;
    }

    public UpdateRequestExt add(SolrInputDocument doc, int commitWithin, boolean overwrite) {
        if (this.documents == null) {
            this.documents = new ArrayList<SolrDoc>(2);
        }
        SolrDoc solrDoc = new SolrDoc();
        solrDoc.document = doc;
        solrDoc.commitWithin = commitWithin;
        solrDoc.overwrite = overwrite;
        this.documents.add(solrDoc);
        return this;
    }

    public UpdateRequestExt deleteById(String id) {
        if (this.deleteById == null) {
            this.deleteById = new HashMap<String, Long>();
        }
        this.deleteById.put(id, null);
        return this;
    }

    public UpdateRequestExt deleteById(String id, Long version) {
        if (this.deleteById == null) {
            this.deleteById = new HashMap<String, Long>();
        }
        this.deleteById.put(id, version);
        return this;
    }

    public UpdateRequestExt deleteById(List<String> ids) {
        if (this.deleteById == null) {
            this.deleteById = new HashMap<String, Long>();
        } else {
            for (String id : ids) {
                this.deleteById.put(id, null);
            }
        }
        return this;
    }

    public UpdateRequestExt deleteByQuery(String q) {
        if (this.deleteQuery == null) {
            this.deleteQuery = new ArrayList<String>();
        }
        this.deleteQuery.add(q);
        return this;
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        return ClientUtils.toContentStreams(this.getXML(), "application/xml; charset=UTF-8");
    }

    public String getXML() throws IOException {
        StringWriter writer = new StringWriter();
        this.writeXML(writer);
        writer.flush();
        String xml = writer.toString();
        return xml.length() > 0 ? xml : null;
    }

    public void writeXML(Writer writer) throws IOException {
        boolean deleteQ;
        List<List<SolrDoc>> getDocLists = this.getDocLists(this.documents);
        for (List<SolrDoc> docs : getDocLists) {
            if (docs == null || docs.size() <= 0) continue;
            SolrDoc firstDoc = docs.get(0);
            int n = firstDoc.commitWithin != -1 ? firstDoc.commitWithin : this.commitWithin;
            boolean overwrite = firstDoc.overwrite;
            if (n > -1 || !overwrite) {
                writer.write("<add commitWithin=\"" + n + "\" " + "overwrite=\"" + overwrite + "\">");
            } else {
                writer.write("<add>");
            }
            if (this.documents != null) {
                for (SolrDoc doc : this.documents) {
                    if (doc == null) continue;
                    ClientUtils.writeXML(doc.document, writer);
                }
            }
            writer.write("</add>");
        }
        boolean deleteI = this.deleteById != null && this.deleteById.size() > 0;
        boolean bl = deleteQ = this.deleteQuery != null && this.deleteQuery.size() > 0;
        if (deleteI || deleteQ) {
            writer.append("<delete>");
            if (deleteI) {
                for (Map.Entry entry : this.deleteById.entrySet()) {
                    writer.append("<id");
                    Long version = (Long)entry.getValue();
                    if (version != null) {
                        writer.append(" version=\"" + version + "\"");
                    }
                    writer.append(">");
                    XML.escapeCharData((String)entry.getKey(), writer);
                    writer.append("</id>");
                }
            }
            if (deleteQ) {
                for (String string : this.deleteQuery) {
                    writer.append("<query>");
                    XML.escapeCharData(string, writer);
                    writer.append("</query>");
                }
            }
            writer.append("</delete>");
        }
    }

    private List<List<SolrDoc>> getDocLists(List<SolrDoc> documents) {
        ArrayList<List<SolrDoc>> docLists = new ArrayList<List<SolrDoc>>();
        if (this.documents == null) {
            return docLists;
        }
        boolean lastOverwrite = true;
        int lastCommitWithin = -1;
        ArrayList<SolrDoc> docList = null;
        for (SolrDoc doc : this.documents) {
            if (doc.overwrite != lastOverwrite || doc.commitWithin != lastCommitWithin || docLists.size() == 0) {
                docList = new ArrayList<SolrDoc>();
                docLists.add(docList);
            }
            docList.add(doc);
            lastCommitWithin = doc.commitWithin;
            lastOverwrite = doc.overwrite;
        }
        return docLists;
    }

    public Map<String, Long> getDeleteById() {
        return this.deleteById;
    }

    public List<String> getDeleteQuery() {
        return this.deleteQuery;
    }

    public String toString() {
        return "UpdateRequestExt [documents=" + this.documents + ", deleteById=" + this.deleteById + ", deleteQuery=" + this.deleteQuery + "]";
    }

    private class SolrDoc {
        SolrInputDocument document;
        int commitWithin;
        boolean overwrite;

        private SolrDoc() {
        }

        public String toString() {
            return "SolrDoc [document=" + this.document + ", commitWithin=" + this.commitWithin + ", overwrite=" + this.overwrite + "]";
        }
    }
}

