/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;

public class StreamingBinaryResponseParser
extends BinaryResponseParser {
    final StreamingResponseCallback callback;

    public StreamingBinaryResponseParser(StreamingResponseCallback cb) {
        this.callback = cb;
    }

    @Override
    public NamedList<Object> processResponse(InputStream body, String encoding) {
        try {
            JavaBinCodec codec = new JavaBinCodec(){

                @Override
                public SolrDocument readSolrDocument(FastInputStream dis) throws IOException {
                    SolrDocument doc = super.readSolrDocument(dis);
                    StreamingBinaryResponseParser.this.callback.streamSolrDocument(doc);
                    return null;
                }

                @Override
                public SolrDocumentList readSolrDocumentList(FastInputStream dis) throws IOException {
                    SolrDocumentList solrDocs = new SolrDocumentList();
                    List list = (List)this.readVal(dis);
                    solrDocs.setNumFound((Long)list.get(0));
                    solrDocs.setStart((Long)list.get(1));
                    solrDocs.setMaxScore((Float)list.get(2));
                    StreamingBinaryResponseParser.this.callback.streamDocListInfo(solrDocs.getNumFound(), solrDocs.getStart(), solrDocs.getMaxScore());
                    this.tagByte = dis.readByte();
                    if (this.tagByte >>> 5 != 0x7FFFFFC) {
                        throw new RuntimeException("doclist must have an array");
                    }
                    int sz = this.readSize(dis);
                    for (int i = 0; i < sz; ++i) {
                        this.readVal(dis);
                    }
                    return solrDocs;
                }
            };
            return (NamedList)codec.unmarshal(body);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "parsing error", e);
        }
    }
}

