/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.noggit.JSONUtil;
import org.apache.noggit.JSONWriter;
import org.apache.solr.common.cloud.ZkStateReader;

public class ZkNodeProps
implements JSONWriter.Writable {
    protected final Map<String, Object> propMap;

    public ZkNodeProps(Map<String, Object> propMap) {
        this.propMap = propMap;
    }

    public ZkNodeProps(String ... keyVals) {
        this(ZkNodeProps.makeMap(keyVals));
    }

    public static ZkNodeProps fromKeyVals(Object ... keyVals) {
        return new ZkNodeProps(ZkNodeProps.makeMap(keyVals));
    }

    public static Map<String, Object> makeMap(Object ... keyVals) {
        if ((keyVals.length & 1) != 0) {
            throw new IllegalArgumentException("arguments should be key,value");
        }
        HashMap<String, Object> propMap = new HashMap<String, Object>(keyVals.length >> 1);
        for (int i = 0; i < keyVals.length; i += 2) {
            propMap.put(keyVals[i].toString(), keyVals[i + 1]);
        }
        return propMap;
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.propMap.keySet());
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.propMap);
    }

    public Map<String, Object> shallowCopy() {
        return new LinkedHashMap<String, Object>(this.propMap);
    }

    public static ZkNodeProps load(byte[] bytes) {
        Map props = (Map)ZkStateReader.fromJSON(bytes);
        return new ZkNodeProps(props);
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        jsonWriter.write(this.propMap);
    }

    public String getStr(String key) {
        Object o = this.propMap.get(key);
        return o == null ? null : o.toString();
    }

    public Object get(String key) {
        return this.propMap.get(key);
    }

    public String toString() {
        return JSONUtil.toJSON(this);
    }

    public boolean containsKey(String key) {
        return this.propMap.containsKey(key);
    }
}

