/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.variant;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.variant.Variant;
import org.apache.parquet.variant.VariantArrayBuilder;
import org.apache.parquet.variant.VariantBuilder;
import org.apache.parquet.variant.VariantObjectBuilder;
import org.apache.parquet.variant.VariantUtil;

public class VariantConverters {
    private VariantConverters() {
    }

    public static GroupConverter newVariantConverter(GroupType variantGroup, Consumer<ByteBuffer> metadata, ParentConverter<VariantBuilder> parent) {
        ValueConverter converter = VariantConverters.newValueConverter(variantGroup, parent);
        if (variantGroup.containsField("metadata")) {
            int metadataIndex = variantGroup.getFieldIndex("metadata");
            Type metadataField = variantGroup.getType("metadata");
            Preconditions.checkArgument((boolean)VariantConverters.isBinary(metadataField), (String)("Invalid metadata field: " + metadataField));
            converter.setConverter(metadataIndex, (Converter)new VariantMetadataConverter(metadata));
        }
        return converter;
    }

    static ValueConverter newValueConverter(GroupType valueGroup, ParentConverter<VariantBuilder> parent) {
        Type typedValueField;
        if (valueGroup.containsField("typed_value") && VariantConverters.isShreddedObject(typedValueField = valueGroup.getType("typed_value"))) {
            return new ShreddedObjectConverter(valueGroup, parent);
        }
        return new ShreddedValueConverter(valueGroup, parent);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Converter newScalarConverter(PrimitiveType primitive, ParentConverter<VariantBuilder> parent) {
        void var2_25;
        Object var2_2 = null;
        LogicalTypeAnnotation annotation = primitive.getLogicalTypeAnnotation();
        PrimitiveType.PrimitiveTypeName primitiveType = primitive.getPrimitiveTypeName();
        if (primitiveType == PrimitiveType.PrimitiveTypeName.BOOLEAN) {
            VariantBooleanConverter variantBooleanConverter = new VariantBooleanConverter(parent);
            return var2_25;
        } else if (annotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
            LogicalTypeAnnotation.IntLogicalTypeAnnotation intAnnotation = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)annotation;
            if (!intAnnotation.isSigned()) {
                throw new UnsupportedOperationException("Unsupported shredded value type: " + intAnnotation);
            }
            int width = intAnnotation.getBitWidth();
            if (width == 8) {
                VariantByteConverter variantByteConverter = new VariantByteConverter(parent);
                return var2_25;
            } else if (width == 16) {
                VariantShortConverter variantShortConverter = new VariantShortConverter(parent);
                return var2_25;
            } else if (width == 32) {
                VariantIntConverter variantIntConverter = new VariantIntConverter(parent);
                return var2_25;
            } else {
                if (width != 64) throw new UnsupportedOperationException("Unsupported shredded value type: " + intAnnotation);
                VariantLongConverter variantLongConverter = new VariantLongConverter(parent);
            }
            return var2_25;
        } else if (annotation == null && primitiveType == PrimitiveType.PrimitiveTypeName.INT32) {
            VariantIntConverter variantIntConverter = new VariantIntConverter(parent);
            return var2_25;
        } else if (annotation == null && primitiveType == PrimitiveType.PrimitiveTypeName.INT64) {
            VariantLongConverter variantLongConverter = new VariantLongConverter(parent);
            return var2_25;
        } else if (primitiveType == PrimitiveType.PrimitiveTypeName.FLOAT) {
            VariantFloatConverter variantFloatConverter = new VariantFloatConverter(parent);
            return var2_25;
        } else if (primitiveType == PrimitiveType.PrimitiveTypeName.DOUBLE) {
            VariantDoubleConverter variantDoubleConverter = new VariantDoubleConverter(parent);
            return var2_25;
        } else if (annotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)annotation;
            VariantDecimalConverter variantDecimalConverter = new VariantDecimalConverter(parent, decimalType.getScale());
            return var2_25;
        } else if (annotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
            VariantDateConverter variantDateConverter = new VariantDateConverter(parent);
            return var2_25;
        } else if (annotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
            LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampType = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)annotation;
            if (timestampType.isAdjustedToUTC()) {
                switch (timestampType.getUnit()) {
                    case MILLIS: {
                        throw new UnsupportedOperationException("MILLIS not supported by Variant");
                    }
                    case MICROS: {
                        VariantTimestampConverter variantTimestampConverter = new VariantTimestampConverter(parent);
                        return var2_25;
                    }
                    case NANOS: {
                        VariantTimestampNanosConverter variantTimestampNanosConverter = new VariantTimestampNanosConverter(parent);
                    }
                }
                return var2_25;
            } else {
                switch (timestampType.getUnit()) {
                    case MILLIS: {
                        throw new UnsupportedOperationException("MILLIS not supported by Variant");
                    }
                    case MICROS: {
                        VariantTimestampNtzConverter variantTimestampNtzConverter = new VariantTimestampNtzConverter(parent);
                        return var2_25;
                    }
                    case NANOS: {
                        VariantTimestampNanosNtzConverter variantTimestampNanosNtzConverter = new VariantTimestampNanosNtzConverter(parent);
                    }
                }
            }
            return var2_25;
        } else if (annotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
            LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeType = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)annotation;
            if (timeType.isAdjustedToUTC() || timeType.getUnit() != LogicalTypeAnnotation.TimeUnit.MICROS) {
                throw new UnsupportedOperationException(timeType + " not supported by Variant");
            }
            VariantTimeConverter variantTimeConverter = new VariantTimeConverter(parent);
            return var2_25;
        } else if (annotation instanceof LogicalTypeAnnotation.UUIDLogicalTypeAnnotation) {
            VariantUUIDConverter variantUUIDConverter = new VariantUUIDConverter(parent);
            return var2_25;
        } else if (annotation instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation) {
            VariantStringConverter variantStringConverter = new VariantStringConverter(parent);
            return var2_25;
        } else {
            if (primitiveType != PrimitiveType.PrimitiveTypeName.BINARY) throw new UnsupportedOperationException("Unsupported shredded value type: " + primitive);
            VariantBinaryConverter variantBinaryConverter = new VariantBinaryConverter(parent);
        }
        return var2_25;
    }

    private static boolean isBinary(Type field) {
        return field.isPrimitive() && field.asPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY;
    }

    private static boolean isShreddedArray(Type typedValueField) {
        return typedValueField.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation;
    }

    private static boolean isShreddedObject(Type typedValueField) {
        return !typedValueField.isPrimitive() && !VariantConverters.isShreddedArray(typedValueField);
    }

    private static abstract class BinaryConverter
    extends PrimitiveConverter {
        Binary[] dict = null;

        private BinaryConverter() {
        }

        protected abstract void handleBinary(Binary var1);

        public boolean hasDictionarySupport() {
            return true;
        }

        public void setDictionary(Dictionary dictionary) {
            this.dict = new Binary[dictionary.getMaxId() + 1];
            for (int i = 0; i <= dictionary.getMaxId(); ++i) {
                this.dict[i] = dictionary.decodeToBinary(i);
            }
        }

        public void addBinary(Binary value) {
            this.handleBinary(value);
        }

        public void addValueFromDictionary(int dictionaryId) {
            this.handleBinary(this.dict[dictionaryId]);
        }
    }

    static class VariantTimestampNanosNtzConverter
    extends ShreddedScalarConverter {
        VariantTimestampNanosNtzConverter(ParentConverter<VariantBuilder> parentBuilder) {
            super(parentBuilder);
        }

        public void addLong(long value) {
            this.parent.build(builder -> builder.appendTimestampNanosNtz(value));
        }
    }

    static class VariantTimestampNanosConverter
    extends ShreddedScalarConverter {
        VariantTimestampNanosConverter(ParentConverter<VariantBuilder> parentBuilder) {
            super(parentBuilder);
        }

        public void addLong(long value) {
            this.parent.build(builder -> builder.appendTimestampNanosTz(value));
        }
    }

    static class VariantTimestampNtzConverter
    extends ShreddedScalarConverter {
        VariantTimestampNtzConverter(ParentConverter<VariantBuilder> parentBuilder) {
            super(parentBuilder);
        }

        public void addLong(long value) {
            this.parent.build(builder -> builder.appendTimestampNtz(value));
        }
    }

    static class VariantTimestampConverter
    extends ShreddedScalarConverter {
        VariantTimestampConverter(ParentConverter<VariantBuilder> parentBuilder) {
            super(parentBuilder);
        }

        public void addLong(long value) {
            this.parent.build(builder -> builder.appendTimestampTz(value));
        }
    }

    static class VariantTimeConverter
    extends ShreddedScalarConverter {
        VariantTimeConverter(ParentConverter<VariantBuilder> parentBuilder) {
            super(parentBuilder);
        }

        public void addLong(long value) {
            this.parent.build(builder -> builder.appendTime(value));
        }
    }

    static class VariantDateConverter
    extends ShreddedScalarConverter {
        VariantDateConverter(ParentConverter<VariantBuilder> parentBuilder) {
            super(parentBuilder);
        }

        public void addInt(int value) {
            this.parent.build(builder -> builder.appendDate(value));
        }
    }

    static class VariantLongConverter
    extends ShreddedScalarConverter {
        VariantLongConverter(ParentConverter<VariantBuilder> parentBuilder) {
            super(parentBuilder);
        }

        public void addLong(long value) {
            this.parent.build(builder -> builder.appendLong(value));
        }
    }

    static class VariantIntConverter
    extends ShreddedScalarConverter {
        VariantIntConverter(ParentConverter<VariantBuilder> parentBuilder) {
            super(parentBuilder);
        }

        public void addInt(int value) {
            this.parent.build(builder -> builder.appendInt(value));
        }
    }

    static class VariantShortConverter
    extends ShreddedScalarConverter {
        VariantShortConverter(ParentConverter<VariantBuilder> parentBuilder) {
            super(parentBuilder);
        }

        public void addInt(int value) {
            this.parent.build(builder -> builder.appendShort((short)value));
        }
    }

    static class VariantByteConverter
    extends ShreddedScalarConverter {
        VariantByteConverter(ParentConverter<VariantBuilder> parentBuilder) {
            super(parentBuilder);
        }

        public void addInt(int value) {
            this.parent.build(builder -> builder.appendByte((byte)value));
        }
    }

    static class VariantFloatConverter
    extends ShreddedScalarConverter {
        VariantFloatConverter(ParentConverter<VariantBuilder> parentBuilder) {
            super(parentBuilder);
        }

        public void addFloat(float value) {
            this.parent.build(builder -> builder.appendFloat(value));
        }
    }

    static class VariantDoubleConverter
    extends ShreddedScalarConverter {
        VariantDoubleConverter(ParentConverter<VariantBuilder> parentBuilder) {
            super(parentBuilder);
        }

        public void addDouble(double value) {
            this.parent.build(builder -> builder.appendDouble(value));
        }
    }

    static class VariantBooleanConverter
    extends ShreddedScalarConverter {
        VariantBooleanConverter(ParentConverter<VariantBuilder> parentBuilder) {
            super(parentBuilder);
        }

        public void addBoolean(boolean value) {
            this.parent.build(builder -> builder.appendBoolean(value));
        }
    }

    static class VariantUUIDConverter
    extends ShreddedScalarConverter {
        VariantUUIDConverter(ParentConverter<VariantBuilder> parentBuilder) {
            super(parentBuilder);
        }

        public void addBinary(Binary value) {
            this.parent.build(builder -> builder.appendUUIDBytes(value.toByteBuffer()));
        }
    }

    static class VariantDecimalConverter
    extends ShreddedScalarConverter {
        private int scale;

        VariantDecimalConverter(ParentConverter<VariantBuilder> parent, int scale) {
            super(parent);
            this.scale = scale;
        }

        public void addBinary(Binary value) {
            this.parent.build(builder -> builder.appendDecimal(new BigDecimal(new BigInteger(value.getBytes()), this.scale)));
        }

        public void addLong(long value) {
            BigDecimal decimal = BigDecimal.valueOf(value, this.scale);
            this.parent.build(builder -> builder.appendDecimal(decimal));
        }

        public void addInt(int value) {
            BigDecimal decimal = BigDecimal.valueOf(value, this.scale);
            this.parent.build(builder -> builder.appendDecimal(decimal));
        }
    }

    static class VariantBinaryConverter
    extends ShreddedScalarConverter {
        VariantBinaryConverter(ParentConverter<VariantBuilder> parent) {
            super(parent);
        }

        public void addBinary(Binary value) {
            this.parent.build(builder -> builder.appendBinary(value.toByteBuffer()));
        }
    }

    static class VariantStringConverter
    extends ShreddedScalarConverter {
        VariantStringConverter(ParentConverter<VariantBuilder> parent) {
            super(parent);
        }

        public void addBinary(Binary value) {
            this.parent.build(builder -> builder.appendString(value.toStringUsingUTF8()));
        }
    }

    static class ShreddedScalarConverter
    extends PrimitiveConverter {
        protected ParentConverter<VariantBuilder> parent;

        ShreddedScalarConverter(ParentConverter<VariantBuilder> parent) {
            this.parent = parent;
        }
    }

    static class ShreddedArrayRepeatedConverter
    extends GroupConverter {
        private final GroupConverter elementConverter;
        private final ParentConverter<VariantArrayBuilder> parent;
        private Long numValues = null;

        public ShreddedArrayRepeatedConverter(GroupType repeated, ParentConverter<VariantArrayBuilder> parent) {
            Type element = repeated.getType(0);
            Preconditions.checkArgument((!element.isPrimitive() ? 1 : 0) != 0, (String)("Invalid element type in variant array: " + element));
            ParentConverter<VariantBuilder> newParent = consumer -> parent.build(consumer::accept);
            this.elementConverter = VariantConverters.newValueConverter(element.asGroupType(), newParent);
            this.parent = parent;
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex > 1) {
                throw new ArrayIndexOutOfBoundsException(fieldIndex);
            }
            return this.elementConverter;
        }

        public void start() {
            this.parent.build(builder -> {
                this.numValues = builder.numValues();
            });
        }

        public void end() {
            this.parent.build(builder -> {
                long valuesWritten = builder.numValues() - this.numValues;
                if (valuesWritten > 1L) {
                    throw new IllegalStateException("Invalid variant, conflicting value and typed_value");
                }
                if (valuesWritten == 0L) {
                    builder.appendNull();
                }
            });
        }
    }

    static class ShreddedArrayConverter
    extends GroupConverter {
        private final ParentConverter<? extends VariantBuilder> parent;
        private final ShreddedArrayRepeatedConverter repeatedConverter;
        private VariantArrayBuilder arrayBuilder;

        public ShreddedArrayConverter(GroupType list, ParentConverter<? extends VariantBuilder> parent) {
            Preconditions.checkArgument((list.getFieldCount() == 1 ? 1 : 0) != 0, (String)("Invalid list type: " + list));
            this.parent = parent;
            Type repeated = list.getType(0);
            Preconditions.checkArgument((repeated.isRepetition(Type.Repetition.REPEATED) && !repeated.isPrimitive() && repeated.asGroupType().getFieldCount() == 1 ? 1 : 0) != 0, (String)("Invalid repeated type in list: " + repeated));
            this.repeatedConverter = new ShreddedArrayRepeatedConverter(repeated.asGroupType(), consumer -> consumer.accept(this.arrayBuilder));
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex > 1) {
                throw new ArrayIndexOutOfBoundsException(fieldIndex);
            }
            return this.repeatedConverter;
        }

        public void start() {
            try {
                this.parent.build(builder -> {
                    this.arrayBuilder = builder.startArray();
                });
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Invalid variant, conflicting value and typed_value", e);
            }
        }

        public void end() {
            this.parent.build(VariantBuilder::endArray);
            this.arrayBuilder = null;
        }
    }

    static class PartiallyShreddedFieldsConverter
    extends GroupConverter {
        private final Converter[] converters;
        private final ParentConverter<VariantBuilder> parent;
        private final Set<String> shreddedFieldNames = new HashSet<String>();
        private VariantObjectBuilder objectBuilder = null;

        PartiallyShreddedFieldsConverter(GroupType fieldsType, ParentConverter<VariantBuilder> parent) {
            this.converters = new Converter[fieldsType.getFieldCount()];
            this.parent = parent;
            for (int index = 0; index < fieldsType.getFieldCount(); ++index) {
                Type field = fieldsType.getType(index);
                Preconditions.checkArgument((!field.isPrimitive() ? 1 : 0) != 0, (String)("Invalid field group: " + field));
                String name = field.getName();
                this.shreddedFieldNames.add(name);
                ParentConverter<VariantObjectBuilder> newParent = converter -> converter.accept(this.objectBuilder);
                this.converters[index] = new FieldValueConverter(name, field.asGroupType(), newParent);
            }
        }

        private Set<String> shreddedFieldNames() {
            return this.shreddedFieldNames;
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters[fieldIndex];
        }

        public void start() {
            try {
                this.parent.build(builder -> {
                    this.objectBuilder = builder.startOrContinueObject();
                });
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Invalid variant, conflicting value and typed_value", e);
            }
        }

        public void end() {
            this.objectBuilder = null;
        }

        private static class FieldValueConverter
        extends GroupConverter {
            private final String fieldName;
            private final GroupConverter converter;
            private final ParentConverter<VariantObjectBuilder> parent;
            private Long numFields = null;

            FieldValueConverter(String fieldName, GroupType field, ParentConverter<VariantObjectBuilder> parent) {
                this.fieldName = fieldName;
                this.converter = VariantConverters.newValueConverter(field.asGroupType(), consumer -> parent.build(consumer::accept));
                this.parent = parent;
            }

            public Converter getConverter(int fieldIndex) {
                return this.converter.getConverter(fieldIndex);
            }

            public void start() {
                this.converter.start();
                this.parent.build(builder -> {
                    this.numFields = builder.numValues;
                    builder.appendKey(this.fieldName);
                });
            }

            public void end() {
                this.parent.build(builder -> {
                    if (builder.numValues == this.numFields) {
                        builder.dropLastKey();
                    }
                });
                this.numFields = null;
                this.converter.end();
            }
        }
    }

    static class PartiallyShreddedValueConverter
    extends BinaryConverter {
        private final ParentConverter<VariantBuilder> parent;
        private final Set<String> suppressedKeys;

        public PartiallyShreddedValueConverter(ParentConverter<VariantBuilder> parent, Set<String> suppressedKeys) {
            this.parent = parent;
            this.suppressedKeys = suppressedKeys;
        }

        @Override
        protected void handleBinary(Binary value) {
            this.parent.build(builder -> {
                ByteBuffer buffer = value.toByteBuffer();
                if (VariantUtil.getType(buffer) == Variant.Type.OBJECT) {
                    builder.startOrContinuePartialObject(value.toByteBuffer(), this.suppressedKeys);
                } else {
                    builder.appendEncodedValue(buffer);
                }
            });
        }
    }

    static class ShreddedObjectConverter
    extends ValueConverter {
        private final ParentConverter<VariantBuilder> parent;

        ShreddedObjectConverter(GroupType group, ParentConverter<VariantBuilder> parent) {
            super(group);
            this.parent = parent;
            int typedValueIndex = group.getFieldIndex("typed_value");
            Type typedField = group.getType(typedValueIndex);
            Preconditions.checkArgument((boolean)VariantConverters.isShreddedObject(typedField), (String)("Invalid typed_value for shredded object: " + typedField));
            PartiallyShreddedFieldsConverter fieldsConverter = new PartiallyShreddedFieldsConverter(typedField.asGroupType(), parent);
            this.setConverter(typedValueIndex, (Converter)fieldsConverter);
            if (group.containsField("value")) {
                int valueIndex = group.getFieldIndex("value");
                Type valueField = group.getType(valueIndex);
                Preconditions.checkArgument((boolean)VariantConverters.isBinary(valueField), (String)("Invalid variant value type: " + valueField));
                this.setConverter(valueIndex, (Converter)new PartiallyShreddedValueConverter(parent, fieldsConverter.shreddedFieldNames()));
            }
        }

        @Override
        public void end() {
            this.parent.build(VariantBuilder::endObjectIfExists);
        }
    }

    static class ShreddedValueConverter
    extends ValueConverter {
        ShreddedValueConverter(GroupType group, ParentConverter<VariantBuilder> parent) {
            super(group);
            if (group.containsField("typed_value")) {
                int typedValueIndex = group.getFieldIndex("typed_value");
                Type valueField = group.getType(typedValueIndex);
                if (valueField.isPrimitive()) {
                    this.setConverter(typedValueIndex, VariantConverters.newScalarConverter(valueField.asPrimitiveType(), parent));
                } else if (VariantConverters.isShreddedArray(valueField)) {
                    this.setConverter(typedValueIndex, (Converter)new ShreddedArrayConverter(valueField.asGroupType(), parent));
                }
            }
            if (group.containsField("value")) {
                int valueIndex = group.getFieldIndex("value");
                Type typedField = group.getType(valueIndex);
                Preconditions.checkArgument((typedField.isPrimitive() && typedField.asPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY ? 1 : 0) != 0, (String)("Invalid variant value type: " + typedField));
                this.setConverter(valueIndex, (Converter)new VariantValueConverter(parent));
            }
        }
    }

    static class ValueConverter
    extends GroupConverter {
        private final Converter[] converters;

        ValueConverter(GroupType group) {
            this.converters = new Converter[group.getFieldCount()];
        }

        protected void setConverter(int index, Converter converter) {
            this.converters[index] = converter;
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters[fieldIndex];
        }

        public void start() {
        }

        public void end() {
        }
    }

    static class VariantValueConverter
    extends BinaryConverter {
        private final ParentConverter<VariantBuilder> parent;

        public VariantValueConverter(ParentConverter<VariantBuilder> parent) {
            this.parent = parent;
        }

        @Override
        protected void handleBinary(Binary value) {
            this.parent.build(builder -> builder.appendEncodedValue(value.toByteBuffer()));
        }
    }

    static class VariantMetadataConverter
    extends BinaryConverter {
        private final Consumer<ByteBuffer> handleMetadata;

        public VariantMetadataConverter(Consumer<ByteBuffer> handleMetadata) {
            this.handleMetadata = handleMetadata;
        }

        @Override
        protected void handleBinary(Binary value) {
            this.handleMetadata.accept(value.toByteBuffer());
        }
    }

    public static interface ParentConverter<T extends VariantBuilder> {
        public void build(Consumer<T> var1);
    }
}

