/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.servlet;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.web.context.WebContextsService;
import org.apache.webbeans.web.util.ServletCompatibilityUtil;

public class WebBeansConfigurationListener
implements ServletContextListener,
ServletRequestListener,
HttpSessionListener {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebBeansConfigurationListener.class);
    protected ContainerLifecycle lifeCycle = null;
    protected FailOverService failoverService = null;
    private WebBeansContext webBeansContext = WebBeansContext.getInstance();

    public WebBeansConfigurationListener() {
        this.failoverService = (FailOverService)this.webBeansContext.getService(FailOverService.class);
    }

    public void contextInitialized(ServletContextEvent event) {
        this.lifeCycle = (ContainerLifecycle)this.webBeansContext.getService(ContainerLifecycle.class);
        try {
            this.lifeCycle.startApplication((Object)event);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0018", (Object[])new Object[]{ServletCompatibilityUtil.getServletInfo(event.getServletContext())}));
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.lifeCycle.stopApplication((Object)event);
        this.lifeCycle = null;
        this.cleanupRequestThreadLocals();
    }

    public void requestDestroyed(ServletRequestEvent event) {
        ELContextStore elStore;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Destroying a request : [{0}]", event == null ? "null" : event.getServletRequest().getRemoteAddr());
        }
        if ((elStore = ELContextStore.getInstance((boolean)false)) != null) {
            elStore.destroyELContextStore();
        }
        this.lifeCycle.getContextService().endContext(RequestScoped.class, (Object)event);
        this.cleanupRequestThreadLocals();
    }

    private void cleanupRequestThreadLocals() {
        WebContextsService.removeThreadLocals();
    }

    public void requestInitialized(ServletRequestEvent event) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Starting a new request : [{0}]", event == null ? "null" : event.getServletRequest().getRemoteAddr());
            }
            this.lifeCycle.getContextService().startContext(RequestScoped.class, (Object)event);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0019", (Object[])new Object[]{event == null ? "null" : event.getServletRequest()}));
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Starting a session with session id : [{0}]", event.getSession().getId());
            }
            this.lifeCycle.getContextService().startContext(SessionScoped.class, (Object)event.getSession());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0020", (Object[])new Object[]{event.getSession()}));
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Destroying a session with session id : [{0}]", event.getSession().getId());
        }
        boolean mustDestroy = this.ensureRequestScope();
        this.lifeCycle.getContextService().endContext(SessionScoped.class, (Object)event.getSession());
        this.lifeCycle.getContextService().endContext(ConversationScoped.class, (Object)event.getSession());
        if (mustDestroy) {
            this.requestDestroyed(null);
        }
    }

    private boolean ensureRequestScope() {
        if (!this.lifeCycle.getContextService().getCurrentContext(RequestScoped.class).isActive()) {
            this.requestInitialized(null);
            return true;
        }
        return false;
    }
}

