/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Provider;
import org.apache.webbeans.config.BeanTypeSetResolver;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPERS_MAP = new HashMap();
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(ClassUtil.class);
    private static volatile Set<String> objectMethodNames;

    private ClassUtil() {
        throw new UnsupportedOperationException();
    }

    public static Object newInstance(WebBeansContext webBeansContext, Class<?> clazz) {
        try {
            if (System.getSecurityManager() != null) {
                return webBeansContext.getSecurityService().doPrivilegedObjectCreate(clazz);
            }
            return clazz.newInstance();
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e instanceof PrivilegedActionException) {
                cause = e.getCause();
            }
            String error = "Error occurred while creating an instance of class : " + clazz.getName();
            logger.error(error, cause);
            throw new WebBeansException(error, cause);
        }
    }

    public static Class<?> getClassFromName(String name) {
        Class<?> clazz = null;
        ClassLoader loader = null;
        try {
            loader = WebBeansUtil.getCurrentClassLoader();
            clazz = Class.forName(name, true, loader);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            try {
                loader = ClassUtil.class.getClassLoader();
                clazz = Class.forName(name, true, loader);
                return clazz;
            }
            catch (ClassNotFoundException e1) {
                try {
                    loader = ClassLoader.getSystemClassLoader();
                    clazz = Class.forName(name, true, loader);
                    return clazz;
                }
                catch (ClassNotFoundException e2) {
                    return null;
                }
            }
        }
    }

    public static boolean isFinal(Integer modifier) {
        Asserts.nullCheckForModifier(modifier);
        return Modifier.isFinal(modifier);
    }

    public static boolean isAbstract(Integer modifier) {
        Asserts.nullCheckForModifier(modifier);
        return Modifier.isAbstract(modifier);
    }

    public static boolean isInterface(Integer modifier) {
        Asserts.nullCheckForModifier(modifier);
        return Modifier.isInterface(modifier);
    }

    public static boolean hasFinalMethod(Class<?> clazz) {
        Method[] methods;
        Asserts.nullCheckForClass(clazz);
        for (Method m : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz)) {
            if (!ClassUtil.isFinal(m.getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static boolean isInnerClazz(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        return clazz.isMemberClass();
    }

    public static Class<?> getPrimitiveWrapper(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        return PRIMITIVE_TO_WRAPPERS_MAP.get(clazz);
    }

    public static Class<?> getClass(Type type) {
        return ClassUtil.getClazz(type);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        return SecurityUtil.doPrivilegedGetDeclaredMethods(clazz);
    }

    public static boolean isMethodHasParameter(Method method) {
        Asserts.nullCheckForMethod(method);
        return method.getParameterTypes().length > 0;
    }

    public static Class<?> getReturnType(Method method) {
        Asserts.nullCheckForMethod(method);
        return method.getReturnType();
    }

    public static boolean isMethodHasCheckedException(Method method) {
        Asserts.nullCheckForMethod(method);
        Class<?>[] et = method.getExceptionTypes();
        if (et.length > 0) {
            for (Class<?> type : et) {
                if (Error.class.isAssignableFrom(type) || RuntimeException.class.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object callInstanceMethod(Method method, Object instance, Object[] args) {
        Asserts.nullCheckForMethod(method);
        Asserts.assertNotNull(instance, "instance parameter can not be null");
        try {
            if (args == null) {
                args = new Object[]{};
            }
            return method.invoke(instance, args);
        }
        catch (Exception e) {
            throw new WebBeansException("Exception occurs in the method call with method : " + method.getName() + " in class : " + instance.getClass().getName(), e);
        }
    }

    public static List<Class<?>> getSuperClasses(Class<?> clazz, List<Class<?>> list) {
        Asserts.nullCheckForClass(clazz);
        Class<?> sc = clazz.getSuperclass();
        if (sc != null) {
            list.add(sc);
            ClassUtil.getSuperClasses(sc, list);
        }
        return list;
    }

    public static Class<?>[] getMethodParameterTypes(Method method) {
        Asserts.nullCheckForMethod(method);
        return method.getParameterTypes();
    }

    private static Set<String> getObjectMethodNames() {
        if (objectMethodNames == null) {
            Method[] methods;
            HashSet<String> list = new HashSet<String>();
            Class<Object> clazz = Object.class;
            for (Method method : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz)) {
                list.add(method.getName());
            }
            objectMethodNames = list;
        }
        return objectMethodNames;
    }

    public static boolean isObjectMethod(String methodName) {
        return ClassUtil.getObjectMethodNames().contains(methodName);
    }

    public static boolean isMoreThanOneMethodWithName(String methodName, Class<?> clazz) {
        Asserts.assertNotNull(methodName, "methodName parameter can not be null");
        Asserts.nullCheckForClass(clazz);
        Method[] methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz);
        int methodCount = 0;
        for (Method m : methods) {
            if (!m.getName().equals(methodName)) continue;
            ++methodCount;
        }
        return methodCount > 1;
    }

    public Package getPackage(String packageName) {
        Asserts.assertNotNull(packageName, "packageName parameter can not be null");
        return Package.getPackage(packageName);
    }

    public static boolean isParametrizedType(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        return type instanceof ParameterizedType;
    }

    public static boolean isWildCardType(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        return type instanceof WildcardType;
    }

    public static boolean isUnboundedTypeVariable(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        if (type instanceof TypeVariable) {
            TypeVariable wc = (TypeVariable)type;
            Type[] upper = wc.getBounds();
            if (upper.length > 1) {
                return false;
            }
            Type arg = upper[0];
            if (!(arg instanceof Class)) {
                return false;
            }
            Class clazz = (Class)arg;
            return clazz.equals(Object.class);
        }
        return false;
    }

    public static boolean isTypeVariable(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        return type instanceof TypeVariable;
    }

    public static boolean isConcrete(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        Integer modifier = clazz.getModifiers();
        return !ClassUtil.isAbstract(modifier) && !ClassUtil.isInterface(modifier);
    }

    public static boolean isAssignable(Type beanType, Type requiredType) {
        Asserts.assertNotNull(beanType, "beanType parameter can not be null");
        Asserts.assertNotNull(requiredType, "requiredType parameter can not be null");
        if (beanType instanceof ParameterizedType && requiredType instanceof ParameterizedType) {
            return ClassUtil.isAssignableForParametrized((ParameterizedType)beanType, (ParameterizedType)requiredType);
        }
        if (beanType instanceof Class && requiredType instanceof Class) {
            Class<?> clzBeanType = (Class<?>)beanType;
            Class<?> clzReqType = (Class<?>)requiredType;
            if (clzBeanType.isPrimitive()) {
                clzBeanType = ClassUtil.getPrimitiveWrapper(clzBeanType);
            }
            if (clzReqType.isPrimitive()) {
                clzReqType = ClassUtil.getPrimitiveWrapper(clzReqType);
            }
            return clzReqType.equals(clzBeanType);
        }
        if (beanType instanceof ParameterizedType && requiredType instanceof Class) {
            boolean ok = true;
            Class clazzReqType = (Class)requiredType;
            ParameterizedType ptBean = (ParameterizedType)beanType;
            Class clazzBeanType = (Class)ptBean.getRawType();
            if (ClassUtil.isClassAssignable(clazzReqType, clazzBeanType)) {
                Type[] beanTypeArgs;
                for (Type actual : beanTypeArgs = ptBean.getActualTypeArguments()) {
                    if (ClassUtil.isUnboundedTypeVariable(actual)) continue;
                    if (actual instanceof Class) {
                        Class clazz = (Class)actual;
                        if (clazz.equals(Object.class)) continue;
                        ok = false;
                    } else {
                        ok = false;
                    }
                    break;
                }
            } else {
                ok = false;
            }
            return ok;
        }
        if (beanType instanceof Class && requiredType instanceof ParameterizedType) {
            Class clazzBeanType = (Class)beanType;
            ParameterizedType ptReq = (ParameterizedType)requiredType;
            Class clazzReqType = (Class)ptReq.getRawType();
            return (Provider.class.isAssignableFrom(clazzReqType) || Event.class.isAssignableFrom(clazzReqType)) && ClassUtil.isClassAssignable(clazzReqType, clazzBeanType);
        }
        return false;
    }

    public static boolean checkEventTypeAssignability(Type eventType, Type observerType) {
        if (ClassUtil.isTypeVariable(observerType)) {
            Class clazzTvBound;
            Class<?> eventClass = ClassUtil.getClass(eventType);
            TypeVariable tvBeanTypeArg = (TypeVariable)observerType;
            Type tvBound = tvBeanTypeArg.getBounds()[0];
            if (tvBound instanceof Class && (clazzTvBound = (Class)tvBound).isAssignableFrom(eventClass)) {
                return true;
            }
        } else {
            if (observerType instanceof ParameterizedType && eventType instanceof ParameterizedType) {
                return ClassUtil.isAssignableForParametrized((ParameterizedType)eventType, (ParameterizedType)observerType);
            }
            if (observerType instanceof Class && eventType instanceof ParameterizedType) {
                Class clazzBeanType = (Class)observerType;
                ParameterizedType ptEvent = (ParameterizedType)eventType;
                Class eventClazz = (Class)ptEvent.getRawType();
                return ClassUtil.isClassAssignable(clazzBeanType, eventClazz);
            }
            if (observerType instanceof Class && eventType instanceof Class) {
                return ClassUtil.isClassAssignable((Class)observerType, (Class)eventType);
            }
        }
        return false;
    }

    public static boolean isClassAssignable(Class<?> lhs, Class<?> rhs) {
        Asserts.assertNotNull(lhs, "lhs parameter can not be null");
        Asserts.assertNotNull(rhs, "rhs parameter can not be null");
        if (lhs.isPrimitive()) {
            lhs = ClassUtil.getPrimitiveWrapper(lhs);
        }
        if (rhs.isPrimitive()) {
            rhs = ClassUtil.getPrimitiveWrapper(rhs);
        }
        return lhs.isAssignableFrom(rhs);
    }

    public static boolean isAssignableForParametrized(ParameterizedType beanType, ParameterizedType requiredType) {
        Class beanRawType = (Class)beanType.getRawType();
        Class requiredRawType = (Class)requiredType.getRawType();
        if (ClassUtil.isClassAssignable(requiredRawType, beanRawType)) {
            Type[] requiredTypeArgs;
            Type[] beanTypeArgs = beanType.getActualTypeArguments();
            if (beanTypeArgs.length != (requiredTypeArgs = requiredType.getActualTypeArguments()).length) {
                return false;
            }
            return ClassUtil.isAssignableForParametrizedCheckArguments(beanTypeArgs, requiredTypeArgs);
        }
        return false;
    }

    private static boolean isAssignableForParametrizedCheckArguments(Type[] beanTypeArgs, Type[] requiredTypeArgs) {
        Type requiredTypeArg = null;
        Type beanTypeArg = null;
        for (int i = 0; i < requiredTypeArgs.length; ++i) {
            requiredTypeArg = requiredTypeArgs[i];
            beanTypeArg = beanTypeArgs[i];
            if (ClassUtil.isParametrizedType(requiredTypeArg) && ClassUtil.isParametrizedType(beanTypeArg)) {
                return ClassUtil.checkBeanAndRequiredTypeIsParametrized(beanTypeArg, requiredTypeArg);
            }
            if (ClassUtil.isWildCardType(requiredTypeArg)) {
                return ClassUtil.checkRequiredTypeIsWildCard(beanTypeArg, requiredTypeArg);
            }
            if (requiredTypeArg instanceof Class && ClassUtil.isTypeVariable(beanTypeArg)) {
                return ClassUtil.checkRequiredTypeIsClassAndBeanTypeIsVariable(beanTypeArg, requiredTypeArg);
            }
            if (ClassUtil.isTypeVariable(requiredTypeArg) && ClassUtil.isTypeVariable(beanTypeArg)) {
                return ClassUtil.checkBeanTypeAndRequiredIsTypeVariable(beanTypeArg, requiredTypeArg);
            }
            if (beanTypeArg instanceof Class && requiredTypeArg instanceof Class) {
                if (!ClassUtil.isClassAssignable((Class)requiredTypeArg, (Class)beanTypeArg)) continue;
                return true;
            }
            if (!(beanTypeArg instanceof Class) || !ClassUtil.isTypeVariable(requiredTypeArg)) continue;
            return ClassUtil.checkRequiredTypeIsTypeVariableAndBeanTypeIsClass(beanTypeArg, requiredTypeArg);
        }
        return false;
    }

    @Deprecated
    public static boolean checkBeanAndRequiredTypeisParametrized(Type beanTypeArg, Type requiredTypeArg) {
        return ClassUtil.checkBeanAndRequiredTypeIsParametrized(beanTypeArg, requiredTypeArg);
    }

    public static boolean checkBeanAndRequiredTypeIsParametrized(Type beanTypeArg, Type requiredTypeArg) {
        ParameterizedType ptRequiredTypeArg = (ParameterizedType)requiredTypeArg;
        ParameterizedType ptBeanTypeArg = (ParameterizedType)beanTypeArg;
        if (ptRequiredTypeArg.getRawType().equals(ptBeanTypeArg.getRawType())) {
            Type[] actualArgsRequiredType = ptRequiredTypeArg.getActualTypeArguments();
            Type[] actualArgsBeanType = ptRequiredTypeArg.getActualTypeArguments();
            if (actualArgsRequiredType.length > 0 && actualArgsBeanType.length == actualArgsRequiredType.length) {
                return ClassUtil.isAssignableForParametrizedCheckArguments(actualArgsBeanType, actualArgsRequiredType);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean checkRequiredTypeisWildCard(Type beanTypeArg, Type requiredTypeArg) {
        return ClassUtil.checkRequiredTypeIsWildCard(beanTypeArg, requiredTypeArg);
    }

    public static boolean checkRequiredTypeIsWildCard(Type beanTypeArg, Type requiredTypeArg) {
        TypeVariable tvBeanTypeArg;
        Type tvBound;
        WildcardType wctRequiredTypeArg = (WildcardType)requiredTypeArg;
        Type upperBoundRequiredTypeArg = wctRequiredTypeArg.getUpperBounds()[0];
        Type[] lowerBoundRequiredTypeArgs = wctRequiredTypeArg.getLowerBounds();
        if (beanTypeArg instanceof Class) {
            Class clazzBeanTypeArg = (Class)beanTypeArg;
            if (upperBoundRequiredTypeArg instanceof Class) {
                Class clazzLowerBoundTypeArg;
                Class clazzUpperBoundTypeArg = (Class)upperBoundRequiredTypeArg;
                if (clazzUpperBoundTypeArg != Object.class && !clazzUpperBoundTypeArg.isAssignableFrom(clazzBeanTypeArg)) {
                    return false;
                }
                if (lowerBoundRequiredTypeArgs.length > 0 && lowerBoundRequiredTypeArgs[0] instanceof Class && (clazzLowerBoundTypeArg = (Class)lowerBoundRequiredTypeArgs[0]) != Object.class && !clazzBeanTypeArg.isAssignableFrom(clazzLowerBoundTypeArg)) {
                    return false;
                }
            }
        } else if (ClassUtil.isTypeVariable(beanTypeArg) && (tvBound = (tvBeanTypeArg = (TypeVariable)beanTypeArg).getBounds()[0]) instanceof Class) {
            Class clazzTvBound = (Class)tvBound;
            if (upperBoundRequiredTypeArg instanceof Class) {
                Class clazzLowerBoundTypeArg;
                Class clazzUpperBoundTypeArg = (Class)upperBoundRequiredTypeArg;
                if (clazzUpperBoundTypeArg != Object.class && clazzTvBound != Object.class && !clazzUpperBoundTypeArg.isAssignableFrom(clazzTvBound)) {
                    return false;
                }
                if (lowerBoundRequiredTypeArgs.length > 0 && lowerBoundRequiredTypeArgs[0] instanceof Class && (clazzLowerBoundTypeArg = (Class)lowerBoundRequiredTypeArgs[0]) != Object.class && !clazzTvBound.isAssignableFrom(clazzLowerBoundTypeArg)) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean checkRequiredTypeIsClassAndBeanTypeIsVariable(Type beanTypeArg, Type requiredTypeArg) {
        Class clazzTvBound;
        Class clazzRequiredType = (Class)requiredTypeArg;
        TypeVariable tvBeanTypeArg = (TypeVariable)beanTypeArg;
        Type tvBound = tvBeanTypeArg.getBounds()[0];
        return !(tvBound instanceof Class) || (clazzTvBound = (Class)tvBound) == Object.class || clazzTvBound.isAssignableFrom(clazzRequiredType);
    }

    public static boolean checkRequiredTypeIsTypeVariableAndBeanTypeIsClass(Type beanTypeArg, Type requiredTypeArg) {
        Class clazzTvBound;
        Class clazzBeanType = (Class)beanTypeArg;
        TypeVariable tvRequiredTypeArg = (TypeVariable)requiredTypeArg;
        Type tvBound = tvRequiredTypeArg.getBounds()[0];
        return tvBound instanceof Class && (clazzTvBound = (Class)tvBound).isAssignableFrom(clazzBeanType);
    }

    public static boolean checkBeanTypeAndRequiredIsTypeVariable(Type beanTypeArg, Type requiredTypeArg) {
        Class clazzTvRequiredBound;
        Class clazzTvBeanBound;
        TypeVariable tvBeanTypeArg = (TypeVariable)beanTypeArg;
        Type tvBeanBound = tvBeanTypeArg.getBounds()[0];
        TypeVariable tvRequiredTypeArg = (TypeVariable)requiredTypeArg;
        Type tvRequiredBound = tvRequiredTypeArg.getBounds()[0];
        return tvBeanBound instanceof Class && tvRequiredBound instanceof Class && (clazzTvBeanBound = (Class)tvBeanBound).isAssignableFrom(clazzTvRequiredBound = (Class)tvRequiredBound);
    }

    public static List<Method> getClassMethodsWithTypes(Class<?> clazz, String methodName, List<Class<?>> parameterTypes) {
        Asserts.nullCheckForClass(clazz);
        Asserts.assertNotNull(methodName, "methodName parameter can not be null");
        Asserts.assertNotNull(parameterTypes, "parameterTypes parameter can not be null");
        ArrayList<Method> methodList = new ArrayList<Method>();
        Method[] methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz);
        int j = 0;
        for (Method method : methods) {
            Class<?>[] defineTypes;
            if (!method.getName().equals(methodName) || (defineTypes = method.getParameterTypes()).length != parameterTypes.size()) continue;
            boolean ok = true;
            if (parameterTypes.size() > 0) {
                ok = false;
            }
            if (!ok) {
                for (Class<?> defineType : defineTypes) {
                    ok = defineType.isAssignableFrom(parameterTypes.get(j));
                    ++j;
                }
            }
            if (!ok) continue;
            methodList.add(method);
        }
        return methodList;
    }

    public static Method getClassMethodWithTypes(Class<?> clazz, String methodName, List<Class<?>> parameterTypes) {
        Asserts.nullCheckForClass(clazz);
        Asserts.assertNotNull(methodName, "methodName parameter can not be null");
        Asserts.assertNotNull(parameterTypes, "parameterTypes parameter can not be null");
        Method[] methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz);
        int j = 0;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            if (parameterTypes != null && parameterTypes.size() > 0) {
                Class<?>[] defineTypes = method.getParameterTypes();
                if (defineTypes.length != parameterTypes.size()) continue;
                boolean ok = false;
                for (Class<?> defineType : defineTypes) {
                    ok = defineType.equals(parameterTypes.get(j));
                }
                if (!ok) continue;
                return method;
            }
            return method;
        }
        return null;
    }

    public static boolean isArray(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        return clazz.isArray();
    }

    @Deprecated
    public static boolean isDefinitionConstainsTypeVariables(Class<?> clazz) {
        return ClassUtil.isDefinitionContainsTypeVariables(clazz);
    }

    public static boolean isDefinitionContainsTypeVariables(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        return clazz.getTypeParameters().length > 0;
    }

    @Deprecated
    public static Type[] getActualTypeArguements(Type type) {
        return ClassUtil.getActualTypeArguments(type);
    }

    public static Type[] getActualTypeArguments(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return new Type[0];
    }

    public static Set<Type> setTypeHierarchy(Set<Type> set, Type clazz) {
        BeanTypeSetResolver resolver = new BeanTypeSetResolver(clazz);
        resolver.startConfiguration();
        set.addAll(resolver.getHierarchy());
        return set;
    }

    public static Class<?> getClazz(Type type) {
        Class<?> raw = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            raw = (Class)pt.getRawType();
        } else if (type instanceof Class) {
            raw = (Class<?>)type;
        } else if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            raw = ClassUtil.getClazz(arrayType.getGenericComponentType());
        }
        return raw;
    }

    public static Set<Type> setInterfaceTypeHierarchy(Set<Type> set, Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        do {
            Class<?>[] interfaces;
            for (Class<?> cl : interfaces = clazz.getInterfaces()) {
                set.add(cl);
                ClassUtil.setTypeHierarchy(set, cl);
            }
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        return set;
    }

    public static boolean checkParametrizedType(ParameterizedType pType) {
        Type[] types;
        Asserts.assertNotNull(pType, "pType argument can not be null");
        for (Type type : types = pType.getActualTypeArguments()) {
            if (type instanceof ParameterizedType) {
                return ClassUtil.checkParametrizedType((ParameterizedType)type);
            }
            if (!(type instanceof TypeVariable) && !(type instanceof WildcardType)) continue;
            return false;
        }
        return true;
    }

    public static Field[] getFieldsWithType(WebBeansContext webBeansContext, Class<?> clazz, Type type) {
        Field[] fields;
        Asserts.nullCheckForClass(clazz);
        Asserts.assertNotNull(type, "type parameter can not be null");
        ArrayList<Field> fieldsWithType = new ArrayList<Field>();
        for (Field field : fields = webBeansContext.getSecurityService().doPrivilegedGetDeclaredFields(clazz)) {
            if (!field.getType().equals(type)) continue;
            fieldsWithType.add(field);
        }
        return fieldsWithType.toArray(new Field[fieldsWithType.size()]);
    }

    public static Class<?> getRawTypeForInjectionPoint(InjectionPoint injectionPoint) {
        Class rawType = null;
        Type type = injectionPoint.getType();
        if (type instanceof Class) {
            rawType = (Class)type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            rawType = (Class)pt.getRawType();
        }
        return rawType;
    }

    @Deprecated
    public static boolean isOverriden(Method subClassMethod, Method superClassMethod) {
        return ClassUtil.isOverridden(subClassMethod, superClassMethod);
    }

    public static boolean isOverridden(Method subClassMethod, Method superClassMethod) {
        if (subClassMethod.getName().equals(superClassMethod.getName()) && Arrays.equals(subClassMethod.getParameterTypes(), superClassMethod.getParameterTypes())) {
            int modifiers = superClassMethod.getModifiers();
            if (Modifier.isPrivate(modifiers)) {
                return false;
            }
            if (!Modifier.isProtected(modifiers) && !Modifier.isPublic(modifiers)) {
                Class<?> superClass = superClassMethod.getDeclaringClass();
                Class<?> subClass = subClassMethod.getDeclaringClass();
                if (!subClass.getPackage().getName().equals(superClass.getPackage().getName())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    static {
        PRIMITIVE_TO_WRAPPERS_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Void.TYPE, Void.class);
        objectMethodNames = null;
    }
}

