/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.EventBean;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.event.EventUtil;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.impl.InjectionPointFactory;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserverMethodImpl<T>
implements ObserverMethod<T> {
    private final WebBeansLogger logger = WebBeansLogger.getLogger(ObserverMethodImpl.class);
    private final InjectionTargetBean<?> bean;
    private Method observerMethod;
    private final boolean ifExist;
    private final Set<Annotation> observedQualifiers;
    private final Type observedEventType;
    private final TransactionPhase phase;
    private AnnotatedMethod<T> annotatedMethod = null;

    public ObserverMethodImpl(InjectionTargetBean<?> bean, Method observerMethod, boolean ifExist) {
        this.bean = bean;
        this.observerMethod = observerMethod;
        this.ifExist = ifExist;
        Annotation[] qualifiers = this.getWebBeansContext().getAnnotationManager().getMethodFirstParameterQualifierWithGivenAnnotation(observerMethod, Observes.class);
        this.getWebBeansContext().getAnnotationManager().checkQualifierConditions(qualifiers);
        this.observedQualifiers = new HashSet<Annotation>(qualifiers.length);
        for (Annotation qualifier : qualifiers) {
            this.observedQualifiers.add(qualifier);
        }
        this.observedEventType = AnnotationUtil.getTypeOfParameterWithGivenAnnotation(observerMethod, Observes.class);
        this.phase = EventUtil.getObserverMethodTransactionType(observerMethod);
    }

    public ObserverMethodImpl(InjectionTargetBean<?> bean, Method observerMethod, boolean ifExist, Annotation[] qualifiers, Type observedEventType) {
        this.bean = bean;
        this.observerMethod = observerMethod;
        this.ifExist = ifExist;
        this.observedQualifiers = new HashSet<Annotation>(qualifiers.length);
        for (Annotation qualifier : qualifiers) {
            this.observedQualifiers.add(qualifier);
        }
        this.observedEventType = observedEventType;
        this.phase = EventUtil.getObserverMethodTransactionType(observerMethod);
    }

    public void setAnnotatedMethod(AnnotatedMethod<T> annotatedMethod) {
        this.annotatedMethod = annotatedMethod;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notify(T event) {
        this.logger.trace("Notifying with event payload : [{0}]", event);
        AbstractOwbBean component = (AbstractOwbBean)((Object)this.bean);
        if (!this.bean.isEnabled()) {
            return;
        }
        Object object = null;
        CreationalContext creationalContext = null;
        List<ObserverParams> methodArgsMap = this.annotatedMethod == null ? this.getMethodArguments(event) : this.getAnnotatedMethodArguments(event);
        ObserverParams[] obargs = null;
        try {
            block27: {
                try {
                    Context context;
                    boolean isPrivateMethod;
                    boolean bl = isPrivateMethod = !this.observerMethod.isAccessible();
                    if (isPrivateMethod) {
                        this.bean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.observerMethod, true);
                    }
                    obargs = new ObserverParams[methodArgsMap.size()];
                    obargs = methodArgsMap.toArray(obargs);
                    Object[] args = new Object[obargs.length];
                    int i = 0;
                    for (ObserverParams param : obargs) {
                        args[i++] = param.instance;
                    }
                    if (Modifier.isStatic(this.observerMethod.getModifiers())) {
                        this.observerMethod.invoke(object, args);
                        break block27;
                    }
                    BeanManagerImpl manager = this.bean.getWebBeansContext().getBeanManagerImpl();
                    try {
                        context = manager.getContext(component.getScope());
                    }
                    catch (ContextNotActiveException cnae) {
                        this.logger.info("INFO_0010", this.bean);
                        Object var15_18 = null;
                        if (component.getScope().equals(Dependent.class) && object != null) {
                            component.destroy(object, creationalContext);
                        }
                        if (methodArgsMap == null) return;
                        for (ObserverParams param : obargs) {
                            if (!param.isBean || !param.bean.getScope().equals(Dependent.class)) continue;
                            param.bean.destroy(param.instance, param.creational);
                        }
                        return;
                    }
                    object = context.get((Contextual)component);
                    if (this.ifExist && object == null) {
                        Object var15_19 = null;
                        if (component.getScope().equals(Dependent.class) && object != null) {
                            component.destroy(object, creationalContext);
                        }
                        if (methodArgsMap == null) return;
                        for (ObserverParams param : obargs) {
                            if (!param.isBean || !param.bean.getScope().equals(Dependent.class)) continue;
                            param.bean.destroy(param.instance, param.creational);
                        }
                        return;
                    }
                    creationalContext = manager.createCreationalContext(component);
                    if (isPrivateMethod) {
                        if (object == null) {
                            object = context.get((Contextual)component, creationalContext);
                        }
                    } else {
                        Type t = component.getBeanClass();
                        if (component.getWebBeansType() == WebBeansType.ENTERPRISE) {
                            t = (Type)component.getTypes().toArray()[0];
                        }
                        object = manager.getReference(component, t, creationalContext);
                    }
                    if (object == null) break block27;
                    this.observerMethod.invoke(object, args);
                }
                catch (Exception e) {
                    throw new WebBeansException(e);
                }
            }
            Object var15_20 = null;
            if (component.getScope().equals(Dependent.class) && object != null) {
                component.destroy(object, creationalContext);
            }
            if (methodArgsMap == null) return;
            for (ObserverParams param : obargs) {
                if (!param.isBean || !param.bean.getScope().equals(Dependent.class)) continue;
                param.bean.destroy(param.instance, param.creational);
            }
            return;
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            if (component.getScope().equals(Dependent.class) && object != null) {
                component.destroy(object, creationalContext);
            }
            if (methodArgsMap == null) throw throwable;
            for (ObserverParams param : obargs) {
                if (!param.isBean || !param.bean.getScope().equals(Dependent.class)) continue;
                param.bean.destroy(param.instance, param.creational);
            }
            throw throwable;
        }
    }

    protected List<ObserverParams> getMethodArguments(Object event) {
        WebBeansContext webBeansContext = this.bean.getWebBeansContext();
        AnnotatedElementFactory annotatedElementFactory = webBeansContext.getAnnotatedElementFactory();
        AnnotationManager annotationManager = webBeansContext.getAnnotationManager();
        AnnotatedType annotatedType = annotatedElementFactory.newAnnotatedType(this.bean.getReturnType());
        AnnotatedMethod annotatedMethod = annotatedElementFactory.newAnnotatedMethod(this.observerMethod, annotatedType);
        Type[] types = this.observerMethod.getGenericParameterTypes();
        Annotation[][] annots = this.observerMethod.getParameterAnnotations();
        ArrayList<ObserverParams> list = new ArrayList<ObserverParams>();
        BeanManagerImpl manager = webBeansContext.getBeanManagerImpl();
        ObserverParams param = null;
        if (types.length > 0) {
            int i = 0;
            for (Type type : types) {
                Annotation[] annot = annots[i];
                boolean observesAnnotation = false;
                if (annot.length == 0) {
                    annot = new Annotation[]{new DefaultLiteral()};
                } else {
                    for (Annotation observersAnnot : annot) {
                        if (!observersAnnot.annotationType().equals(Observes.class)) continue;
                        param = new ObserverParams();
                        param.instance = event;
                        list.add(param);
                        observesAnnotation = true;
                        break;
                    }
                }
                if (!observesAnnotation) {
                    boolean injectionPointBeanLocalSetOnStack = false;
                    Annotation[] bindingTypes = annotationManager.getQualifierAnnotations(annot);
                    AnnotatedParameter annotatedParameter = (AnnotatedParameter)annotatedMethod.getParameters().get(i);
                    InjectionPoint point = InjectionPointFactory.getPartialInjectionPoint(this.bean, type, this.observerMethod, (Annotated)annotatedParameter, bindingTypes);
                    Bean<?> injectedBean = this.getWebBeansContext().getBeanManagerImpl().getInjectionResolver().getInjectionPointBean(point);
                    if (WebBeansUtil.isDependent(injectedBean) && !InjectionPoint.class.isAssignableFrom(ClassUtil.getClass(point.getType()))) {
                        injectionPointBeanLocalSetOnStack = InjectionPointBean.setThreadLocal(point);
                    }
                    if (this.isEventProviderInjection(point)) {
                        EventBean.local.set(point);
                    }
                    CreationalContext<?> creational = manager.createCreationalContext(injectedBean);
                    Object instance = manager.getInstance(injectedBean, creational);
                    if (injectionPointBeanLocalSetOnStack) {
                        InjectionPointBean.unsetThreadLocal();
                    }
                    param = new ObserverParams();
                    param.isBean = true;
                    param.creational = creational;
                    param.instance = instance;
                    param.bean = injectedBean;
                    list.add(param);
                }
                ++i;
            }
        }
        return list;
    }

    protected List<ObserverParams> getAnnotatedMethodArguments(Object event) {
        WebBeansContext webBeansContext = this.bean.getWebBeansContext();
        AnnotationManager annotationManager = webBeansContext.getAnnotationManager();
        BeanManagerImpl manager = webBeansContext.getBeanManagerImpl();
        ArrayList<ObserverParams> list = new ArrayList<ObserverParams>();
        List parameters = this.annotatedMethod.getParameters();
        ObserverParams param = null;
        for (AnnotatedParameter parameter : parameters) {
            if (parameter.isAnnotationPresent(Observes.class)) {
                param = new ObserverParams();
                param.instance = event;
                list.add(param);
                continue;
            }
            boolean injectionPointBeanLocalSetOnStack = false;
            Annotation[] bindingTypes = annotationManager.getQualifierAnnotations(AnnotationUtil.getAnnotationsFromSet(parameter.getAnnotations()));
            InjectionPoint point = InjectionPointFactory.getPartialInjectionPoint(this.bean, parameter.getBaseType(), parameter.getDeclaringCallable().getJavaMember(), (Annotated)parameter, bindingTypes);
            Bean<?> injectedBean = this.getWebBeansContext().getBeanManagerImpl().getInjectionResolver().getInjectionPointBean(point);
            if (WebBeansUtil.isDependent(injectedBean) && !InjectionPoint.class.isAssignableFrom(ClassUtil.getClass(point.getType()))) {
                injectionPointBeanLocalSetOnStack = InjectionPointBean.setThreadLocal(point);
            }
            if (this.isEventProviderInjection(point)) {
                EventBean.local.set(point);
            }
            CreationalContext<?> creational = manager.createCreationalContext(injectedBean);
            Object instance = manager.getInstance(injectedBean, creational);
            if (injectionPointBeanLocalSetOnStack) {
                InjectionPointBean.unsetThreadLocal();
            }
            param = new ObserverParams();
            param.isBean = true;
            param.creational = creational;
            param.instance = instance;
            param.bean = injectedBean;
            list.add(param);
        }
        return list;
    }

    private boolean isEventProviderInjection(InjectionPoint injectionPoint) {
        ParameterizedType pt;
        Class clazz;
        Type type = injectionPoint.getType();
        return type instanceof ParameterizedType && (clazz = (Class)(pt = (ParameterizedType)type).getRawType()).isAssignableFrom(Event.class);
    }

    public Class<?> getBeanClass() {
        AbstractInjectionTargetBean abs = (AbstractInjectionTargetBean)this.bean;
        return abs.getBeanClass();
    }

    public Set<Annotation> getObservedQualifiers() {
        return this.observedQualifiers;
    }

    public Type getObservedType() {
        return this.observedEventType;
    }

    public Reception getReception() {
        return this.ifExist ? Reception.IF_EXISTS : Reception.ALWAYS;
    }

    public TransactionPhase getTransactionPhase() {
        return this.phase;
    }

    public Method getObserverMethod() {
        return this.observerMethod;
    }

    protected WebBeansContext getWebBeansContext() {
        return this.bean.getWebBeansContext();
    }

    public void setObserverMethod(Method m) {
        this.observerMethod = m;
    }

    private static class ObserverParams {
        private Bean<Object> bean;
        private Object instance;
        private CreationalContext<Object> creational;
        private boolean isBean = false;

        private ObserverParams() {
        }
    }
}

