/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import opennlp.tools.ml.maxent.GISModel;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.EvalParameters;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.MutableContext;
import opennlp.tools.ml.model.OnePassDataIndexer;
import opennlp.tools.ml.model.Prior;
import opennlp.tools.ml.model.UniformPrior;
import opennlp.tools.util.ObjectStream;

class GISTrainer {
    private boolean useSimpleSmoothing = false;
    private boolean useGaussianSmoothing = false;
    private double sigma = 2.0;
    private double _smoothingObservation = 0.1;
    private final boolean printMessages;
    private int numUniqueEvents;
    private int numPreds;
    private int numOutcomes;
    private int[][] contexts;
    private float[][] values;
    private int[] outcomeList;
    private int[] numTimesEventsSeen;
    private int[] predicateCounts;
    private int cutoff;
    private String[] outcomeLabels;
    private String[] predLabels;
    private MutableContext[] observedExpects;
    private MutableContext[] params;
    private MutableContext[][] modelExpects;
    private Prior prior;
    private static final double LLThreshold = 1.0E-4;
    private EvalParameters evalParams;

    GISTrainer() {
        this.printMessages = false;
    }

    GISTrainer(boolean printMessages) {
        this.printMessages = printMessages;
    }

    public void setSmoothing(boolean smooth) {
        this.useSimpleSmoothing = smooth;
    }

    public void setSmoothingObservation(double timesSeen) {
        this._smoothingObservation = timesSeen;
    }

    public void setGaussianSigma(double sigmaValue) {
        this.useGaussianSmoothing = true;
        this.sigma = sigmaValue;
    }

    public GISModel trainModel(ObjectStream<Event> eventStream, int iterations, int cutoff) throws IOException {
        return this.trainModel(iterations, new OnePassDataIndexer(eventStream, cutoff), cutoff);
    }

    public GISModel trainModel(int iterations, DataIndexer di, int cutoff) {
        return this.trainModel(iterations, di, new UniformPrior(), cutoff, 1);
    }

    public GISModel trainModel(int iterations, DataIndexer di, Prior modelPrior, int cutoff, int threads) {
        if (threads <= 0) {
            throw new IllegalArgumentException("threads must be at least one or greater but is " + threads + "!");
        }
        this.modelExpects = new MutableContext[threads][];
        this.display("Incorporating indexed data for training...  \n");
        this.contexts = di.getContexts();
        this.values = di.getValues();
        this.cutoff = cutoff;
        this.predicateCounts = di.getPredCounts();
        this.numTimesEventsSeen = di.getNumTimesEventsSeen();
        this.numUniqueEvents = this.contexts.length;
        this.prior = modelPrior;
        double correctionConstant = 0.0;
        for (int ci = 0; ci < this.contexts.length; ++ci) {
            if (this.values == null || this.values[ci] == null) {
                if (!((double)this.contexts[ci].length > correctionConstant)) continue;
                correctionConstant = this.contexts[ci].length;
                continue;
            }
            float cl = this.values[ci][0];
            for (int vi = 1; vi < this.values[ci].length; ++vi) {
                cl += this.values[ci][vi];
            }
            if (!((double)cl > correctionConstant)) continue;
            correctionConstant = cl;
        }
        this.display("done.\n");
        this.outcomeLabels = di.getOutcomeLabels();
        this.outcomeList = di.getOutcomeList();
        this.numOutcomes = this.outcomeLabels.length;
        this.predLabels = di.getPredLabels();
        this.prior.setLabels(this.outcomeLabels, this.predLabels);
        this.numPreds = this.predLabels.length;
        this.display("\tNumber of Event Tokens: " + this.numUniqueEvents + "\n");
        this.display("\t    Number of Outcomes: " + this.numOutcomes + "\n");
        this.display("\t  Number of Predicates: " + this.numPreds + "\n");
        float[][] predCount = new float[this.numPreds][this.numOutcomes];
        for (int ti = 0; ti < this.numUniqueEvents; ++ti) {
            for (int j = 0; j < this.contexts[ti].length; ++j) {
                if (this.values != null && this.values[ti] != null) {
                    float[] fArray = predCount[this.contexts[ti][j]];
                    int n = this.outcomeList[ti];
                    fArray[n] = fArray[n] + (float)this.numTimesEventsSeen[ti] * this.values[ti][j];
                    continue;
                }
                float[] fArray = predCount[this.contexts[ti][j]];
                int n = this.outcomeList[ti];
                fArray[n] = fArray[n] + (float)this.numTimesEventsSeen[ti];
            }
        }
        di = null;
        double smoothingObservation = this._smoothingObservation;
        this.params = new MutableContext[this.numPreds];
        for (int i = 0; i < this.modelExpects.length; ++i) {
            this.modelExpects[i] = new MutableContext[this.numPreds];
        }
        this.observedExpects = new MutableContext[this.numPreds];
        this.evalParams = new EvalParameters(this.params, 0.0, 1.0, this.numOutcomes);
        int[] activeOutcomes = new int[this.numOutcomes];
        int[] allOutcomesPattern = new int[this.numOutcomes];
        for (int oi = 0; oi < this.numOutcomes; ++oi) {
            allOutcomesPattern[oi] = oi;
        }
        for (int pi = 0; pi < this.numPreds; ++pi) {
            int[] outcomePattern;
            int numActiveOutcomes = 0;
            if (this.useSimpleSmoothing) {
                numActiveOutcomes = this.numOutcomes;
                outcomePattern = allOutcomesPattern;
            } else {
                for (int oi = 0; oi < this.numOutcomes; ++oi) {
                    if (!(predCount[pi][oi] > 0.0f) || this.predicateCounts[pi] < cutoff) continue;
                    activeOutcomes[numActiveOutcomes] = oi;
                    ++numActiveOutcomes;
                }
                if (numActiveOutcomes == this.numOutcomes) {
                    outcomePattern = allOutcomesPattern;
                } else {
                    outcomePattern = new int[numActiveOutcomes];
                    System.arraycopy(activeOutcomes, 0, outcomePattern, 0, numActiveOutcomes);
                }
            }
            this.params[pi] = new MutableContext(outcomePattern, new double[numActiveOutcomes]);
            for (int i = 0; i < this.modelExpects.length; ++i) {
                this.modelExpects[i][pi] = new MutableContext(outcomePattern, new double[numActiveOutcomes]);
            }
            this.observedExpects[pi] = new MutableContext(outcomePattern, new double[numActiveOutcomes]);
            for (int aoi = 0; aoi < numActiveOutcomes; ++aoi) {
                int oi = outcomePattern[aoi];
                this.params[pi].setParameter(aoi, 0.0);
                for (MutableContext[] modelExpect : this.modelExpects) {
                    modelExpect[pi].setParameter(aoi, 0.0);
                }
                if (predCount[pi][oi] > 0.0f) {
                    this.observedExpects[pi].setParameter(aoi, predCount[pi][oi]);
                    continue;
                }
                if (!this.useSimpleSmoothing) continue;
                this.observedExpects[pi].setParameter(aoi, smoothingObservation);
            }
        }
        predCount = null;
        this.display("...done.\n");
        if (threads == 1) {
            this.display("Computing model parameters ...\n");
        } else {
            this.display("Computing model parameters in " + threads + " threads...\n");
        }
        this.findParameters(iterations, correctionConstant);
        return new GISModel(this.params, this.predLabels, this.outcomeLabels, 1, this.evalParams.getCorrectionParam());
    }

    private void findParameters(int iterations, double correctionConstant) {
        int threads = this.modelExpects.length;
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        ExecutorCompletionService<ModelExpactationComputeTask> completionService = new ExecutorCompletionService<ModelExpactationComputeTask>(executor);
        double prevLL = 0.0;
        this.display("Performing " + iterations + " iterations.\n");
        for (int i = 1; i <= iterations; ++i) {
            if (i < 10) {
                this.display("  " + i + ":  ");
            } else if (i < 100) {
                this.display(" " + i + ":  ");
            } else {
                this.display(i + ":  ");
            }
            double currLL = this.nextIteration(correctionConstant, completionService);
            if (i > 1) {
                if (prevLL > currLL) {
                    System.err.println("Model Diverging: loglikelihood decreased");
                    break;
                }
                if (currLL - prevLL < 1.0E-4) break;
            }
            prevLL = currLL;
        }
        this.observedExpects = null;
        this.modelExpects = null;
        this.numTimesEventsSeen = null;
        this.contexts = null;
        executor.shutdown();
    }

    private double gaussianUpdate(int predicate, int oid, int n, double correctionConstant) {
        double param = this.params[predicate].getParameters()[oid];
        double x0 = 0.0;
        double modelValue = this.modelExpects[0][predicate].getParameters()[oid];
        double observedValue = this.observedExpects[predicate].getParameters()[oid];
        for (int i = 0; i < 50; ++i) {
            double tmp = modelValue * Math.exp(correctionConstant * x0);
            double f = tmp + (param + x0) / this.sigma - observedValue;
            double fp = tmp * correctionConstant + 1.0 / this.sigma;
            if (fp == 0.0) break;
            double x = x0 - f / fp;
            if (Math.abs(x - x0) < 1.0E-6) {
                x0 = x;
                break;
            }
            x0 = x;
        }
        return x0;
    }

    private double nextIteration(double correctionConstant, CompletionService<ModelExpactationComputeTask> completionService) {
        int pi;
        int i;
        double loglikelihood = 0.0;
        int numEvents = 0;
        int numCorrect = 0;
        int numberOfThreads = this.modelExpects.length;
        int taskSize = this.numUniqueEvents / numberOfThreads;
        int leftOver = this.numUniqueEvents % numberOfThreads;
        for (i = 0; i < numberOfThreads; ++i) {
            if (i < leftOver) {
                completionService.submit(new ModelExpactationComputeTask(i, i * taskSize + i, taskSize + 1));
                continue;
            }
            completionService.submit(new ModelExpactationComputeTask(i, i * taskSize + leftOver, taskSize));
        }
        for (i = 0; i < numberOfThreads; ++i) {
            ModelExpactationComputeTask finishedTask;
            try {
                finishedTask = completionService.take().get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new IllegalStateException("Interruption is not supported!", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Exception during training: " + e.getMessage(), e);
            }
            numEvents += finishedTask.getNumEvents();
            numCorrect += finishedTask.getNumCorrect();
            loglikelihood += finishedTask.getLoglikelihood();
        }
        this.display(".");
        for (pi = 0; pi < this.numPreds; ++pi) {
            int[] activeOutcomes = this.params[pi].getOutcomes();
            for (int aoi = 0; aoi < activeOutcomes.length; ++aoi) {
                for (int i2 = 1; i2 < this.modelExpects.length; ++i2) {
                    this.modelExpects[0][pi].updateParameter(aoi, this.modelExpects[i2][pi].getParameters()[aoi]);
                }
            }
        }
        this.display(".");
        for (pi = 0; pi < this.numPreds; ++pi) {
            double[] observed = this.observedExpects[pi].getParameters();
            double[] model = this.modelExpects[0][pi].getParameters();
            int[] activeOutcomes = this.params[pi].getOutcomes();
            for (int aoi = 0; aoi < activeOutcomes.length; ++aoi) {
                if (this.useGaussianSmoothing) {
                    this.params[pi].updateParameter(aoi, this.gaussianUpdate(pi, aoi, numEvents, correctionConstant));
                } else {
                    if (model[aoi] == 0.0) {
                        System.err.println("Model expects == 0 for " + this.predLabels[pi] + " " + this.outcomeLabels[aoi]);
                    }
                    this.params[pi].updateParameter(aoi, (Math.log(observed[aoi]) - Math.log(model[aoi])) / correctionConstant);
                }
                for (MutableContext[] modelExpect : this.modelExpects) {
                    modelExpect[pi].setParameter(aoi, 0.0);
                }
            }
        }
        this.display(". loglikelihood=" + loglikelihood + "\t" + (double)numCorrect / (double)numEvents + "\n");
        return loglikelihood;
    }

    private void display(String s) {
        if (this.printMessages) {
            System.out.print(s);
        }
    }

    private class ModelExpactationComputeTask
    implements Callable<ModelExpactationComputeTask> {
        private final int startIndex;
        private final int length;
        private double loglikelihood = 0.0;
        private int numEvents = 0;
        private int numCorrect = 0;
        private final int threadIndex;

        ModelExpactationComputeTask(int threadIndex, int startIndex, int length) {
            this.startIndex = startIndex;
            this.length = length;
            this.threadIndex = threadIndex;
        }

        @Override
        public ModelExpactationComputeTask call() {
            double[] modelDistribution = new double[GISTrainer.this.numOutcomes];
            for (int ei = this.startIndex; ei < this.startIndex + this.length; ++ei) {
                if (GISTrainer.this.values != null) {
                    GISTrainer.this.prior.logPrior(modelDistribution, GISTrainer.this.contexts[ei], GISTrainer.this.values[ei]);
                    GISModel.eval(GISTrainer.this.contexts[ei], GISTrainer.this.values[ei], modelDistribution, GISTrainer.this.evalParams);
                } else {
                    GISTrainer.this.prior.logPrior(modelDistribution, GISTrainer.this.contexts[ei]);
                    GISModel.eval(GISTrainer.this.contexts[ei], modelDistribution, GISTrainer.this.evalParams);
                }
                for (int j = 0; j < GISTrainer.this.contexts[ei].length; ++j) {
                    int pi = GISTrainer.this.contexts[ei][j];
                    if (GISTrainer.this.predicateCounts[pi] < GISTrainer.this.cutoff) continue;
                    int[] activeOutcomes = GISTrainer.this.modelExpects[this.threadIndex][pi].getOutcomes();
                    for (int aoi = 0; aoi < activeOutcomes.length; ++aoi) {
                        int oi = activeOutcomes[aoi];
                        if (GISTrainer.this.values != null && GISTrainer.this.values[ei] != null) {
                            GISTrainer.this.modelExpects[this.threadIndex][pi].updateParameter(aoi, modelDistribution[oi] * (double)GISTrainer.this.values[ei][j] * (double)GISTrainer.this.numTimesEventsSeen[ei]);
                            continue;
                        }
                        GISTrainer.this.modelExpects[this.threadIndex][pi].updateParameter(aoi, modelDistribution[oi] * (double)GISTrainer.this.numTimesEventsSeen[ei]);
                    }
                }
                this.loglikelihood += Math.log(modelDistribution[GISTrainer.this.outcomeList[ei]]) * (double)GISTrainer.this.numTimesEventsSeen[ei];
                this.numEvents += GISTrainer.this.numTimesEventsSeen[ei];
                if (!GISTrainer.this.printMessages) continue;
                int max = 0;
                for (int oi = 1; oi < GISTrainer.this.numOutcomes; ++oi) {
                    if (!(modelDistribution[oi] > modelDistribution[max])) continue;
                    max = oi;
                }
                if (max != GISTrainer.this.outcomeList[ei]) continue;
                this.numCorrect += GISTrainer.this.numTimesEventsSeen[ei];
            }
            return this;
        }

        synchronized int getNumEvents() {
            return this.numEvents;
        }

        synchronized int getNumCorrect() {
            return this.numCorrect;
        }

        synchronized double getLoglikelihood() {
            return this.loglikelihood;
        }
    }
}

