/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.Serializable;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.ParameterExpression;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.DelegatingQuery;
import org.apache.openjpa.kernel.DelegatingResultList;
import org.apache.openjpa.kernel.DistinctResultList;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.PreparedQuery;
import org.apache.openjpa.kernel.PreparedQueryCache;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.kernel.QueryStatistics;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.OrderedMap;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.FetchPlanImpl;
import org.apache.openjpa.persistence.HintHandler;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.LockTimeoutException;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.OpenJPAQuerySPI;
import org.apache.openjpa.persistence.ParameterImpl;
import org.apache.openjpa.persistence.PersistenceException;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.QueryOperationType;
import org.apache.openjpa.persistence.QueryTimeoutException;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.RuntimeExceptionTranslator;
import org.apache.openjpa.util.UserException;

public class QueryImpl<X>
implements OpenJPAQuerySPI<X>,
Serializable {
    private static final Localizer _loc = Localizer.forPackage(QueryImpl.class);
    private DelegatingQuery _query;
    private transient EntityManagerImpl _em;
    private transient FetchPlan _fetch;
    private Map<Parameter<?>, Object> _boundParams;
    private Map<Object, Parameter<?>> _declaredParams;
    private String _id;
    private transient ReentrantLock _lock = null;
    private HintHandler _hintHandler;
    private boolean _relaxBindParameterTypeChecking;
    private boolean _convertPositionalParams;

    public QueryImpl(EntityManagerImpl em, RuntimeExceptionTranslator ret, Query query) {
        this._em = em;
        this._query = new DelegatingQuery(query, ret);
        this._lock = new ReentrantLock();
        if (query.getLanguage() == "openjpa.SQL") {
            this._convertPositionalParams = false;
        } else {
            Compatibility compat = query.getStoreContext().getConfiguration().getCompatibilityInstance();
            this._convertPositionalParams = compat.getConvertPositionalParametersToNamed();
        }
    }

    public QueryImpl(EntityManagerImpl em, Query query) {
        this(em, null, query);
    }

    public Query getDelegate() {
        return this._query.getDelegate();
    }

    @Override
    public OpenJPAEntityManager getEntityManager() {
        return this._em;
    }

    @Override
    public String getLanguage() {
        return this._query.getLanguage();
    }

    @Override
    public QueryOperationType getOperation() {
        return QueryOperationType.fromKernelConstant(this._query.getOperation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchPlan getFetchPlan() {
        this._em.assertNotCloseInvoked();
        this._query.assertNotSerialized();
        this._query.lock();
        try {
            if (this._fetch == null) {
                this._fetch = ((EntityManagerFactoryImpl)this._em.getEntityManagerFactory()).toFetchPlan(this._query.getBroker(), this._query.getFetchConfiguration());
            }
            FetchPlan fetchPlan = this._fetch;
            return fetchPlan;
        }
        finally {
            this._query.unlock();
        }
    }

    @Override
    public String getQueryString() {
        String result = this._query.getQueryString();
        return result != null ? result : this._id;
    }

    @Override
    public boolean getIgnoreChanges() {
        return this._query.getIgnoreChanges();
    }

    @Override
    public OpenJPAQuery<X> setIgnoreChanges(boolean ignore) {
        this._em.assertNotCloseInvoked();
        this._query.setIgnoreChanges(ignore);
        return this;
    }

    @Override
    public OpenJPAQuery<X> addFilterListener(FilterListener listener) {
        this._em.assertNotCloseInvoked();
        this._query.addFilterListener(listener);
        return this;
    }

    @Override
    public OpenJPAQuery<X> removeFilterListener(FilterListener listener) {
        this._em.assertNotCloseInvoked();
        this._query.removeFilterListener(listener);
        return this;
    }

    @Override
    public OpenJPAQuery<X> addAggregateListener(AggregateListener listener) {
        this._em.assertNotCloseInvoked();
        this._query.addAggregateListener(listener);
        return this;
    }

    @Override
    public OpenJPAQuery<X> removeAggregateListener(AggregateListener listener) {
        this._em.assertNotCloseInvoked();
        this._query.removeAggregateListener(listener);
        return this;
    }

    @Override
    public Collection<?> getCandidateCollection() {
        return this._query.getCandidateCollection();
    }

    @Override
    public OpenJPAQuery<X> setCandidateCollection(Collection coll) {
        this._em.assertNotCloseInvoked();
        this._query.setCandidateCollection(coll);
        return this;
    }

    @Override
    public Class getResultClass() {
        Class res = this._query.getResultType();
        if (res != null) {
            return res;
        }
        return this._query.getCandidateType();
    }

    @Override
    public OpenJPAQuery<X> setResultClass(Class cls) {
        this._em.assertNotCloseInvoked();
        if (ImplHelper.isManagedType(this._em.getConfiguration(), cls)) {
            this._query.setCandidateType(cls, true);
        } else {
            this._query.setResultType(cls);
        }
        return this;
    }

    @Override
    public boolean hasSubclasses() {
        return this._query.hasSubclasses();
    }

    @Override
    public OpenJPAQuery<X> setSubclasses(boolean subs) {
        this._em.assertNotCloseInvoked();
        Class cls = this._query.getCandidateType();
        this._query.setCandidateExtent(this._query.getBroker().newExtent(cls, subs));
        return this;
    }

    @Override
    public int getFirstResult() {
        return QueryImpl.asInt(this._query.getStartRange());
    }

    @Override
    public OpenJPAQuery<X> setFirstResult(int startPosition) {
        this._em.assertNotCloseInvoked();
        long end = this._query.getEndRange() == Long.MAX_VALUE ? Long.MAX_VALUE : (long)startPosition + (this._query.getEndRange() - this._query.getStartRange());
        this._query.setRange(startPosition, end);
        return this;
    }

    @Override
    public int getMaxResults() {
        return QueryImpl.asInt(this._query.getEndRange() - this._query.getStartRange());
    }

    @Override
    public OpenJPAQuery<X> setMaxResults(int max) {
        this._em.assertNotCloseInvoked();
        long start = this._query.getStartRange();
        if (max == Integer.MAX_VALUE) {
            this._query.setRange(start, Long.MAX_VALUE);
        } else {
            this._query.setRange(start, start + (long)max);
        }
        return this;
    }

    @Override
    public boolean getRelaxBindParameterTypeChecking() {
        return this._relaxBindParameterTypeChecking;
    }

    @Override
    public void setRelaxBindParameterTypeChecking(Object value) {
        if (value != null) {
            if (value instanceof String) {
                this._relaxBindParameterTypeChecking = "true".equalsIgnoreCase(value.toString());
            } else if (value instanceof Boolean) {
                this._relaxBindParameterTypeChecking = (Boolean)value;
            }
        }
    }

    @Override
    public OpenJPAQuery<X> compile() {
        this._em.assertNotCloseInvoked();
        this._query.compile();
        return this;
    }

    Map<Object, Object> getParameterValues() {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        if (this._boundParams == null) {
            return result;
        }
        for (Map.Entry<Object, Parameter<?>> entry : this.getDeclaredParameters().entrySet()) {
            Object paramKey = entry.getKey();
            Parameter<?> param = entry.getValue();
            result.put(paramKey, this._boundParams.get(param));
        }
        return result;
    }

    private Object execute() {
        if (!this.isNative() && this._query.getOperation() != 1) {
            throw new InvalidStateException(_loc.get("not-select-query", this.getQueryString()), null, null, false);
        }
        try {
            this.lock();
            Map<Object, Object> params = this.getParameterValues();
            boolean registered = this.preExecute(params);
            Object result = this._query.execute((Map)params);
            if (registered) {
                this.postExecute(result);
            }
            Object object = result;
            return object;
        }
        catch (LockTimeoutException e) {
            throw new QueryTimeoutException(e.getMessage(), new Throwable[]{e}, (Object)this);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getResultList() {
        this._em.assertNotCloseInvoked();
        boolean queryFetchPlanUsed = this.pushQueryFetchPlan();
        try {
            Object ob = this.execute();
            if (ob instanceof List) {
                List ret = (List)ob;
                if (ret instanceof ResultList) {
                    RuntimeExceptionTranslator trans = PersistenceExceptions.getRollbackTranslator(this._em);
                    if (this._query.isDistinct()) {
                        DistinctResultList distinctResultList = new DistinctResultList((ResultList)ret, trans);
                        return distinctResultList;
                    }
                    DelegatingResultList delegatingResultList = new DelegatingResultList((ResultList)ret, trans);
                    return delegatingResultList;
                }
                List list = ret;
                return list;
            }
            List<Object> list = Collections.singletonList(ob);
            return list;
        }
        finally {
            this.popQueryFetchPlan(queryFetchPlanUsed);
        }
    }

    @Override
    public X getSingleResult() {
        this._em.assertNotCloseInvoked();
        this.setHint("openjpa.hint.OptimizeResultCount", 1);
        boolean queryFetchPlanUsed = this.pushQueryFetchPlan();
        try {
            Object e;
            List result = this.getResultList();
            if (result == null || result.isEmpty()) {
                throw new NoResultException(_loc.get("no-result", this.getQueryString()).getMessage());
            }
            if (result.size() > 1) {
                throw new NonUniqueResultException(_loc.get("non-unique-result", this.getQueryString(), result.size()).getMessage());
            }
            try {
                e = result.get(0);
            }
            catch (Exception e2) {
                throw new NoResultException(_loc.get("no-result", this.getQueryString()).getMessage());
            }
            return (X)e;
        }
        finally {
            this.popQueryFetchPlan(queryFetchPlanUsed);
        }
    }

    private boolean pushQueryFetchPlan() {
        boolean fcPushed = false;
        if (this._fetch != null && this._hintHandler != null) {
            switch (this._fetch.getReadLockMode()) {
                case PESSIMISTIC_READ: 
                case PESSIMISTIC_WRITE: 
                case PESSIMISTIC_FORCE_INCREMENT: {
                    this._em.pushFetchPlan(((FetchPlanImpl)this._fetch).getDelegate());
                    fcPushed = true;
                }
            }
        }
        return fcPushed;
    }

    private void popQueryFetchPlan(boolean queryFetchPlanUsed) {
        if (queryFetchPlanUsed) {
            this._em.popFetchPlan();
        }
    }

    @Override
    public int executeUpdate() {
        this._em.assertNotCloseInvoked();
        Map<Object, Object> paramValues = this.getParameterValues();
        if (this._query.getOperation() == 2) {
            return QueryImpl.asInt(paramValues.isEmpty() ? this._query.deleteAll() : this._query.deleteAll((Map)paramValues));
        }
        if (this._query.getOperation() == 3) {
            return QueryImpl.asInt(paramValues.isEmpty() ? this._query.updateAll() : this._query.updateAll((Map)paramValues));
        }
        throw new InvalidStateException(_loc.get("not-update-delete-query", this.getQueryString()), null, null, false);
    }

    private static int asInt(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    @Override
    public FlushModeType getFlushMode() {
        return EntityManagerImpl.fromFlushBeforeQueries(this._query.getFetchConfiguration().getFlushBeforeQueries());
    }

    @Override
    public OpenJPAQuery<X> setFlushMode(FlushModeType flushMode) {
        this._em.assertNotCloseInvoked();
        this._query.getFetchConfiguration().setFlushBeforeQueries(EntityManagerImpl.toFlushBeforeQueries(flushMode));
        return this;
    }

    public boolean isNative() {
        return "openjpa.SQL".equals(this.getLanguage());
    }

    void assertJPQLOrCriteriaQuery() {
        String language = this.getLanguage();
        if ("javax.persistence.JPQL".equals(language) || "openjpa.prepared.SQL".equals(language) || "javax.persistence.criteria".equals(language)) {
            return;
        }
        throw new IllegalStateException(_loc.get("not-jpql-or-criteria-query").getMessage());
    }

    @Override
    public OpenJPAQuery<X> closeAll() {
        this._query.closeAll();
        return this;
    }

    @Override
    public String[] getDataStoreActions(Map params) {
        return this._query.getDataStoreActions(params);
    }

    @Override
    public LockModeType getLockMode() {
        this.assertJPQLOrCriteriaQuery();
        return this.getFetchPlan().getReadLockMode();
    }

    @Override
    public TypedQuery<X> setLockMode(LockModeType lockMode) {
        String language = this.getLanguage();
        if ("openjpa.prepared.SQL".equals(language)) {
            this.ignorePreparedQuery();
        }
        this.assertJPQLOrCriteriaQuery();
        this.getFetchPlan().setReadLockMode(lockMode);
        return this;
    }

    public int hashCode() {
        return this._query == null ? 0 : this._query.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (this._query == null) {
            return false;
        }
        return this._query.equals(((QueryImpl)other)._query);
    }

    @Override
    public Map<String, Object> getHints() {
        if (this._hintHandler == null) {
            return Collections.emptyMap();
        }
        return this._hintHandler.getHints();
    }

    @Override
    public OpenJPAQuery<X> setHint(String key, Object value) {
        this._em.assertNotCloseInvoked();
        if (this._hintHandler == null) {
            this._hintHandler = new HintHandler(this);
        }
        this._hintHandler.setHint(key, value);
        return this;
    }

    @Override
    public Set<String> getSupportedHints() {
        if (this._hintHandler == null) {
            this._hintHandler = new HintHandler(this);
        }
        return this._hintHandler.getSupportedHints();
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        Object[] delegates;
        for (Object o : delegates = new Object[]{this._query.getInnermostDelegate(), this._query.getDelegate(), this._query, this}) {
            if (cls == null || cls == Object.class || !cls.isInstance(o)) continue;
            return (T)o;
        }
        PersistenceException ex = new PersistenceException(_loc.get("unwrap-query-invalid", cls).toString(), null, this, false);
        if (this._em.isActive()) {
            this._em.setRollbackOnly(ex);
        }
        throw ex;
    }

    private boolean preExecute(Map params) {
        PreparedQueryCache cache = this._em.getPreparedQueryCache();
        if (cache == null) {
            return false;
        }
        FetchConfiguration fetch = this._query.getFetchConfiguration();
        if (fetch.getReadLockLevel() != 0) {
            if (cache.get(this._id) != null) {
                this.ignorePreparedQuery();
            }
            return false;
        }
        Boolean registered = cache.register(this._id, this._query, fetch);
        boolean alreadyCached = registered == null;
        String lang = this._query.getLanguage();
        QueryStatistics<String> stats = cache.getStatistics();
        if (alreadyCached && "openjpa.prepared.SQL".equals(lang)) {
            PreparedQuery pq = this._em.getPreparedQuery(this._id);
            if (pq.isInitialized()) {
                try {
                    Map rep = pq.reparametrize(params, this._em.getBroker());
                    params.clear();
                    params.putAll(rep);
                }
                catch (UserException ue) {
                    this.invalidatePreparedQuery();
                    Log log = this._em.getConfiguration().getLog("openjpa.Runtime");
                    if (log.isWarnEnabled()) {
                        log.warn(ue.getMessage());
                    }
                    return false;
                }
            }
            stats.recordExecution(pq.getOriginalQuery());
        } else {
            stats.recordExecution(this.getQueryString());
        }
        return registered == Boolean.TRUE;
    }

    private boolean postExecute(Object result) {
        PreparedQueryCache cache = this._em.getPreparedQueryCache();
        if (cache == null) {
            return false;
        }
        return cache.initialize(this._id, result) != null;
    }

    boolean invalidatePreparedQuery() {
        PreparedQueryCache cache = this._em.getPreparedQueryCache();
        if (cache == null) {
            return false;
        }
        this.ignorePreparedQuery();
        return cache.invalidate(this._id);
    }

    void ignorePreparedQuery() {
        PreparedQuery cached = this._em.getPreparedQuery(this._id);
        if (cached == null) {
            return;
        }
        Broker broker = this._em.getBroker();
        String JPQL2 = "javax.persistence.JPQL";
        String jpql = this._id;
        Query newQuery = broker.newQuery(JPQL2, jpql);
        newQuery.getFetchConfiguration().copy(this._query.getFetchConfiguration());
        newQuery.compile();
        this._query = new DelegatingQuery(newQuery, this._em.getExceptionTranslator());
    }

    QueryImpl setId(String id) {
        this._id = id;
        return this;
    }

    void lock() {
        if (this._lock != null) {
            this._lock.lock();
        }
    }

    void unlock() {
        if (this._lock != null) {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenJPAQuery<X> setParameter(int pos, Object value) {
        if (this._convertPositionalParams) {
            return this.setParameter("_" + String.valueOf(pos), value);
        }
        this._query.assertOpen();
        this._em.assertNotCloseInvoked();
        this._query.lock();
        try {
            if (pos < 1) {
                throw new IllegalArgumentException(_loc.get("illegal-index", pos).getMessage());
            }
            Parameter<?> param = null;
            if (this.isNative()) {
                param = new ParameterImpl<Object>(pos, Object.class);
                this.declareParameter(pos, param);
            } else {
                param = this.getParameter(pos);
            }
            this.bindValue(param, value);
            QueryImpl queryImpl = this;
            return queryImpl;
        }
        finally {
            this._query.unlock();
        }
    }

    @Override
    public OpenJPAQuery<X> setParameter(int position, Calendar value, TemporalType t) {
        return this.setParameter(position, this.convertTemporalType(value, t));
    }

    @Override
    public OpenJPAQuery<X> setParameter(int position, Date value, TemporalType type) {
        return this.setParameter(position, this.convertTemporalType(value, type));
    }

    Object convertTemporalType(Date value, TemporalType type) {
        switch (type) {
            case DATE: {
                return value;
            }
            case TIME: {
                return new Time(value.getTime());
            }
            case TIMESTAMP: {
                return new Timestamp(value.getTime());
            }
        }
        return null;
    }

    Object convertTemporalType(Calendar value, TemporalType type) {
        return this.convertTemporalType(value.getTime(), type);
    }

    @Override
    public boolean hasPositionalParameters() {
        return !this.getDeclaredParameterKeys(Integer.class).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getPositionalParameters() {
        this._query.lock();
        try {
            Set<Integer> positionalKeys = this.getDeclaredParameterKeys(Integer.class);
            Object[] result = new Object[this.calculateMaxKey(positionalKeys)];
            for (Integer pos : positionalKeys) {
                Parameter<?> param = this.getParameter(pos);
                result[pos.intValue() - 1] = this.isBound(param) ? this.getParameterValue(pos) : null;
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            this._query.unlock();
        }
    }

    int calculateMaxKey(Set<Integer> p) {
        if (p == null) {
            return 0;
        }
        int max = Integer.MIN_VALUE;
        for (Integer i : p) {
            max = Math.max(max, i);
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenJPAQuery<X> setParameters(Object ... params) {
        this._query.assertOpen();
        this._em.assertNotCloseInvoked();
        this._query.lock();
        try {
            this.clearBinding();
            for (int i = 0; params != null && i < params.length; ++i) {
                this.setParameter(i + 1, params[i]);
            }
            QueryImpl queryImpl = this;
            return queryImpl;
        }
        finally {
            this._query.unlock();
        }
    }

    void clearBinding() {
        if (this._boundParams != null) {
            this._boundParams.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getNamedParameters() {
        this._query.lock();
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Set<String> namedKeys = this.getDeclaredParameterKeys(String.class);
            Iterator<String> i$ = namedKeys.iterator();
            while (i$.hasNext()) {
                String name;
                Parameter<?> param = this.getParameter(name = i$.next());
                result.put(name, this.isBound(param) ? this.getParameterValue(name) : null);
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            this._query.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenJPAQuery<X> setParameters(Map params) {
        this._query.assertOpen();
        this._em.assertNotCloseInvoked();
        this._query.lock();
        try {
            this.clearBinding();
            if (params != null) {
                for (Map.Entry e : params.entrySet()) {
                    this.setParameter((String)e.getKey(), e.getValue());
                }
            }
            QueryImpl queryImpl = this;
            return queryImpl;
        }
        finally {
            this._query.unlock();
        }
    }

    @Override
    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        Parameter<?> param = this.getParameter(name);
        if (param.getParameterType().isAssignableFrom(type)) {
            throw new IllegalArgumentException(param + " does not match the requested type " + type);
        }
        return param;
    }

    @Override
    public <T> Parameter<T> getParameter(int pos, Class<T> type) {
        if (this._convertPositionalParams) {
            return this.getParameter("_" + String.valueOf(pos), type);
        }
        Parameter<?> param = this.getParameter(pos);
        if (param.getParameterType().isAssignableFrom(type)) {
            throw new IllegalArgumentException(param + " does not match the requested type " + type);
        }
        return param;
    }

    @Override
    public <T> T getParameterValue(Parameter<T> p) {
        if (!this.isBound(p)) {
            throw new IllegalArgumentException(_loc.get("param-missing", p, this.getQueryString(), this.getBoundParameterKeys()).getMessage());
        }
        return (T)this._boundParams.get(p);
    }

    @Override
    public Set<Parameter<?>> getParameters() {
        HashSet result = new HashSet();
        result.addAll(this.getDeclaredParameters().values());
        return result;
    }

    @Override
    public <T> OpenJPAQuery<X> setParameter(Parameter<T> p, T arg1) {
        this.bindValue(p, arg1);
        return this;
    }

    @Override
    public OpenJPAQuery<X> setParameter(Parameter<Date> p, Date date, TemporalType type) {
        return this.setParameter((Parameter)p, (Object)((Date)this.convertTemporalType(date, type)));
    }

    @Override
    public TypedQuery<X> setParameter(Parameter<Calendar> p, Calendar cal, TemporalType type) {
        return this.setParameter((Parameter)p, (Object)((Calendar)this.convertTemporalType(cal, type)));
    }

    @Override
    public Parameter<?> getParameter(String name) {
        if (this.isNative()) {
            throw new IllegalStateException(_loc.get("param-named-non-native", name).getMessage());
        }
        Parameter<?> param = this.getDeclaredParameters().get(name);
        if (param == null) {
            Set<ParameterExpression> exps = this.getDeclaredParameterKeys(ParameterExpression.class);
            for (ParameterExpression e : exps) {
                if (!name.equals(e.getName())) continue;
                return e;
            }
            throw new IllegalArgumentException(_loc.get("param-missing-name", name, this.getQueryString(), this.getDeclaredParameterKeys()).getMessage());
        }
        return param;
    }

    @Override
    public Parameter<?> getParameter(int pos) {
        if (this._convertPositionalParams) {
            return this.getParameter("_" + String.valueOf(pos));
        }
        Parameter<?> param = this.getDeclaredParameters().get(pos);
        if (param == null) {
            throw new IllegalArgumentException(_loc.get("param-missing-pos", pos, this.getQueryString(), this.getDeclaredParameterKeys()).getMessage());
        }
        return param;
    }

    @Override
    public Object getParameterValue(String name) {
        return this._boundParams.get(this.getParameter(name));
    }

    @Override
    public Object getParameterValue(int pos) {
        Parameter<?> param = this.getParameter(pos);
        this.assertBound(param);
        return this._boundParams.get(param);
    }

    public Set<?> getBoundParameterKeys() {
        if (this._boundParams == null) {
            return Collections.EMPTY_SET;
        }
        this.getDeclaredParameters();
        HashSet<Object> result = new HashSet<Object>();
        for (Map.Entry<Object, Parameter<?>> entry : this._declaredParams.entrySet()) {
            if (!this.isBound(entry.getValue())) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public Set<?> getDeclaredParameterKeys() {
        return this.getDeclaredParameters().keySet();
    }

    public <T> Set<T> getDeclaredParameterKeys(Class<T> keyType) {
        HashSet result = new HashSet();
        for (Object key : this.getDeclaredParameterKeys()) {
            if (!keyType.isInstance(key)) continue;
            result.add(key);
        }
        return result;
    }

    public Map<Object, Parameter<?>> getDeclaredParameters() {
        if (this._declaredParams == null) {
            this._declaredParams = new HashMap();
            OrderedMap<Object, Class<?>> paramTypes = this._query.getOrderedParameterTypes();
            for (Map.Entry<Object, Class<?>> entry : paramTypes.entrySet()) {
                Parameter<Object> param;
                Object key = entry.getKey();
                Class<?> expectedValueType = entry.getValue();
                if (key instanceof Integer) {
                    param = new ParameterImpl((Integer)key, expectedValueType);
                } else if (key instanceof String) {
                    param = new ParameterImpl((String)key, expectedValueType);
                } else if (key instanceof Parameter) {
                    param = (Parameter)key;
                } else {
                    throw new IllegalArgumentException("parameter identifier " + key + " unrecognized");
                }
                this.declareParameter(key, param);
            }
        }
        return this._declaredParams;
    }

    public void declareParameter(Object key, Parameter<?> param) {
        if (this._declaredParams == null) {
            this._declaredParams = new HashMap();
        }
        this._declaredParams.put(key, param);
    }

    @Override
    public boolean isBound(Parameter<?> param) {
        return this._boundParams != null && this._boundParams.containsKey(param);
    }

    void assertBound(Parameter<?> param) {
        if (!this.isBound(param)) {
            throw new IllegalStateException(_loc.get("param-not-bound", param, this.getQueryString(), this.getBoundParameterKeys()).getMessage());
        }
    }

    void bindValue(Parameter<?> param, Object value) {
        Object bindVal = this.assertValueAssignable(param, value);
        if (this._boundParams == null) {
            this._boundParams = new HashMap();
        }
        this._boundParams.put(param, bindVal);
    }

    @Override
    public OpenJPAQuery<X> setParameter(String name, Calendar value, TemporalType type) {
        return this.setParameter(name, this.convertTemporalType(value, type));
    }

    @Override
    public OpenJPAQuery<X> setParameter(String name, Date value, TemporalType type) {
        return this.setParameter(name, this.convertTemporalType(value, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenJPAQuery<X> setParameter(String name, Object value) {
        this._query.assertOpen();
        this._em.assertNotCloseInvoked();
        this._query.lock();
        try {
            if (this.isNative()) {
                throw new IllegalArgumentException(_loc.get("no-named-params", name, this.getQueryString()).toString());
            }
            this.bindValue(this.getParameter(name), value);
            QueryImpl queryImpl = this;
            return queryImpl;
        }
        finally {
            this._query.unlock();
        }
    }

    Object assertValueAssignable(Parameter<?> param, Object v) {
        Class<?> expectedType = param.getParameterType();
        if (v == null) {
            if (expectedType.isPrimitive()) {
                throw new IllegalArgumentException(_loc.get("param-null-primitive", param).getMessage());
            }
            return v;
        }
        if (this.getRelaxBindParameterTypeChecking()) {
            try {
                return Filters.convert(v, expectedType);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(_loc.get("param-type-mismatch", new Object[]{param, this.getQueryString(), v, v.getClass().getName(), expectedType.getName()}).getMessage());
            }
        }
        if (!Filters.canConvert(v.getClass(), expectedType, true)) {
            throw new IllegalArgumentException(_loc.get("param-type-mismatch", new Object[]{param, this.getQueryString(), v, v.getClass().getName(), expectedType.getName()}).getMessage());
        }
        return v;
    }

    public String toString() {
        String result = this._query.getQueryString();
        return result != null ? result : this._id;
    }
}

