/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;

public class IngresDictionary
extends DBDictionary {
    public IngresDictionary() {
        this.platform = "Ingres";
        this.driverVendor = "Ingres Corporation";
        this.maxColumnNameLength = 32;
        this.maxConstraintNameLength = 32;
        this.maxIndexNameLength = 32;
        this.maxTableNameLength = 32;
        this.supportsDeferredConstraints = false;
        this.schemaCase = "lower";
        this.systemSchemas = "$ingres";
        this.supportsDefaultDeleteAction = false;
        this.supportsDefaultUpdateAction = false;
        this.validationSQL = "SELECT DATE('now')";
        this.rangePosition = 0;
        this.supportsLockingWithDistinctClause = false;
        this.supportsLockingWithInnerJoin = false;
        this.supportsLockingWithMultipleTables = false;
        this.supportsLockingWithOuterJoin = false;
        this.supportsSelectEndIndex = true;
        this.supportsMultipleNontransactionalResultSets = false;
        this.allowsAliasInBulkClause = false;
        this.requiresCastForMathFunctions = true;
        this.requiresAliasForSubselect = true;
        this.stringLengthFunction = "LENGTH({0})";
        this.binaryTypeName = "BYTE";
        this.bitTypeName = "TINYINT";
        this.blobTypeName = "LONG BYTE";
        this.booleanTypeName = "TINYINT";
        this.charTypeName = "CHAR";
        this.clobTypeName = "LONG NVARCHAR";
        this.javaObjectTypeName = "LONG BYTE";
        this.numericTypeName = "DECIMAL";
        this.doubleTypeName = "FLOAT";
        this.longVarcharTypeName = "LONG NVARCHAR";
        this.longVarbinaryTypeName = "LONG BYTE";
        this.varbinaryTypeName = "LONG BYTE";
        this.datePrecision = 1;
        this.supportsNullTableForGetImportedKeys = true;
        this.supportsNullTableForGetImportedKeys = true;
        this.supportsNullTableForGetIndexInfo = true;
        this.supportsNullTableForGetPrimaryKeys = true;
        this.tableTypes = "TABLE,VIEW,SYSTEM TABLE";
        this.requiresAutoCommitForMetaData = true;
        this.maxAutoAssignNameLength = 32;
        this.supportsAutoAssign = false;
        this.autoAssignClause = null;
        this.autoAssignTypeName = null;
        this.sequenceSQL = "SELECT seq_name AS SEQUENCE_NAME, seq_owner AS SEQUENCE_SCHEMA FROM iisequences";
        this.sequenceNameSQL = "seq_name = ?";
        this.sequenceSchemaSQL = "seq_owner = ?";
        this.nextSequenceQuery = "SELECT NEXT VALUE FOR {0}";
        this.systemTables = "iiaccess, iialt_columns, iiattribute, iiaudit, iiaudittables, iicdbid_idx, iicolumns, iiconstraint_indexes, iiconstraints, iidatabase, iidatabase_info, iidb_comments, iidb_subcomments, iidbcapabilities, iidbconstants, iidbdepends, iidbid_idx, iidbms_comment, iidbpriv, iidbprivileges, iiddb_netcost, iiddb_nodecosts, iidefault, iidefaultidx, iidevices, iidistcol, iidistcols, iidistscheme, iidistschemes, iidistval, iievent, iievents, iiextend, iiextend_info, iiextended_relation, iifile_info, iigw06_attribute, iigw06_relation, iigw07_attribute, iigw07_index, iigw07_relation, iihistogram, iihistograms, iiindex, iiindex_columns, iiindexes, iiingres_tables, iiintegrities, iiintegrity, iiintegrityidx, iikey, iikey_columns, iikeys, iilocation_info, iilocations, iilog_help, iilpartitions, iimulti_locations, iiocolumns, iiotables, iipartname, iipermits, iiphysical_columns, iiphysical_tables, iipriv, iiprivlist, iiproc_access, iiproc_params, iiprocedure, iiprocedure_parameter, iiprocedures, iiprofile, iiprofiles, iiprotect, iiqrytext, iirange, iiref_constraints, iiregistrations, iirel_idx, iirelation, iirole, iirolegrant, iirolegrants, iiroles, iirule, iiruleidx, iiruleidx1, iirules, iischema, iischemaidx, iisecalarm, iisectype, iisecurity_alarms, iisecurity_state, iisecuritystate, iisequence, iisequences, iisession_privileges, iistar_cdbinfo, iistar_cdbs, iistatistics, iistats, iisynonym, iisynonyms, iitables, iitree, iiuser, iiusergroup, iiusers, iiviews, iixdbdepends, iixevent, iixpriv, iixprocedure, iixsynonym, ii_abfclasses, ii_abfdependencies, ii_abfobjects, ii_app_cntns_comp, ii_app_cntns_comp_index, ii_applications, ii_atttype, ii_client_dep_mod, ii_components, ii_databases, ii_dbd_acl, ii_dbd_identifiers, ii_dbd_locations, ii_dbd_rightslist, ii_dbd_table_char, ii_defaults, ii_dependencies, ii_dependencies_index, ii_dependencies_index2, ii_dict_modules, ii_domains, ii_encoded_forms, ii_encodings, ii_entities, ii_entities_index, ii_enttype, ii_fields, ii_forms, ii_framevars, ii_gropts, ii_id, ii_incl_apps, ii_joindefs, ii_joinspecs, ii_key_info, ii_key_map, ii_limits, ii_locks, ii_longremarks, ii_menuargs, ii_objects, ii_objects_index, ii_qbfnames, ii_rcommands, ii_rel_cncts_ent, ii_reltype, ii_reports, ii_sequence_values, ii_sqlatts, ii_sqltables, ii_srcobj_encoded, ii_stored_bitmaps, ii_stored_strings, ii_trim, ii_vqjoins, ii_vqtabcols, ii_vqtables";
        this.fixedSizeTypeNames = "INTEGER,INTEGER1,INTEGER2,INTEGER4,INTEGER8,TINYINT,SMALLINT,BIGINT,FLOAT,FLOAT4,FLOAT8,REAL,DATE,INGRESDATE,ANSIDATE";
        this.reservedWords = "ABORT,BYREF,CALLPROC,COMMENT,COPY,DEFINE,DISABLE,DO,ELSEIF,ENABLE,ENDIF,ENDLOOP,ENDWHILE,EXCLUDING,IF,IMPORT,INDEX,INTEGRITY,MESSAGE,MODIFY,PERMIT,RAISE,REFERENCING,REGISTER,RELOCATE,REMOVE,REPEAT,RETURN,SAVE,SAVEPOINT,UNTIL,WHILE";
        this.invalidColumnWordSet.add("tid");
    }

    @Override
    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
        if (this.isVersion9_2orLater(conn)) {
            this.supportsSelectStartIndex = true;
        }
    }

    boolean isVersion9_2orLater(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        int dbMajorVersion = meta.getDatabaseMajorVersion();
        int dbMinorVersion = meta.getDatabaseMinorVersion();
        return dbMajorVersion == 9 && dbMinorVersion >= 2 || dbMajorVersion > 9;
    }

    @Override
    protected void appendSelectRange(SQLBuffer buf, long start, long end, boolean subselect) {
        if (!this.supportsSelectStartIndex && start > 0L) {
            throw new IllegalArgumentException("Ingres does not support start indexes for Select Ranges");
        }
        if (start > 0L && start != Long.MAX_VALUE && !subselect) {
            buf.append(" OFFSET ").append(Long.toString(start));
        }
        if (end > 0L && end != Long.MAX_VALUE && !subselect) {
            buf.append(" FETCH NEXT ").append(Long.toString(end)).append(" ROWS ONLY");
        }
    }

    @Override
    protected String getSequencesSQL(String schemaName, String sequenceName) {
        return this.getSequencesSQL(DBIdentifier.newSchema(schemaName), DBIdentifier.newSequence(sequenceName));
    }

    @Override
    protected String getSequencesSQL(DBIdentifier schemaName, DBIdentifier sequenceName) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.sequenceSQL);
        if (!DBIdentifier.isNull(schemaName) || !DBIdentifier.isNull(sequenceName)) {
            buf.append(" WHERE ");
        }
        if (!DBIdentifier.isNull(schemaName)) {
            buf.append(this.sequenceSchemaSQL);
            if (sequenceName != null) {
                buf.append(" AND ");
            }
        }
        if (!DBIdentifier.isNull(sequenceName)) {
            buf.append(this.sequenceNameSQL);
        }
        return buf.toString();
    }

    @Override
    protected Sequence newSequence(ResultSet sequenceMeta) throws SQLException {
        Sequence seq = super.newSequence(sequenceMeta);
        seq.setIdentifier(DBIdentifier.trim(seq.getIdentifier()));
        return seq;
    }

    @Override
    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        buf.append("(POSITION((");
        find.appendTo(buf);
        buf.append(") IN (");
        if (start != null) {
            this.substring(buf, str, start, null);
        } else {
            str.appendTo(buf);
        }
        buf.append(")) - 1");
        if (start != null) {
            buf.append(" + ");
            start.appendTo(buf);
        }
        buf.append(")");
    }

    @Override
    public void substring(SQLBuffer buf, FilterValue str, FilterValue start, FilterValue end) {
        long startLong;
        buf.append(this.substringFunctionName).append("(");
        str.appendTo(buf);
        buf.append(", ");
        if (start.getValue() instanceof Number) {
            startLong = this.toLong(start);
            buf.append(Long.toString(startLong + 1L));
        } else {
            buf.append("(CAST ((");
            start.appendTo(buf);
            buf.append(" + 1) AS INTEGER))");
        }
        if (end != null) {
            buf.append(", ");
            if (start.getValue() instanceof Number && end.getValue() instanceof Number) {
                startLong = this.toLong(start);
                long endLong = this.toLong(end);
                buf.append(Long.toString(endLong - startLong));
            } else {
                buf.append("(CAST (");
                end.appendTo(buf);
                buf.append(" - (");
                start.appendTo(buf);
                buf.append(") AS INTEGER))");
            }
        }
        buf.append(")");
    }
}

