/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.Router;
import org.apache.openejb.spi.ContainerSystem;

public class RoutedDataSource
implements DataSource {
    private static final String OPENEJB_RESOURCE_PREFIX = "openejb:Resource/";
    private Router delegate;

    public RoutedDataSource() {
    }

    public RoutedDataSource(String router) {
        this.setRouter(router);
    }

    public void setRouter(String router) {
        ContainerSystem containerSystem = SystemInstance.get().getComponent(ContainerSystem.class);
        Object o = null;
        Context ctx = containerSystem.getJNDIContext();
        try {
            o = ctx.lookup(OPENEJB_RESOURCE_PREFIX + router);
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Can't find router [" + router + "]", e);
        }
        if (!(o instanceof Router)) {
            throw new IllegalArgumentException(o + " is not a router");
        }
        this.delegate = (Router)o;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        if (this.getTargetDataSource() == null) {
            return null;
        }
        return this.getTargetDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        if (this.getTargetDataSource() != null) {
            this.getTargetDataSource().setLogWriter(out);
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        if (this.getTargetDataSource() != null) {
            this.getTargetDataSource().setLoginTimeout(seconds);
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        if (this.getTargetDataSource() == null) {
            return -1;
        }
        return this.getTargetDataSource().getLoginTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.getTargetDataSource() == null) {
            return null;
        }
        return (T)this.callByReflection(this.getTargetDataSource(), "unwrap", new Class[]{Class.class}, new Object[]{iface});
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        if (this.getTargetDataSource() == null) {
            return null;
        }
        return (Logger)this.callByReflection(this.getTargetDataSource(), "getParentLogger", new Class[0], null);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (this.getTargetDataSource() == null) {
            return false;
        }
        return (Boolean)this.callByReflection(this.getTargetDataSource(), "isWrapperFor", new Class[]{Class.class}, new Object[]{iface});
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getTargetDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getTargetDataSource().getConnection(username, password);
    }

    public Router getDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("a router has to be defined");
        }
        return this.delegate;
    }

    private DataSource getTargetDataSource() {
        return this.getDelegate().getDataSource();
    }

    private Object callByReflection(DataSource ds, String mtdName, Class<?>[] paramTypes, Object[] args) {
        try {
            Method mtd = ds.getClass().getDeclaredMethod(mtdName, paramTypes);
            return mtd.invoke((Object)ds, args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

