/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.io.Serializable;
import java.util.Date;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.NoMoreTimeoutsException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import org.apache.openejb.BeanContext;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.timer.CalendarTimerData;
import org.apache.openejb.core.timer.TimerData;
import org.apache.openejb.core.timer.TimerHandleImpl;
import org.apache.openejb.core.timer.TimerType;

public class TimerImpl
implements Timer {
    private final TimerData timerData;

    public TimerImpl(TimerData timerData) {
        this.timerData = timerData;
    }

    @Override
    public void cancel() throws IllegalStateException, NoSuchObjectLocalException {
        this.checkState();
        this.timerData.cancel();
    }

    @Override
    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException {
        this.checkState();
        Date nextTimeout = this.timerData.getNextTimeout();
        if (nextTimeout == null) {
            throw new NoMoreTimeoutsException("The timer has no future timeouts");
        }
        return this.timerData.getTimeRemaining();
    }

    @Override
    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException {
        this.checkState();
        Date nextTimeout = this.timerData.getNextTimeout();
        if (nextTimeout == null) {
            throw new NoMoreTimeoutsException("The timer has no future timeouts");
        }
        return this.timerData.getNextTimeout();
    }

    @Override
    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException {
        this.checkState();
        return (Serializable)this.timerData.getInfo();
    }

    @Override
    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException {
        this.checkState();
        if (!this.timerData.isPersistent()) {
            throw new IllegalStateException("can't getHandle for a non-persistent timer");
        }
        return new TimerHandleImpl(this.timerData.getId(), this.timerData.getDeploymentId());
    }

    @Override
    public ScheduleExpression getSchedule() throws EJBException, IllegalStateException, NoSuchObjectLocalException {
        this.checkState();
        if (this.timerData.getType() == TimerType.Calendar) {
            return ((CalendarTimerData)this.timerData).getSchedule();
        }
        throw new IllegalStateException("The target timer is not a calendar-based type ");
    }

    @Override
    public boolean isPersistent() throws EJBException, IllegalStateException, NoSuchObjectLocalException {
        this.checkState();
        return this.timerData.isPersistent();
    }

    @Override
    public boolean isCalendarTimer() throws EJBException, IllegalStateException, NoSuchObjectLocalException {
        this.checkState();
        return this.timerData.getType() == TimerType.Calendar;
    }

    private void checkState() throws IllegalStateException, NoSuchObjectLocalException {
        BeanContext beanContext = ThreadContext.getThreadContext().getBeanContext();
        BaseContext context = (BaseContext)beanContext.get(EJBContext.class);
        context.check(BaseContext.Call.timerMethod);
        if (this.timerData.isCancelled()) {
            throw new NoSuchObjectLocalException("Timer has been cancelled");
        }
        if (this.timerData.isExpired()) {
            throw new NoSuchObjectLocalException("The timer has expired");
        }
    }
}

